/*
 * Decompiled with CFR 0.152.
 */
package wile.engineersdecor.blocks;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.DirectionalPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import wile.engineersdecor.ModContent;
import wile.engineersdecor.blocks.EdCatwalkBlock;
import wile.engineersdecor.libmc.blocks.StandardBlocks;

public class EdCatwalkTopAlignedBlock
extends StandardBlocks.WaterLoggable {
    public static final IntegerProperty VARIANT = IntegerProperty.m_61631_((String)"variant", (int)0, (int)4);
    protected final List<VoxelShape> variant_shapes;
    protected final Block inset_light_block;

    public EdCatwalkTopAlignedBlock(long config, BlockBehaviour.Properties properties, VoxelShape[] variant_shapes, Block inset_light_block) {
        super(config, properties, variant_shapes[0]);
        this.m_49959_((BlockState)super.m_49966_().m_61124_((Property)VARIANT, (Comparable)Integer.valueOf(0)));
        this.variant_shapes = VARIANT.m_6908_().stream().map(i -> i < variant_shapes.length ? variant_shapes[i] : Shapes.m_83144_()).collect(Collectors.toList());
        this.inset_light_block = inset_light_block;
    }

    @Override
    public boolean m_7420_(BlockState state, BlockGetter reader, BlockPos pos) {
        return true;
    }

    @Override
    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext selectionContext) {
        return this.variant_shapes.get((Integer)state.m_61143_((Property)VARIANT));
    }

    @Override
    public VoxelShape m_5939_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext selectionContext) {
        return this.m_5940_(state, world, pos, selectionContext);
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{VARIANT});
    }

    @Override
    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState state = this.adapted_state(super.m_5573_(context), (LevelAccessor)context.m_43725_(), context.m_8083_());
        if (context.m_43719_() != Direction.UP) {
            return state;
        }
        BlockState below = context.m_43725_().m_8055_(context.m_8083_().m_7495_());
        if ((Integer)state.m_61143_((Property)VARIANT) == 0 && below.m_60783_((BlockGetter)context.m_43725_(), context.m_8083_().m_7495_(), Direction.UP)) {
            return (BlockState)state.m_61124_((Property)VARIANT, (Comparable)Integer.valueOf(3));
        }
        return state;
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        Item item = player.m_21120_(hand).m_41720_();
        if (!(item instanceof BlockItem)) {
            return InteractionResult.PASS;
        }
        Block block = ((BlockItem)item).m_40614_();
        if (block == this) {
            if (hit.m_82434_().m_122434_().m_122479_()) {
                return InteractionResult.PASS;
            }
            BlockPos adjacent_pos = pos.m_121945_(player.m_6350_());
            BlockState adjacent_state = world.m_8055_(adjacent_pos);
            if (adjacent_state.m_60629_((BlockPlaceContext)new DirectionalPlaceContext(world, adjacent_pos, hit.m_82434_().m_122424_(), player.m_21120_(hand), hit.m_82434_()))) {
                BlockState place_state = this.m_49966_();
                place_state = (BlockState)place_state.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(adjacent_state.m_60819_().m_76152_() == Fluids.f_76193_));
                EdCatwalkBlock.place_consume(this.adapted_state(place_state, (LevelAccessor)world, adjacent_pos), world, adjacent_pos, player, hand, 1);
            }
            return InteractionResult.m_19078_((boolean)world.m_5776_());
        }
        if (block == this.inset_light_block && hit.m_82434_() == Direction.DOWN) {
            int currentVariant = (Integer)state.m_61143_((Property)VARIANT);
            if (currentVariant != 0 && currentVariant != 4) {
                return InteractionResult.PASS;
            }
            boolean add = currentVariant == 0;
            EdCatwalkBlock.place_consume(this.adapted_state((BlockState)state.m_61124_((Property)VARIANT, (Comparable)Integer.valueOf(add ? 4 : 0)), (LevelAccessor)world, pos), world, pos, player, hand, add ? 1 : -1);
            return InteractionResult.m_19078_((boolean)world.m_5776_());
        }
        return InteractionResult.PASS;
    }

    @Override
    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor world, BlockPos pos, BlockPos facingPos) {
        return this.adapted_state(super.m_7417_(state, facing, facingState, world, pos, facingPos), world, pos);
    }

    private BlockState adapted_state(BlockState state, LevelAccessor world, BlockPos pos) {
        BlockState below = world.m_8055_(pos.m_7495_());
        if (state == null || (Integer)state.m_61143_((Property)VARIANT) == 4) {
            return state;
        }
        if (below.m_60734_() == ModContent.getBlock("thick_steel_pole") || below.m_60734_() == ModContent.getBlock("thick_steel_pole_head")) {
            return (BlockState)state.m_61124_((Property)VARIANT, (Comparable)Integer.valueOf(1));
        }
        if (below.m_60734_() == ModContent.getBlock("thin_steel_pole") || below.m_60734_() == ModContent.getBlock("thin_steel_pole_head")) {
            return (BlockState)state.m_61124_((Property)VARIANT, (Comparable)Integer.valueOf(2));
        }
        return state;
    }

    public int getLightEmission(BlockState state, BlockGetter level, BlockPos pos) {
        return (Integer)state.m_61143_((Property)VARIANT) == 4 ? this.inset_light_block.getLightEmission((BlockState)this.inset_light_block.m_49966_().m_61124_((Property)StandardBlocks.Directed.FACING, (Comparable)Direction.UP), level, pos) : super.getLightEmission(state, level, pos);
    }

    @Override
    public boolean hasDynamicDropList() {
        return true;
    }

    @Override
    public List<ItemStack> dropList(BlockState state, Level world, @Nullable BlockEntity te, boolean explosion) {
        if (world.m_5776_()) {
            return Collections.singletonList(ItemStack.f_41583_);
        }
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        drops.add(new ItemStack((ItemLike)state.m_60734_().m_5456_()));
        if ((Integer)state.m_61143_((Property)VARIANT) == 4) {
            drops.add(new ItemStack((ItemLike)this.inset_light_block, 1));
        }
        return drops;
    }
}

