/*
 * Decompiled with CFR 0.152.
 */
package wile.engineersdecor.blocks;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Stack;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import wile.engineersdecor.ModConfig;
import wile.engineersdecor.ModContent;
import wile.engineersdecor.libmc.blocks.StandardBlocks;
import wile.engineersdecor.libmc.blocks.StandardEntityBlocks;
import wile.engineersdecor.libmc.detail.Fluidics;

public class EdFluidFunnel {
    private static boolean with_device_fluid_handler_collection = false;

    public static void on_config(boolean with_tank_fluid_collection) {
        with_device_fluid_handler_collection = with_tank_fluid_collection;
        ModConfig.log("Config fluid funnel: tank-fluid-collection:" + with_device_fluid_handler_collection + ".");
    }

    public static class FluidFunnelTileEntity
    extends StandardEntityBlocks.StandardBlockEntity {
        public static final int TANK_CAPACITY = 3000;
        public static final int TICK_INTERVAL = 10;
        public static final int COLLECTION_INTERVAL = 40;
        public static final int MAX_TRACK_RADIUS = 16;
        public static final int MAX_TRACKING_STEPS_PER_CYCLE = 72;
        public static final int MAX_TRACKING_STEPS_PER_CYCLE_INTENSIVE = 1024;
        public static final int MAX_TRACK_RADIUS_SQ = 256;
        public static final int INTENSIVE_SEARCH_TRIGGER_THRESHOLD = 16;
        private int tick_timer_ = 0;
        private int collection_timer_ = 0;
        private int no_fluid_found_counter_ = 0;
        private int intensive_search_counter_ = 0;
        private int total_pick_counter_ = 0;
        private BlockPos last_pick_pos_ = BlockPos.f_121853_;
        private ArrayList<Vec3i> search_offsets_ = null;
        private final Fluidics.Tank tank_ = new Fluidics.Tank(3000, 0, 3000);
        private final LazyOptional<IFluidHandler> fluid_handler_ = this.tank_.createOutputFluidHandler();

        public FluidFunnelTileEntity(BlockPos pos, BlockState state) {
            super(ModContent.getBlockEntityTypeOfBlock(state.m_60734_()), pos, state);
        }

        public void readnbt(CompoundTag nbt) {
            this.tank_.load(nbt);
        }

        public void writenbt(CompoundTag nbt) {
            this.tank_.save(nbt);
        }

        public void block_changed() {
            this.tick_timer_ = 10;
        }

        public void m_142466_(CompoundTag nbt) {
            super.m_142466_(nbt);
            this.readnbt(nbt);
        }

        protected void m_183515_(CompoundTag nbt) {
            super.m_183515_(nbt);
            this.writenbt(nbt);
        }

        public void m_7651_() {
            super.m_7651_();
            this.fluid_handler_.invalidate();
        }

        public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
            if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
                return this.fluid_handler_.cast();
            }
            return super.getCapability(capability, facing);
        }

        private FluidState get_fluidstate(BlockPos pos) {
            return this.f_58857_.m_6425_(pos);
        }

        private boolean try_pick(BlockPos pos, FluidState fluidstate) {
            FluidStack fs;
            if (!fluidstate.m_76170_()) {
                return false;
            }
            IFluidHandler hnd = Fluidics.handler(this.f_58857_, pos, null);
            if (hnd != null) {
                fs = hnd.drain(3000, IFluidHandler.FluidAction.EXECUTE);
            } else {
                fs = new FluidStack(fluidstate.m_76152_(), 1000);
                BlockState state = this.f_58857_.m_8055_(pos);
                if (state.m_61138_((Property)BlockStateProperties.f_61362_)) {
                    this.f_58857_.m_7731_(pos, (BlockState)state.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(false)), 3);
                } else {
                    this.f_58857_.m_7731_(pos, Blocks.f_50016_.m_49966_(), 3);
                }
            }
            if (fs == null || fs.isEmpty()) {
                return false;
            }
            if (this.tank_.isEmpty()) {
                this.tank_.setFluid(fs.copy());
            } else if (this.tank_.isFluidEqual(fs)) {
                this.tank_.fill(fs, IFluidHandler.FluidAction.EXECUTE);
            } else {
                return false;
            }
            return true;
        }

        private boolean can_pick(BlockPos pos, FluidState fluidstate) {
            if (fluidstate.m_76170_()) {
                return true;
            }
            IFluidHandler hnd = Fluidics.handler(this.f_58857_, pos, null);
            if (hnd == null) {
                return false;
            }
            FluidStack fs = hnd.drain(3000, IFluidHandler.FluidAction.SIMULATE);
            return fs != null && !fs.isEmpty() && fluidstate.m_76152_().m_6212_(fs.getFluid());
        }

        private void rebuild_search_offsets(boolean intensive) {
            this.search_offsets_ = new ArrayList(9);
            this.search_offsets_.add(new Vec3i(0, 1, 0));
            ArrayList<Vec3i> ofs = new ArrayList<Vec3i>(Arrays.asList(new Vec3i(-1, 0, 0), new Vec3i(1, 0, 0), new Vec3i(0, 0, -1), new Vec3i(0, 0, 1)));
            if (intensive || this.total_pick_counter_ > 50) {
                Collections.shuffle(ofs);
            }
            this.search_offsets_.addAll(ofs);
            if (intensive) {
                ofs = new ArrayList<Vec3i>(Arrays.asList(new Vec3i(-1, 1, 0), new Vec3i(1, 1, 0), new Vec3i(0, 1, -1), new Vec3i(0, 1, 1)));
                Collections.shuffle(ofs);
                this.search_offsets_.addAll(ofs);
            }
        }

        private boolean try_collect(BlockPos collection_pos) {
            int max;
            boolean intensive;
            FluidState collection_fluidstate = this.get_fluidstate(collection_pos);
            if (collection_fluidstate.m_76178_()) {
                return false;
            }
            Fluid fluid_to_collect = collection_fluidstate.m_76152_();
            if (!this.tank_.isEmpty() && !this.tank_.getFluid().getFluid().m_6212_(fluid_to_collect)) {
                return false;
            }
            if (this.try_pick(collection_pos, collection_fluidstate)) {
                this.last_pick_pos_ = collection_pos;
                return true;
            }
            if (this.last_pick_pos_ == null || this.last_pick_pos_.m_123331_((Vec3i)collection_pos) > 256.0) {
                this.last_pick_pos_ = collection_pos;
                this.search_offsets_ = null;
            }
            BlockPos pos = this.last_pick_pos_;
            HashSet<BlockPos> checked = new HashSet<BlockPos>();
            Stack<BlockPos> trail = new Stack<BlockPos>();
            trail.add(pos);
            checked.add(pos);
            int steps = 0;
            boolean bl = intensive = this.no_fluid_found_counter_ >= 16;
            if (intensive) {
                this.no_fluid_found_counter_ = 0;
                ++this.intensive_search_counter_;
            }
            if (this.search_offsets_ == null) {
                this.rebuild_search_offsets(intensive);
            }
            int n = max = intensive ? 1024 : 72;
            while (++steps <= max) {
                int num_adjacent = 0;
                for (int i = 0; i < this.search_offsets_.size(); ++i) {
                    BlockPos p = pos.m_121955_(this.search_offsets_.get(i));
                    if (checked.contains(p)) continue;
                    checked.add(p);
                    ++steps;
                    FluidState fluidstate = this.get_fluidstate(p);
                    if (!fluidstate.m_76152_().m_6212_(fluid_to_collect)) continue;
                    ++num_adjacent;
                    pos = p;
                    trail.push(pos);
                    if (steps < 512) {
                        int max_surface_search = 512 - steps;
                        for (int k = 0; k < max_surface_search; ++k) {
                            FluidState fs = this.get_fluidstate(pos.m_7494_());
                            if (!this.can_pick(pos.m_7494_(), fs)) break;
                            fluidstate = fs;
                            pos = pos.m_7494_();
                            trail.push(pos);
                        }
                    }
                    if (!this.try_pick(pos, fluidstate)) continue;
                    this.last_pick_pos_ = pos;
                    this.no_fluid_found_counter_ = 0;
                    this.search_offsets_ = null;
                    if (++this.total_pick_counter_ > 50 && this.f_58857_.f_46441_.m_188503_(10) == 0) {
                        this.last_pick_pos_ = collection_pos;
                    }
                    return true;
                }
                if (trail.isEmpty()) break;
                if (num_adjacent != 0) continue;
                pos = (BlockPos)trail.pop();
            }
            if (this.intensive_search_counter_ > 2) {
                this.f_58857_.m_7471_(pos, false);
            }
            this.last_pick_pos_ = collection_pos;
            this.search_offsets_ = null;
            ++this.no_fluid_found_counter_;
            return false;
        }

        @Override
        public void tick() {
            int fill_level;
            IFluidHandler fh;
            if (this.f_58857_.f_46443_ || --this.tick_timer_ > 0) {
                return;
            }
            this.tick_timer_ = 10;
            this.collection_timer_ += 10;
            BlockState funnel_state = this.f_58857_.m_8055_(this.f_58858_);
            if (!(funnel_state.m_60734_() instanceof FluidFunnelBlock)) {
                return;
            }
            boolean dirty = false;
            if (this.collection_timer_ >= 40 && (this.tank_ == null || this.tank_.getFluidAmount() <= 2000)) {
                this.collection_timer_ = 0;
                if (!this.f_58857_.m_46753_(this.f_58858_)) {
                    BlockEntity te;
                    if (this.last_pick_pos_ == null) {
                        this.last_pick_pos_ = this.f_58858_.m_7494_();
                    }
                    BlockEntity blockEntity = te = with_device_fluid_handler_collection ? this.f_58857_.m_7702_(this.f_58858_.m_7494_()) : null;
                    if (te != null) {
                        IFluidHandler fh2 = (IFluidHandler)te.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, Direction.DOWN).orElse(null);
                        if (fh2 == null) {
                            te = null;
                        } else if (this.tank_.isEmpty()) {
                            FluidStack fs = fh2.drain(1000, IFluidHandler.FluidAction.EXECUTE);
                            if (fs != null && !fs.isEmpty()) {
                                this.tank_.setFluid(fs.copy());
                            }
                            dirty = true;
                        } else if (!this.tank_.isFull()) {
                            FluidStack todrain = new FluidStack(this.tank_.getFluid(), Math.min(this.tank_.getCapacity() - this.tank_.getFluidAmount(), 1000));
                            this.tank_.fill(fh2.drain(todrain, IFluidHandler.FluidAction.EXECUTE), IFluidHandler.FluidAction.EXECUTE);
                            dirty = true;
                        }
                    }
                    if (te == null && this.try_collect(this.f_58858_.m_7494_())) {
                        dirty = true;
                    }
                }
            }
            if (this.tank_.getFluidAmount() >= 1000 && (fh = Fluidics.handler(this.f_58857_, this.f_58858_.m_7495_(), Direction.UP)) != null) {
                FluidStack fs = new FluidStack(this.tank_.getFluid().getFluid(), 1000);
                int nfilled = Mth.m_14045_((int)fh.fill(fs, IFluidHandler.FluidAction.EXECUTE), (int)0, (int)1000);
                this.tank_.drain(nfilled);
                dirty = true;
            }
            int n = fill_level = this.tank_ == null ? 0 : Mth.m_14045_((int)(this.tank_.getFluidAmount() / 1000), (int)0, (int)3);
            if ((Integer)funnel_state.m_61143_((Property)FluidFunnelBlock.FILL_LEVEL) != fill_level) {
                this.f_58857_.m_7731_(this.f_58858_, (BlockState)funnel_state.m_61124_((Property)FluidFunnelBlock.FILL_LEVEL, (Comparable)Integer.valueOf(fill_level)), 18);
            }
            if (dirty) {
                this.m_6596_();
            }
        }
    }

    public static class FluidFunnelBlock
    extends StandardBlocks.Cutout
    implements StandardEntityBlocks.IStandardEntityBlock<FluidFunnelTileEntity> {
        public static final int FILL_LEVEL_MAX = 3;
        public static final IntegerProperty FILL_LEVEL = IntegerProperty.m_61631_((String)"level", (int)0, (int)3);

        public FluidFunnelBlock(long config, BlockBehaviour.Properties builder, AABB[] unrotatedAABB) {
            super(config, builder, unrotatedAABB);
        }

        @Override
        public boolean isBlockEntityTicking(Level world, BlockState state) {
            return true;
        }

        @Override
        public StandardBlocks.IStandardBlock.RenderTypeHint getRenderTypeHint() {
            return StandardBlocks.IStandardBlock.RenderTypeHint.CUTOUT;
        }

        @Override
        public VoxelShape m_5939_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext selectionContext) {
            return Shapes.m_83144_();
        }

        protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
            super.m_7926_(builder);
            builder.m_61104_(new Property[]{FILL_LEVEL});
        }

        @Override
        @Nullable
        public BlockState m_5573_(BlockPlaceContext context) {
            return (BlockState)super.m_5573_(context).m_61124_((Property)FILL_LEVEL, (Comparable)Integer.valueOf(0));
        }

        public boolean m_7278_(BlockState state) {
            return true;
        }

        public int m_6782_(BlockState state, Level world, BlockPos pos) {
            return Mth.m_14045_((int)((Integer)state.m_61143_((Property)FILL_LEVEL) * 5), (int)0, (int)15);
        }

        public void m_6402_(Level world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
            if (world.f_46443_) {
                return;
            }
            if (!stack.m_41782_() || !stack.m_41783_().m_128441_("tedata")) {
                return;
            }
            CompoundTag te_nbt = stack.m_41783_().m_128469_("tedata");
            if (te_nbt.m_128456_()) {
                return;
            }
            BlockEntity te = world.m_7702_(pos);
            if (!(te instanceof FluidFunnelTileEntity)) {
                return;
            }
            ((FluidFunnelTileEntity)te).readnbt(te_nbt);
            te.m_6596_();
            world.m_46597_(pos, (BlockState)state.m_61124_((Property)FILL_LEVEL, (Comparable)Integer.valueOf(0)));
        }

        @Override
        public boolean hasDynamicDropList() {
            return true;
        }

        @Override
        public List<ItemStack> dropList(BlockState state, Level world, BlockEntity te, boolean explosion) {
            ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
            if (world.f_46443_) {
                return stacks;
            }
            if (!(te instanceof FluidFunnelTileEntity)) {
                return stacks;
            }
            if (!explosion) {
                ItemStack stack = new ItemStack((ItemLike)this, 1);
                CompoundTag te_nbt = new CompoundTag();
                ((FluidFunnelTileEntity)te).writenbt(te_nbt);
                if (!te_nbt.m_128456_()) {
                    CompoundTag nbt = new CompoundTag();
                    nbt.m_128365_("tedata", (Tag)te_nbt);
                    stack.m_41751_(nbt);
                }
                stacks.add(stack);
            } else {
                stacks.add(new ItemStack((ItemLike)this, 1));
            }
            return stacks;
        }

        public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult rayTraceResult) {
            if (world.f_46443_) {
                return InteractionResult.SUCCESS;
            }
            return world.m_7702_(pos) instanceof FluidFunnelTileEntity && Fluidics.manualFluidHandlerInteraction(player, hand, world, pos, rayTraceResult.m_82434_()) ? InteractionResult.CONSUME : InteractionResult.FAIL;
        }

        public void m_6861_(BlockState state, Level world, BlockPos pos, Block block, BlockPos fromPos, boolean unused) {
            BlockEntity te = world.m_7702_(pos);
            if (te instanceof FluidFunnelTileEntity) {
                ((FluidFunnelTileEntity)te).block_changed();
            }
        }

        public boolean shouldCheckWeakPower(BlockState state, LevelReader world, BlockPos pos, Direction side) {
            return false;
        }
    }
}

