/*
 * Decompiled with CFR 0.152.
 */
package wile.engineersdecor.blocks;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import wile.engineersdecor.ModConfig;
import wile.engineersdecor.ModContent;
import wile.engineersdecor.libmc.blocks.StandardBlocks;
import wile.engineersdecor.libmc.blocks.StandardEntityBlocks;
import wile.engineersdecor.libmc.detail.RsSignals;

public class EdPipeValve {
    public static final int CFG_CHECK_VALVE = 1;
    public static final int CFG_ANALOG_VALVE = 2;
    public static final int CFG_REDSTONE_CONTROLLED_VALVE = 4;

    public static void on_config(int container_size_decl, int redstone_slope) {
        PipeValveTileEntity.fluid_maxflow_mb = Mth.m_14045_((int)container_size_decl, (int)1, (int)10000);
        PipeValveTileEntity.redstone_flow_slope_mb = Mth.m_14045_((int)redstone_slope, (int)1, (int)10000);
        ModConfig.log("Config pipe valve: maxflow:" + PipeValveTileEntity.fluid_maxflow_mb + "mb, redstone amp:" + PipeValveTileEntity.redstone_flow_slope_mb + "mb/sig.");
    }

    public static class PipeValveTileEntity
    extends StandardEntityBlocks.StandardBlockEntity {
        protected static int fluid_maxflow_mb = 1000;
        protected static int redstone_flow_slope_mb = 66;
        private final Direction block_facing_ = null;
        private boolean filling_ = false;
        private int valve_config_;
        private final LazyOptional<IFluidHandler> back_flow_handler_ = LazyOptional.of(BackFlowHandler::new);
        private final LazyOptional<IFluidHandler> fluid_handler_ = LazyOptional.of(() -> new MainFlowHandler(this));

        public PipeValveTileEntity(BlockPos pos, BlockState state) {
            super(ModContent.getBlockEntityTypeOfBlock("straight_pipe_valve"), pos, state);
        }

        private Direction block_facing() {
            BlockState st = this.m_58904_().m_8055_(this.m_58899_());
            return st.m_60734_() instanceof PipeValveBlock ? (Direction)st.m_61143_((Property)PipeValveBlock.FACING) : Direction.NORTH;
        }

        private long valve_config() {
            Block block;
            if (this.valve_config_ <= 0 && (block = this.m_58904_().m_8055_(this.m_58899_()).m_60734_()) instanceof PipeValveBlock) {
                this.valve_config_ = ((PipeValveBlock)block).valve_config;
            }
            return this.valve_config_;
        }

        public void m_7651_() {
            super.m_7651_();
            this.back_flow_handler_.invalidate();
            this.fluid_handler_.invalidate();
        }

        public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
            if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
                Direction bf = this.block_facing();
                if (facing == bf) {
                    return this.back_flow_handler_.cast();
                }
                if (facing == bf.m_122424_()) {
                    return this.fluid_handler_.cast();
                }
                return LazyOptional.empty();
            }
            return super.getCapability(capability, facing);
        }

        @Nullable
        private IFluidHandler forward_fluid_handler() {
            BlockEntity te = this.f_58857_.m_7702_(this.f_58858_.m_121945_(this.block_facing()));
            if (te == null) {
                return null;
            }
            return (IFluidHandler)te.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, this.block_facing().m_122424_()).orElse(null);
        }

        private static class MainFlowHandler
        implements IFluidHandler {
            private final PipeValveTileEntity te;

            public MainFlowHandler(PipeValveTileEntity te) {
                this.te = te;
            }

            public int getTanks() {
                return 1;
            }

            public FluidStack getFluidInTank(int tank) {
                return FluidStack.EMPTY;
            }

            public int getTankCapacity(int tank) {
                return fluid_maxflow_mb;
            }

            public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
                return true;
            }

            public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
                return FluidStack.EMPTY;
            }

            public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
                return FluidStack.EMPTY;
            }

            public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
                if (this.te.filling_) {
                    return 0;
                }
                IFluidHandler fh = this.te.forward_fluid_handler();
                if (fh == null) {
                    return 0;
                }
                FluidStack res = resource.copy();
                if ((this.te.valve_config() & 4L) != 0L) {
                    int rs = this.te.f_58857_.m_46755_(this.te.f_58858_);
                    if (rs <= 0) {
                        return 0;
                    }
                    if ((this.te.valve_config() & 2L) != 0L && rs < 15) {
                        res.setAmount(Mth.m_14045_((int)(rs * redstone_flow_slope_mb), (int)1, (int)res.getAmount()));
                    }
                }
                if (res.getAmount() > fluid_maxflow_mb) {
                    res.setAmount(fluid_maxflow_mb);
                }
                this.te.filling_ = true;
                int n_filled = fh.fill(res, action);
                this.te.filling_ = false;
                return n_filled;
            }
        }

        private static class BackFlowHandler
        implements IFluidHandler {
            private BackFlowHandler() {
            }

            public int getTanks() {
                return 1;
            }

            public FluidStack getFluidInTank(int tank) {
                return FluidStack.EMPTY;
            }

            public int getTankCapacity(int tank) {
                return 0;
            }

            public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
                return false;
            }

            public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
                return 0;
            }

            public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
                return FluidStack.EMPTY;
            }

            public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
                return FluidStack.EMPTY;
            }
        }
    }

    public static class PipeValveBlock
    extends StandardBlocks.DirectedWaterLoggable
    implements StandardEntityBlocks.IStandardEntityBlock<PipeValveTileEntity> {
        public static final BooleanProperty RS_CN_N = BooleanProperty.m_61465_((String)"rs_n");
        public static final BooleanProperty RS_CN_S = BooleanProperty.m_61465_((String)"rs_s");
        public static final BooleanProperty RS_CN_E = BooleanProperty.m_61465_((String)"rs_e");
        public static final BooleanProperty RS_CN_W = BooleanProperty.m_61465_((String)"rs_w");
        public static final BooleanProperty RS_CN_U = BooleanProperty.m_61465_((String)"rs_u");
        public static final BooleanProperty RS_CN_D = BooleanProperty.m_61465_((String)"rs_d");
        public final int valve_config;

        public PipeValveBlock(long config, int valve_config, BlockBehaviour.Properties builder, AABB[] unrotatedAABB) {
            super(config, builder, unrotatedAABB);
            this.valve_config = valve_config;
        }

        @Override
        @Nullable
        public BlockEntity m_142194_(BlockPos pos, BlockState state) {
            BlockEntityType<?> tet = ModContent.getBlockEntityTypeOfBlock("straight_pipe_valve");
            return tet == null ? null : tet.m_155264_(pos, state);
        }

        @Override
        public boolean isBlockEntityTicking(Level world, BlockState state) {
            return false;
        }

        @Override
        public VoxelShape m_5939_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext selectionContext) {
            return Shapes.m_83144_();
        }

        @Override
        protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
            super.m_7926_(builder);
            builder.m_61104_(new Property[]{RS_CN_N, RS_CN_S, RS_CN_E, RS_CN_W, RS_CN_U, RS_CN_D});
        }

        @Override
        @Nullable
        public BlockState m_5573_(BlockPlaceContext context) {
            return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)super.m_5573_(context).m_61124_((Property)RS_CN_N, (Comparable)Boolean.valueOf(false))).m_61124_((Property)RS_CN_S, (Comparable)Boolean.valueOf(false))).m_61124_((Property)RS_CN_E, (Comparable)Boolean.valueOf(false))).m_61124_((Property)RS_CN_W, (Comparable)Boolean.valueOf(false))).m_61124_((Property)RS_CN_U, (Comparable)Boolean.valueOf(false))).m_61124_((Property)RS_CN_D, (Comparable)Boolean.valueOf(false));
        }

        @Override
        public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor world, BlockPos pos, BlockPos facingPos) {
            return this.get_rsconnector_state(state, world, pos, null);
        }

        public void m_6402_(Level world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
            world.m_46672_(pos, (Block)this);
        }

        public BlockState rotate(BlockState state, LevelAccessor world, BlockPos pos, Rotation direction) {
            return this.get_rsconnector_state(state, world, pos, null);
        }

        @Override
        public boolean hasSignalConnector(BlockState state, BlockGetter world, BlockPos pos, @Nullable Direction side) {
            return side != null && side != state.m_61143_((Property)FACING) && side != ((Direction)state.m_61143_((Property)FACING)).m_122424_();
        }

        public boolean shouldCheckWeakPower(BlockState state, LevelReader world, BlockPos pos, Direction side) {
            return false;
        }

        public boolean m_7899_(BlockState p_60571_) {
            return true;
        }

        public int m_6378_(BlockState blockState, BlockGetter blockAccess, BlockPos pos, Direction side) {
            return 0;
        }

        public int m_6376_(BlockState blockState, BlockGetter blockAccess, BlockPos pos, Direction side) {
            return 0;
        }

        private BlockState get_rsconnector_state(BlockState state, LevelAccessor world, BlockPos pos, @Nullable BlockPos fromPos) {
            if ((this.valve_config & 4) == 0) {
                return state;
            }
            Direction.Axis bfa = ((Direction)state.m_61143_((Property)FACING)).m_122434_();
            block8: for (Direction f : Direction.values()) {
                boolean cn;
                boolean bl = cn = f.m_122434_() != bfa;
                if (cn) {
                    BlockPos nbp = pos.m_121945_(f);
                    if (fromPos != null && !nbp.equals((Object)fromPos)) continue;
                    BlockState nbs = world.m_8055_(nbp);
                    if (nbs.m_60734_() instanceof PipeValveBlock || !nbs.m_60803_() || !RsSignals.hasSignalConnector(nbs, (BlockGetter)world, nbp, f.m_122424_())) {
                        cn = false;
                    }
                }
                switch (f) {
                    case NORTH: {
                        state = (BlockState)state.m_61124_((Property)RS_CN_N, (Comparable)Boolean.valueOf(cn));
                        continue block8;
                    }
                    case SOUTH: {
                        state = (BlockState)state.m_61124_((Property)RS_CN_S, (Comparable)Boolean.valueOf(cn));
                        continue block8;
                    }
                    case EAST: {
                        state = (BlockState)state.m_61124_((Property)RS_CN_E, (Comparable)Boolean.valueOf(cn));
                        continue block8;
                    }
                    case WEST: {
                        state = (BlockState)state.m_61124_((Property)RS_CN_W, (Comparable)Boolean.valueOf(cn));
                        continue block8;
                    }
                    case UP: {
                        state = (BlockState)state.m_61124_((Property)RS_CN_U, (Comparable)Boolean.valueOf(cn));
                        continue block8;
                    }
                    case DOWN: {
                        state = (BlockState)state.m_61124_((Property)RS_CN_D, (Comparable)Boolean.valueOf(cn));
                    }
                }
            }
            return state;
        }
    }
}

