/*
 * Decompiled with CFR 0.152.
 */
package wile.engineersdecor.blocks;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.Nameable;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import wile.engineersdecor.ModContent;
import wile.engineersdecor.libmc.blocks.StandardBlocks;
import wile.engineersdecor.libmc.blocks.StandardEntityBlocks;
import wile.engineersdecor.libmc.detail.Auxiliaries;
import wile.engineersdecor.libmc.detail.Inventories;
import wile.engineersdecor.libmc.detail.Networking;
import wile.engineersdecor.libmc.detail.RsSignals;
import wile.engineersdecor.libmc.detail.TooltipDisplay;
import wile.engineersdecor.libmc.ui.Guis;

public class EdPlacer {
    public static void on_config() {
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class PlacerGui
    extends Guis.ContainerGui<PlacerContainer> {
        public PlacerGui(PlacerContainer container, Inventory player_inventory, Component title) {
            super(container, player_inventory, title, "textures/gui/factory_placer_gui.png");
        }

        @Override
        public void m_7856_() {
            super.m_7856_();
            Block block = ModContent.getBlock(Auxiliaries.getResourceLocation(((PlacerContainer)this.m_6262_()).m_6772_()).m_135815_().replaceAll("^ct_", ""));
            String prefix = block.m_7705_() + ".tooltips.";
            int x0 = this.getGuiLeft();
            int y0 = this.getGuiTop();
            this.tooltip_.init(new TooltipDisplay.TipRange(x0 + 133, y0 + 49, 9, 9, (Component)Component.m_237115_((String)(prefix + "rssignal"))), new TooltipDisplay.TipRange(x0 + 145, y0 + 49, 9, 9, (Component)Component.m_237115_((String)(prefix + "inversion"))), new TooltipDisplay.TipRange(x0 + 159, y0 + 49, 9, 9, (Component)Component.m_237115_((String)(prefix + "triggermode"))));
        }

        public boolean m_6375_(double mouseX, double mouseY, int mouseButton) {
            this.tooltip_.resetTimer();
            PlacerContainer container = (PlacerContainer)this.m_6262_();
            int mx = (int)(mouseX - (double)this.getGuiLeft() + 0.5);
            int my = (int)(mouseY - (double)this.getGuiTop() + 0.5);
            if (!this.m_6774_(126, 1, 49, 60, mouseX, mouseY)) {
                return super.m_6375_(mouseX, mouseY, mouseButton);
            }
            if (this.m_6774_(133, 49, 9, 9, mouseX, mouseY)) {
                container.onGuiAction("manual_trigger", 1);
            } else if (this.m_6774_(145, 49, 9, 9, mouseX, mouseY)) {
                int mask = 5;
                int logic = switch (container.field(0) & 5) {
                    case 0 -> 1;
                    case 1 -> 4;
                    case 4 -> 0;
                    default -> 4;
                };
                container.onGuiAction("logic", container.field(0) & 0xFFFFFFFA | logic);
            } else if (this.m_6774_(159, 49, 7, 9, mouseX, mouseY)) {
                container.onGuiAction("logic", container.field(0) ^ 2);
            }
            return true;
        }

        protected void m_6597_(Slot slot, int slotId, int button, ClickType type) {
            this.tooltip_.resetTimer();
            if (type == ClickType.QUICK_MOVE && slot != null && slot.m_6657_() && Auxiliaries.isShiftDown() && Auxiliaries.isCtrlDown()) {
                CompoundTag nbt = new CompoundTag();
                nbt.m_128405_("slot", slotId);
                ((PlacerContainer)this.f_97732_).onGuiAction("quick-move-all", nbt);
            } else {
                super.m_6597_(slot, slotId, button, type);
            }
        }

        @Override
        protected void renderBgWidgets(PoseStack mx, float partialTicks, int mouseX, int mouseY) {
            int x0 = this.getGuiLeft();
            int y0 = this.getGuiTop();
            int w = this.getXSize();
            int h = this.getYSize();
            PlacerContainer container = (PlacerContainer)this.m_6262_();
            int slot_index = container.field(2);
            if (slot_index < 0 || slot_index >= 18) {
                slot_index = 0;
            }
            int x = x0 + 10 + slot_index % 6 * 18;
            int y = y0 + 8 + slot_index / 6 * 17;
            this.m_93228_(mx, x, y, 200, 8, 18, 18);
            if (container.field(1) != 0) {
                this.m_93228_(mx, x0 + 133, y0 + 49, 217, 49, 9, 9);
            }
            int inverter_offset_x = (container.field(0) & 1) != 0 ? 11 : 0;
            int inverter_offset_y = (container.field(0) & 4) != 0 ? 10 : 0;
            this.m_93228_(mx, x0 + 145, y0 + 49, 177 + inverter_offset_x, 49 + inverter_offset_y, 9, 9);
            int pulse_mode_offset = (container.field(0) & 2) != 0 ? 9 : 0;
            this.m_93228_(mx, x0 + 159, y0 + 49, 199 + pulse_mode_offset, 49, 9, 9);
        }
    }

    public static class PlacerContainer
    extends AbstractContainerMenu
    implements Networking.INetworkSynchronisableContainer {
        protected static final String QUICK_MOVE_ALL = "quick-move-all";
        private static final int PLAYER_INV_START_SLOTNO = 18;
        private final Player player_;
        private final Container inventory_;
        private final ContainerLevelAccess wpc_;
        private final ContainerData fields_;
        private final Inventories.InventoryRange player_inventory_range_;
        private final Inventories.InventoryRange block_storage_range_;

        public final int field(int index) {
            return this.fields_.m_6413_(index);
        }

        public PlacerContainer(int cid, Inventory player_inventory) {
            this(cid, player_inventory, (Container)new SimpleContainer(18), ContainerLevelAccess.f_39287_, (ContainerData)new SimpleContainerData(3));
        }

        private PlacerContainer(int cid, Inventory player_inventory, Container block_inventory, ContainerLevelAccess wpc, ContainerData fields) {
            super(ModContent.getMenuType("factory_placer"), cid);
            int x;
            int y;
            this.fields_ = fields;
            this.wpc_ = wpc;
            this.player_ = player_inventory.f_35978_;
            this.inventory_ = block_inventory;
            this.block_storage_range_ = new Inventories.InventoryRange(this.inventory_, 0, 18);
            this.player_inventory_range_ = Inventories.InventoryRange.fromPlayerInventory(this.player_);
            int i = -1;
            for (y = 0; y < 3; ++y) {
                for (x = 0; x < 6; ++x) {
                    int xpos = 11 + x * 18;
                    int ypos = 9 + y * 17;
                    this.m_38897_(new Slot(this.inventory_, ++i, xpos, ypos));
                }
            }
            for (int x2 = 0; x2 < 9; ++x2) {
                this.m_38897_(new Slot((Container)player_inventory, x2, 9 + x2 * 18, 129));
            }
            for (y = 0; y < 3; ++y) {
                for (x = 0; x < 9; ++x) {
                    this.m_38897_(new Slot((Container)player_inventory, x + y * 9 + 9, 9 + x * 18, 71 + y * 18));
                }
            }
            this.m_38884_(this.fields_);
        }

        public boolean m_6875_(Player player) {
            return this.inventory_.m_6542_(player);
        }

        public ItemStack m_7648_(Player player, int index) {
            Slot slot = this.m_38853_(index);
            if (slot == null || !slot.m_6657_()) {
                return ItemStack.f_41583_;
            }
            ItemStack slot_stack = slot.m_7993_();
            ItemStack transferred = slot_stack.m_41777_();
            if (index >= 0 && index < 18) {
                if (!this.m_38903_(slot_stack, 18, 54, false)) {
                    return ItemStack.f_41583_;
                }
            } else if (index >= 18 && index <= 54) {
                if (!this.m_38903_(slot_stack, 0, 18, false)) {
                    return ItemStack.f_41583_;
                }
            } else {
                return ItemStack.f_41583_;
            }
            if (slot_stack.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (slot_stack.m_41613_() == transferred.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(player, slot_stack);
            return transferred;
        }

        @OnlyIn(value=Dist.CLIENT)
        public void onGuiAction(CompoundTag nbt) {
            Networking.PacketContainerSyncClientToServer.sendToServer(this.f_38840_, nbt);
        }

        @OnlyIn(value=Dist.CLIENT)
        public void onGuiAction(String key, int value) {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128405_(key, value);
            Networking.PacketContainerSyncClientToServer.sendToServer(this.f_38840_, nbt);
        }

        @OnlyIn(value=Dist.CLIENT)
        public void onGuiAction(String message, CompoundTag nbt) {
            nbt.m_128359_("action", message);
            Networking.PacketContainerSyncClientToServer.sendToServer(this.f_38840_, nbt);
        }

        @Override
        public void onServerPacketReceived(int windowId, CompoundTag nbt) {
        }

        @Override
        public void onClientPacketReceived(int windowId, Player player, CompoundTag nbt) {
            if (!(this.inventory_ instanceof Inventories.StorageInventory)) {
                return;
            }
            BlockEntity blockEntity = ((Inventories.StorageInventory)this.inventory_).getBlockEntity();
            if (!(blockEntity instanceof PlacerTileEntity)) {
                return;
            }
            PlacerTileEntity te = (PlacerTileEntity)blockEntity;
            if (nbt.m_128441_("action")) {
                int slotId = nbt.m_128441_("slot") ? nbt.m_128451_("slot") : -1;
                boolean changed = false;
                switch (nbt.m_128461_("action")) {
                    case "quick-move-all": {
                        if (slotId >= 0 && slotId < 18 && this.m_38853_(slotId).m_6657_()) {
                            changed = this.block_storage_range_.move(this.m_38853_(slotId).getSlotIndex(), this.player_inventory_range_, true, false, true, true);
                            break;
                        }
                        if (slotId < 18 || slotId >= 54 || !this.m_38853_(slotId).m_6657_()) break;
                        changed = this.player_inventory_range_.move(this.m_38853_(slotId).getSlotIndex(), this.block_storage_range_, true, false, false, true);
                    }
                }
                if (changed) {
                    this.inventory_.m_6596_();
                    player.m_150109_().m_6596_();
                    this.m_38946_();
                }
            } else {
                if (nbt.m_128441_("logic")) {
                    te.logic_ = nbt.m_128451_("logic");
                }
                if (nbt.m_128441_("manual_trigger") && nbt.m_128451_("manual_trigger") != 0) {
                    te.block_power_signal_ = true;
                    te.block_power_updated_ = true;
                    te.tick_timer_ = 1;
                }
                te.m_6596_();
            }
        }
    }

    public static class PlacerTileEntity
    extends StandardEntityBlocks.StandardBlockEntity
    implements MenuProvider,
    Nameable {
        public static final int TICK_INTERVAL = 40;
        public static final int NUM_OF_SLOTS = 18;
        public static final int NUM_OF_FIELDS = 3;
        public static final int LOGIC_NOT_INVERTED = 0;
        public static final int LOGIC_INVERTED = 1;
        public static final int LOGIC_CONTINUOUS = 2;
        public static final int LOGIC_IGNORE_EXT = 4;
        private boolean block_power_signal_ = false;
        private boolean block_power_updated_ = false;
        private int logic_ = 6;
        private int current_slot_index_ = 0;
        private int tick_timer_ = 0;
        private final boolean debug_ = false;
        private final Inventories.StorageInventory inventory_ = new Inventories.StorageInventory(this, 18, 1);
        private final LazyOptional<IItemHandler> item_handler_;
        protected final ContainerData fields = new ContainerData(){

            public int m_6499_() {
                return 3;
            }

            public int m_6413_(int id) {
                return switch (id) {
                    case 0 -> logic_;
                    case 1 -> {
                        if (block_power_signal_) {
                            yield 1;
                        }
                        yield 0;
                    }
                    case 2 -> Mth.m_14045_((int)current_slot_index_, (int)0, (int)17);
                    default -> 0;
                };
            }

            public void m_8050_(int id, int value) {
                switch (id) {
                    case 0: {
                        logic_ = value;
                        break;
                    }
                    case 1: {
                        block_power_signal_ = value != 0;
                        break;
                    }
                    case 2: {
                        current_slot_index_ = Mth.m_14045_((int)value, (int)0, (int)17);
                    }
                }
            }
        };

        public PlacerTileEntity(BlockPos pos, BlockState state) {
            super(ModContent.getBlockEntityTypeOfBlock(state.m_60734_()), pos, state);
            this.item_handler_ = Inventories.MappedItemHandler.createGenericHandler(this.inventory_, (stack, slot) -> true, (stack, slot) -> true);
        }

        public CompoundTag clear_getnbt() {
            CompoundTag nbt = new CompoundTag();
            this.writenbt(nbt, false);
            this.inventory_.m_6211_();
            this.reset_rtstate();
            this.block_power_updated_ = false;
            return nbt;
        }

        public void reset_rtstate() {
            this.block_power_signal_ = false;
            this.block_power_updated_ = false;
        }

        public void readnbt(CompoundTag nbt, boolean update_packet) {
            this.inventory_.load(nbt);
            this.block_power_signal_ = nbt.m_128471_("powered");
            this.current_slot_index_ = nbt.m_128451_("act_slot_index");
            this.logic_ = nbt.m_128451_("logic");
        }

        protected void writenbt(CompoundTag nbt, boolean update_packet) {
            this.inventory_.save(nbt);
            nbt.m_128379_("powered", this.block_power_signal_);
            nbt.m_128405_("act_slot_index", this.current_slot_index_);
            nbt.m_128405_("logic", this.logic_);
        }

        public void block_updated() {
            boolean powered = this.f_58857_.m_46753_(this.f_58858_);
            if (this.block_power_signal_ != powered) {
                this.block_power_updated_ = true;
            }
            this.block_power_signal_ = powered;
            if (this.block_power_updated_) {
                this.tick_timer_ = 1;
            } else if (this.tick_timer_ > 4) {
                this.tick_timer_ = 4;
            }
        }

        public void m_142466_(CompoundTag nbt) {
            super.m_142466_(nbt);
            this.readnbt(nbt, false);
        }

        protected void m_183515_(CompoundTag nbt) {
            super.m_183515_(nbt);
            this.writenbt(nbt, false);
        }

        public void m_7651_() {
            super.m_7651_();
            this.item_handler_.invalidate();
        }

        public Component m_7755_() {
            return Auxiliaries.localizable(this.m_58900_().m_60734_().m_7705_());
        }

        public boolean m_8077_() {
            return false;
        }

        public Component m_7770_() {
            return this.m_7755_();
        }

        public Component m_5446_() {
            return super.m_5446_();
        }

        public AbstractContainerMenu m_7208_(int id, Inventory inventory, Player player) {
            return new PlacerContainer(id, inventory, this.inventory_, ContainerLevelAccess.m_39289_((Level)this.f_58857_, (BlockPos)this.f_58858_), this.fields);
        }

        public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
            if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
                return this.item_handler_.cast();
            }
            return super.getCapability(capability, facing);
        }

        private static int next_slot(int i) {
            return i < 17 ? i + 1 : 0;
        }

        private boolean spit_out(Direction facing) {
            return this.spit_out(facing, false);
        }

        private boolean spit_out(Direction facing, boolean all) {
            ItemStack stack = this.inventory_.m_8020_(this.current_slot_index_);
            ItemStack drop = stack.m_41777_();
            if (!all) {
                stack.m_41774_(1);
                this.inventory_.m_6836_(this.current_slot_index_, stack);
                drop.m_41764_(1);
            } else {
                this.inventory_.m_6836_(this.current_slot_index_, ItemStack.f_41583_);
            }
            for (int i = 0; i < 8; ++i) {
                BlockPos p = this.f_58858_.m_5484_(facing, i);
                if (!this.f_58857_.m_46859_(p)) continue;
                this.f_58857_.m_7967_((Entity)new ItemEntity(this.f_58857_, (double)p.m_123341_() + 0.5, (double)p.m_123342_() + 0.5, (double)p.m_123343_() + 0.5, drop));
                this.f_58857_.m_5594_(null, p, SoundEvents.f_12019_, SoundSource.BLOCKS, 0.7f, 0.8f);
                break;
            }
            return true;
        }

        private boolean try_place(Direction facing, boolean triggered) {
            if (this.f_58857_.m_5776_()) {
                return false;
            }
            BlockPos placement_pos = this.f_58858_.m_121945_(facing);
            if (this.f_58857_.m_7702_(placement_pos) != null) {
                return false;
            }
            ItemStack current_stack = ItemStack.f_41583_;
            for (int i = 0; i < 18; ++i) {
                if (this.current_slot_index_ >= 18) {
                    this.current_slot_index_ = 0;
                }
                if (!(current_stack = this.inventory_.m_8020_(this.current_slot_index_)).m_41619_()) break;
                this.current_slot_index_ = PlacerTileEntity.next_slot(this.current_slot_index_);
            }
            if (current_stack.m_41619_()) {
                this.current_slot_index_ = 0;
                return false;
            }
            boolean no_space = false;
            Item item = current_stack.m_41720_();
            Block block = Block.m_49814_((Item)item);
            if (block == Blocks.f_50016_) {
                if (item != null) {
                    return this.spit_out(facing);
                }
            } else if (block instanceof IPlantable) {
                if (this.f_58857_.m_46859_(placement_pos)) {
                    soilstate = this.f_58857_.m_8055_(placement_pos.m_7495_());
                    if (!soilstate.m_60734_().canSustainPlant(soilstate, (BlockGetter)this.f_58857_, this.f_58858_, Direction.UP, (IPlantable)block)) {
                        block = Blocks.f_50016_;
                    }
                } else {
                    soilstate = this.f_58857_.m_8055_(placement_pos);
                    if (soilstate.m_60734_() == block) {
                        block = Blocks.f_50016_;
                        no_space = true;
                    } else if (!this.f_58857_.m_46859_(placement_pos.m_7494_())) {
                        block = Blocks.f_50016_;
                        no_space = true;
                    } else if (!soilstate.m_60734_().canSustainPlant(soilstate, (BlockGetter)this.f_58857_, this.f_58858_, Direction.UP, (IPlantable)block)) {
                        block = Blocks.f_50016_;
                    } else {
                        placement_pos = placement_pos.m_7494_();
                    }
                }
            } else {
                boolean replacable;
                BlockState current_placement_pos_state = this.f_58857_.m_8055_(placement_pos);
                boolean bl = replacable = current_placement_pos_state.m_60734_().m_5946_(current_placement_pos_state, Fluids.f_76191_) && (this.f_58857_.m_46859_(placement_pos) || current_placement_pos_state.m_60734_() instanceof IFluidBlock || current_placement_pos_state.m_60767_().m_76336_() && !current_placement_pos_state.m_60767_().m_76333_());
                if (!replacable || !this.f_58857_.m_6443_(Entity.class, new AABB(placement_pos), e -> {
                    if (e.m_6087_()) {
                        return true;
                    }
                    if (triggered) {
                        return false;
                    }
                    if (e instanceof ItemEntity) {
                        if (e.m_20184_().m_7098_() > 0.0 || e.m_20184_().m_7098_() < -0.5) {
                            return true;
                        }
                        if (Math.abs(e.m_20184_().m_7096_()) + Math.abs(e.m_20184_().m_7094_()) > 0.0) {
                            return true;
                        }
                    }
                    return false;
                }).isEmpty()) {
                    block = Blocks.f_50016_;
                    no_space = true;
                }
            }
            if (block != Blocks.f_50016_) {
                try {
                    SoundType stype;
                    BlockState placement_state;
                    BlockPlaceContext use_context = null;
                    FakePlayer placer = FakePlayerFactory.getMinecraft((ServerLevel)((ServerLevel)this.f_58857_));
                    if (placer != null) {
                        ItemStack placement_stack = current_stack.m_41777_();
                        placement_stack.m_41764_(1);
                        ItemStack held = placer.m_21120_(InteractionHand.MAIN_HAND);
                        placer.m_21008_(InteractionHand.MAIN_HAND, placement_stack);
                        ArrayList<Direction> directions = new ArrayList<Direction>(Arrays.asList(Direction.UP, facing.m_122424_()));
                        for (Direction d : Direction.values()) {
                            if (directions.contains(d)) continue;
                            directions.add(d);
                        }
                        for (Direction d : directions) {
                            Vec3 v = Vec3.m_82512_((Vec3i)placement_pos).m_82546_(Vec3.m_82528_((Vec3i)d.m_122436_()));
                            use_context = new BlockPlaceContext(new UseOnContext((Player)placer, InteractionHand.MAIN_HAND, new BlockHitResult(v, d, placement_pos, false)));
                            if (block.m_5573_(use_context) == null) {
                                use_context = null;
                            }
                            if (use_context == null) continue;
                            break;
                        }
                        placer.m_21008_(InteractionHand.MAIN_HAND, held);
                    }
                    BlockState blockState = placement_state = use_context == null ? block.m_49966_() : block.m_5573_(use_context);
                    if (placement_state == null) {
                        return this.spit_out(facing);
                    }
                    if (use_context != null && item instanceof BlockItem) {
                        if (((BlockItem)item).m_40576_(use_context) != InteractionResult.FAIL) {
                            stype = block.getSoundType(placement_state, (LevelReader)this.f_58857_, this.f_58858_, null);
                            if (stype != null) {
                                this.f_58857_.m_5594_(null, placement_pos, stype.m_56777_(), SoundSource.BLOCKS, stype.m_56773_() * 0.6f, stype.m_56774_());
                            }
                        } else if (this.f_58857_.m_7731_(placement_pos, placement_state, 11) && (stype = block.getSoundType(placement_state, (LevelReader)this.f_58857_, this.f_58858_, null)) != null) {
                            this.f_58857_.m_5594_(null, placement_pos, stype.m_56777_(), SoundSource.BLOCKS, stype.m_56773_() * 0.6f, stype.m_56774_());
                        }
                    } else if (this.f_58857_.m_7731_(placement_pos, placement_state, 11) && (stype = block.getSoundType(placement_state, (LevelReader)this.f_58857_, this.f_58858_, null)) != null) {
                        this.f_58857_.m_5594_(null, placement_pos, stype.m_56777_(), SoundSource.BLOCKS, stype.m_56773_() * 0.6f, stype.m_56774_());
                    }
                    current_stack.m_41774_(1);
                    this.inventory_.m_6836_(this.current_slot_index_, current_stack);
                    return true;
                }
                catch (Throwable e2) {
                    Auxiliaries.logger().error("Exception while trying to place " + (String)(block == null ? "" : "" + block) + ", spitting out. Exception is: " + e2);
                    try {
                        this.f_58857_.m_7471_(placement_pos, false);
                    }
                    catch (Throwable e1) {
                        Auxiliaries.logger().error("Exception while removing failed block placement " + (String)(block == null ? "" : "" + block) + ", spitting out. Exception is: " + e1);
                    }
                    return this.spit_out(facing, true);
                }
            }
            if (!no_space && !current_stack.m_41619_()) {
                for (int i = 0; i < 18; ++i) {
                    this.current_slot_index_ = PlacerTileEntity.next_slot(this.current_slot_index_);
                    if (!this.inventory_.m_8020_(this.current_slot_index_).m_41619_()) break;
                }
            }
            return false;
        }

        @Override
        public void tick() {
            if (this.f_58857_.f_46443_) {
                return;
            }
            if (--this.tick_timer_ > 0) {
                return;
            }
            this.tick_timer_ = 40;
            BlockState state = this.f_58857_.m_8055_(this.f_58858_);
            if (!(state.m_60734_() instanceof PlacerBlock)) {
                this.block_power_signal_ = false;
                return;
            }
            boolean updated = this.block_power_updated_;
            boolean rssignal = (this.logic_ & 4) != 0 || (this.logic_ & 1) != 0 == !this.block_power_signal_;
            boolean trigger = (this.logic_ & 4) != 0 || rssignal && (updated || (this.logic_ & 2) != 0);
            Direction placer_facing = (Direction)state.m_61143_((Property)PlacerBlock.FACING);
            boolean dirty = updated;
            boolean tr = this.f_58857_.m_46753_(this.f_58858_);
            this.block_power_updated_ = this.block_power_signal_ != tr;
            this.block_power_signal_ = tr;
            if (this.block_power_updated_) {
                dirty = true;
            }
            if (trigger && this.try_place(placer_facing, rssignal && updated)) {
                dirty = true;
            }
            if (dirty) {
                this.m_6596_();
            }
            if (trigger && this.tick_timer_ > 40) {
                this.tick_timer_ = 40;
            }
        }
    }

    public static class PlacerBlock
    extends StandardBlocks.Directed
    implements StandardEntityBlocks.IStandardEntityBlock<PlacerTileEntity> {
        public PlacerBlock(long config, BlockBehaviour.Properties builder, AABB[] unrotatedAABB) {
            super(config, builder, unrotatedAABB);
        }

        @Override
        public boolean isBlockEntityTicking(Level world, BlockState state) {
            return true;
        }

        @Override
        public VoxelShape m_5939_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext selectionContext) {
            return Shapes.m_83144_();
        }

        public boolean m_7278_(BlockState state) {
            return true;
        }

        public int m_6782_(BlockState blockState, Level world, BlockPos pos) {
            int n;
            BlockEntity blockEntity = world.m_7702_(pos);
            if (blockEntity instanceof PlacerTileEntity) {
                PlacerTileEntity te = (PlacerTileEntity)blockEntity;
                n = RsSignals.fromContainer(te.inventory_);
            } else {
                n = 0;
            }
            return n;
        }

        public boolean shouldCheckWeakPower(BlockState state, LevelReader world, BlockPos pos, Direction side) {
            return false;
        }

        public void m_6402_(Level world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
            if (world.f_46443_) {
                return;
            }
            if (!stack.m_41782_() || !stack.m_41783_().m_128441_("tedata")) {
                return;
            }
            CompoundTag te_nbt = stack.m_41783_().m_128469_("tedata");
            if (te_nbt.m_128456_()) {
                return;
            }
            BlockEntity blockEntity = world.m_7702_(pos);
            if (!(blockEntity instanceof PlacerTileEntity)) {
                return;
            }
            PlacerTileEntity te = (PlacerTileEntity)blockEntity;
            te.readnbt(te_nbt, false);
            te.reset_rtstate();
            te.m_6596_();
        }

        @Override
        public boolean hasDynamicDropList() {
            return true;
        }

        @Override
        public List<ItemStack> dropList(BlockState state, Level world, BlockEntity te, boolean explosion) {
            ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
            if (world.f_46443_) {
                return stacks;
            }
            if (!(te instanceof PlacerTileEntity)) {
                return stacks;
            }
            if (!explosion) {
                ItemStack stack = new ItemStack((ItemLike)this, 1);
                CompoundTag te_nbt = ((PlacerTileEntity)te).clear_getnbt();
                if (!te_nbt.m_128456_()) {
                    CompoundTag nbt = new CompoundTag();
                    nbt.m_128365_("tedata", (Tag)te_nbt);
                    stack.m_41751_(nbt);
                }
                stacks.add(stack);
            } else {
                for (ItemStack stack : ((PlacerTileEntity)te).inventory_) {
                    if (stack.m_41619_()) continue;
                    stacks.add(stack);
                }
                ((PlacerTileEntity)te).reset_rtstate();
            }
            return stacks;
        }

        public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult rayTraceResult) {
            return this.useOpenGui(state, world, pos, player);
        }

        public void m_6861_(BlockState state, Level world, BlockPos pos, Block block, BlockPos fromPos, boolean unused) {
            if (!(world instanceof Level) || world.f_46443_) {
                return;
            }
            BlockEntity te = world.m_7702_(pos);
            if (!(te instanceof PlacerTileEntity)) {
                return;
            }
            ((PlacerTileEntity)te).block_updated();
        }

        public boolean m_7899_(BlockState state) {
            return true;
        }

        public int m_6378_(BlockState blockState, BlockGetter blockAccess, BlockPos pos, Direction side) {
            return 0;
        }

        public int m_6376_(BlockState blockState, BlockGetter blockAccess, BlockPos pos, Direction side) {
            return 0;
        }
    }
}

