/*
 * Decompiled with CFR 0.152.
 */
package wile.engineersdecor.libmc.detail;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import wile.engineersdecor.libmc.detail.Auxiliaries;

public class Registries {
    private static String modid = null;
    private static String creative_tab_icon = "";
    private static CreativeModeTab creative_tab = null;
    private static final Map<String, TagKey<Block>> registered_block_tag_keys = new HashMap<String, TagKey<Block>>();
    private static final Map<String, TagKey<Item>> registered_item_tag_keys = new HashMap<String, TagKey<Item>>();
    private static final Map<String, RegistryObject<Block>> registered_blocks = new HashMap<String, RegistryObject<Block>>();
    private static final Map<String, RegistryObject<Item>> registered_items = new HashMap<String, RegistryObject<Item>>();
    private static final Map<String, RegistryObject<BlockEntityType<?>>> registered_block_entity_types = new HashMap();
    private static final Map<String, RegistryObject<EntityType<?>>> registered_entity_types = new HashMap();
    private static final Map<String, RegistryObject<MenuType<?>>> registered_menu_types = new HashMap();
    private static final Map<String, RegistryObject<RecipeSerializer<?>>> recipe_serializers = new HashMap();
    private static DeferredRegister<Block> BLOCKS;
    private static DeferredRegister<Item> ITEMS;
    private static DeferredRegister<BlockEntityType<?>> BLOCK_ENTITIES;
    private static DeferredRegister<MenuType<?>> MENUS;
    private static DeferredRegister<EntityType<?>> ENTITIES;
    private static DeferredRegister<RecipeSerializer<?>> RECIPE_SERIALIZERS;
    private static List<DeferredRegister<?>> MOD_REGISTRIES;

    public static void init(String mod_id, String creative_tab_icon_item_name, Consumer<DeferredRegister<?>> registrar) {
        modid = mod_id;
        creative_tab_icon = creative_tab_icon_item_name;
        BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)modid);
        ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)modid);
        BLOCK_ENTITIES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCK_ENTITIES, (String)modid);
        MENUS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.CONTAINERS, (String)modid);
        ENTITIES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENTITIES, (String)modid);
        RECIPE_SERIALIZERS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.RECIPE_SERIALIZERS, (String)modid);
        List.of(BLOCKS, ITEMS, BLOCK_ENTITIES, MENUS, ENTITIES, RECIPE_SERIALIZERS).forEach(registrar);
    }

    public static CreativeModeTab getCreativeModeTab() {
        if (creative_tab == null) {
            creative_tab = new CreativeModeTab("tab" + modid){

                public ItemStack m_6976_() {
                    return new ItemStack((ItemLike)Registries.getItem(creative_tab_icon));
                }
            };
        }
        return creative_tab;
    }

    public static Block getBlock(String block_name) {
        return (Block)registered_blocks.get(block_name).get();
    }

    public static Item getItem(String name) {
        return (Item)registered_items.get(name).get();
    }

    public static EntityType<?> getEntityType(String name) {
        return (EntityType)registered_entity_types.get(name).get();
    }

    public static BlockEntityType<?> getBlockEntityType(String block_name) {
        return (BlockEntityType)registered_block_entity_types.get(block_name).get();
    }

    public static MenuType<?> getMenuType(String name) {
        return (MenuType)registered_menu_types.get(name).get();
    }

    public static RecipeSerializer<?> getRecipeSerializer(String name) {
        return (RecipeSerializer)recipe_serializers.get(name).get();
    }

    public static BlockEntityType<?> getBlockEntityTypeOfBlock(String block_name) {
        return Registries.getBlockEntityType("tet_" + block_name);
    }

    public static BlockEntityType<?> getBlockEntityTypeOfBlock(Block block) {
        return Registries.getBlockEntityTypeOfBlock(ForgeRegistries.BLOCKS.getKey((Object)block).m_135815_());
    }

    public static MenuType<?> getMenuTypeOfBlock(String name) {
        return Registries.getMenuType("ct_" + name);
    }

    public static MenuType<?> getMenuTypeOfBlock(Block block) {
        return Registries.getMenuTypeOfBlock(ForgeRegistries.BLOCKS.getKey((Object)block).m_135815_());
    }

    public static TagKey<Block> getBlockTagKey(String name) {
        return registered_block_tag_keys.get(name);
    }

    public static TagKey<Item> getItemTagKey(String name) {
        return registered_item_tag_keys.get(name);
    }

    @Nonnull
    public static List<Block> getRegisteredBlocks() {
        return Collections.unmodifiableList(registered_blocks.values().stream().map(RegistryObject::get).toList());
    }

    @Nonnull
    public static List<Item> getRegisteredItems() {
        return Collections.unmodifiableList(registered_items.values().stream().map(RegistryObject::get).toList());
    }

    @Nonnull
    public static List<BlockEntityType<?>> getRegisteredBlockEntityTypes() {
        return Collections.unmodifiableList(registered_block_entity_types.values().stream().map(RegistryObject::get).toList());
    }

    @Nonnull
    public static List<EntityType<?>> getRegisteredEntityTypes() {
        return Collections.unmodifiableList(registered_entity_types.values().stream().map(RegistryObject::get).toList());
    }

    public static <T extends Item> void addItem(String registry_name, Supplier<T> supplier) {
        registered_items.put(registry_name, (RegistryObject<Item>)ITEMS.register(registry_name, supplier));
    }

    public static <T extends Block> void addBlock(String registry_name, Supplier<T> block_supplier) {
        registered_blocks.put(registry_name, (RegistryObject<Block>)BLOCKS.register(registry_name, block_supplier));
        registered_items.put(registry_name, (RegistryObject<Item>)ITEMS.register(registry_name, () -> new BlockItem((Block)registered_blocks.get(registry_name).get(), new Item.Properties().m_41491_(Registries.getCreativeModeTab()))));
    }

    public static <TB extends Block, TI extends Item> void addBlock(String registry_name, Supplier<TB> block_supplier, Supplier<TI> item_supplier) {
        registered_blocks.put(registry_name, (RegistryObject<Block>)BLOCKS.register(registry_name, block_supplier));
        registered_items.put(registry_name, (RegistryObject<Item>)ITEMS.register(registry_name, item_supplier));
    }

    public static <T extends BlockEntity> void addBlockEntityType(String registry_name, BlockEntityType.BlockEntitySupplier<T> ctor, String ... block_names) {
        registered_block_entity_types.put(registry_name, BLOCK_ENTITIES.register(registry_name, () -> {
            Block[] blocks = Arrays.stream(block_names).map(s -> {
                Block b = BLOCKS.getEntries().stream().filter(ro -> ro.getId().m_135815_().equals(s)).findFirst().map(RegistryObject::get).orElse(null);
                if (b == null) {
                    Auxiliaries.logError("registered_blocks does not encompass '" + s + "'");
                }
                return b;
            }).filter(Objects::nonNull).collect(Collectors.toList()).toArray(new Block[0]);
            return BlockEntityType.Builder.m_155273_((BlockEntityType.BlockEntitySupplier)ctor, (Block[])blocks).m_58966_(null);
        }));
    }

    public static <T extends EntityType<?>> void addEntityType(String registry_name, Supplier<EntityType<?>> supplier) {
        registered_entity_types.put(registry_name, ENTITIES.register(registry_name, supplier));
    }

    public static <T extends MenuType<?>> void addMenuType(String registry_name, MenuType.MenuSupplier<?> supplier) {
        registered_menu_types.put(registry_name, MENUS.register(registry_name, () -> new MenuType(supplier)));
    }

    public static void addRecipeSerializer(String registry_name, Supplier<? extends RecipeSerializer<?>> serializer_supplier) {
        recipe_serializers.put(registry_name, RECIPE_SERIALIZERS.register(registry_name, serializer_supplier));
    }

    public static void addOptionalBlockTag(String tag_name, ResourceLocation ... default_blocks) {
        HashSet<Supplier<Block>> default_suppliers = new HashSet<Supplier<Block>>();
        for (ResourceLocation rl : default_blocks) {
            default_suppliers.add(() -> (Block)ForgeRegistries.BLOCKS.getValue(rl));
        }
        TagKey key = ForgeRegistries.BLOCKS.tags().createOptionalTagKey(new ResourceLocation(modid, tag_name), default_suppliers);
        registered_block_tag_keys.put(tag_name, (TagKey<Block>)key);
    }

    public static void addOptionaItemTag(String tag_name, ResourceLocation ... default_items) {
        HashSet<Supplier<Item>> default_suppliers = new HashSet<Supplier<Item>>();
        for (ResourceLocation rl : default_items) {
            default_suppliers.add(() -> (Item)ForgeRegistries.ITEMS.getValue(rl));
        }
        TagKey key = ForgeRegistries.ITEMS.tags().createOptionalTagKey(new ResourceLocation(modid, tag_name), default_suppliers);
        registered_item_tag_keys.put(tag_name, (TagKey<Item>)key);
    }

    public static <TB extends Block, TI extends Item> void addBlock(String registry_name, Supplier<TB> block_supplier, BiFunction<Block, Item.Properties, Item> item_builder) {
        Registries.addBlock(registry_name, block_supplier, () -> (Item)item_builder.apply((Block)registered_blocks.get(registry_name).get(), new Item.Properties().m_41491_(Registries.getCreativeModeTab())));
    }

    public static void addBlock(String registry_name, Supplier<? extends Block> block_supplier, BlockEntityType.BlockEntitySupplier<?> block_entity_ctor) {
        Registries.addBlock(registry_name, block_supplier);
        Registries.addBlockEntityType("tet_" + registry_name, block_entity_ctor, registry_name);
    }

    public static void addBlock(String registry_name, Supplier<? extends Block> block_supplier, BiFunction<Block, Item.Properties, Item> item_builder, BlockEntityType.BlockEntitySupplier<?> block_entity_ctor) {
        Registries.addBlock(registry_name, block_supplier, item_builder);
        Registries.addBlockEntityType("tet_" + registry_name, block_entity_ctor, registry_name);
    }

    public static void addBlock(String registry_name, Supplier<? extends Block> block_supplier, BiFunction<Block, Item.Properties, Item> item_builder, BlockEntityType.BlockEntitySupplier<?> block_entity_ctor, MenuType.MenuSupplier<?> menu_type_supplier) {
        Registries.addBlock(registry_name, block_supplier, item_builder);
        Registries.addBlockEntityType("tet_" + registry_name, block_entity_ctor, registry_name);
        Registries.addMenuType("ct_" + registry_name, menu_type_supplier);
    }

    public static void addBlock(String registry_name, Supplier<? extends Block> block_supplier, BlockEntityType.BlockEntitySupplier<?> block_entity_ctor, MenuType.MenuSupplier<?> menu_type_supplier) {
        Registries.addBlock(registry_name, block_supplier, block_entity_ctor);
        Registries.addMenuType("ct_" + registry_name, menu_type_supplier);
    }
}

