/*
 * Decompiled with CFR 0.152.
 */
package wile.engineersdecor.blocks;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import wile.engineersdecor.ModConfig;
import wile.engineersdecor.ModContent;
import wile.engineersdecor.libmc.Fluidics;
import wile.engineersdecor.libmc.StandardBlocks;
import wile.engineersdecor.libmc.StandardEntityBlocks;

public class EdFreezer {
    public static void on_config(int consumption, int cooldown_per_second) {
        FreezerTileEntity.on_config(consumption, cooldown_per_second);
    }

    public static class FreezerTileEntity
    extends StandardEntityBlocks.StandardBlockEntity
    implements IEnergyStorage {
        public static final int TICK_INTERVAL = 20;
        public static final int MAX_FLUID_LEVEL = 2000;
        public static final int MAX_ENERGY_BUFFER = 32000;
        public static final int MAX_ENERGY_TRANSFER = 8192;
        public static final int TANK_CAPACITY = 2000;
        public static final int DEFAULT_ENERGY_CONSUMPTION = 92;
        public static final int DEFAULT_COOLDOWN_RATE = 2;
        public static final int PHASE_EMPTY = 0;
        public static final int PHASE_WATER = 1;
        public static final int PHASE_ICE = 2;
        public static final int PHASE_PACKEDICE = 3;
        public static final int PHASE_BLUEICE = 4;
        private static int energy_consumption = 92;
        private static int cooldown_rate = 2;
        private static int reheat_rate = 1;
        private final Fluidics.Tank tank_ = new Fluidics.Tank(2000, 2000, 2000, fs -> fs.getFluid() == Fluids.f_76193_);
        private int tick_timer_;
        private int energy_stored_;
        private int progress_;
        private boolean force_block_update_;
        private final LazyOptional<IItemHandler> item_handler_ = LazyOptional.of(() -> new FreezerItemHandler(this));
        private final LazyOptional<IFluidHandler> fluid_handler_ = LazyOptional.of(() -> new Fluidics.SingleTankFluidHandler(this.tank_));
        protected LazyOptional<IEnergyStorage> energy_handler_ = LazyOptional.of(() -> this);

        public static void on_config(int consumption, int cooldown_per_second) {
            energy_consumption = Mth.m_14045_((int)consumption, (int)8, (int)4096);
            cooldown_rate = Mth.m_14045_((int)cooldown_per_second, (int)1, (int)5);
            reheat_rate = Mth.m_14045_((int)(cooldown_per_second / 2), (int)1, (int)5);
            ModConfig.log("Config freezer energy consumption:" + energy_consumption + "rf/t, cooldown-rate: " + cooldown_rate + "%/s.");
        }

        public FreezerTileEntity(BlockPos pos, BlockState state) {
            super(ModContent.getBlockEntityTypeOfBlock(state.m_60734_()), pos, state);
        }

        public int progress() {
            return this.progress_;
        }

        public int phase() {
            if (this.tank_.getFluidAmount() < 1000) {
                return 0;
            }
            if (this.progress_ >= 100) {
                return 4;
            }
            if (this.progress_ >= 70) {
                return 3;
            }
            if (this.progress_ >= 30) {
                return 2;
            }
            return 1;
        }

        public ItemStack getIceItem(boolean extract) {
            ItemStack stack;
            switch (this.phase()) {
                case 2: {
                    stack = new ItemStack((ItemLike)Items.f_41980_);
                    break;
                }
                case 3: {
                    stack = new ItemStack((ItemLike)Items.f_42201_);
                    break;
                }
                case 4: {
                    stack = new ItemStack((ItemLike)Items.f_42363_);
                    break;
                }
                default: {
                    return ItemStack.f_41583_;
                }
            }
            if (extract) {
                this.reset_process();
            }
            return stack;
        }

        public int comparator_signal() {
            return this.phase() * 4;
        }

        protected void reset_process() {
            this.force_block_update_ = true;
            this.tank_.drain(1000);
            this.tick_timer_ = 0;
            this.progress_ = 0;
        }

        public void readnbt(CompoundTag nbt) {
            this.energy_stored_ = nbt.m_128451_("energy");
            this.progress_ = nbt.m_128451_("progress");
            this.tank_.load(nbt);
        }

        protected void writenbt(CompoundTag nbt) {
            nbt.m_128405_("energy", Mth.m_14045_((int)this.energy_stored_, (int)0, (int)32000));
            nbt.m_128405_("progress", Mth.m_14045_((int)this.progress_, (int)0, (int)100));
            this.tank_.save(nbt);
        }

        public void m_142466_(CompoundTag nbt) {
            super.m_142466_(nbt);
            this.readnbt(nbt);
        }

        protected void m_183515_(CompoundTag nbt) {
            super.m_183515_(nbt);
            this.writenbt(nbt);
        }

        public void m_7651_() {
            super.m_7651_();
            this.energy_handler_.invalidate();
            this.fluid_handler_.invalidate();
            this.item_handler_.invalidate();
        }

        public boolean canExtract() {
            return false;
        }

        public boolean canReceive() {
            return true;
        }

        public int getMaxEnergyStored() {
            return 32000;
        }

        public int getEnergyStored() {
            return this.energy_stored_;
        }

        public int extractEnergy(int maxExtract, boolean simulate) {
            return 0;
        }

        public int receiveEnergy(int maxReceive, boolean simulate) {
            if (this.energy_stored_ >= 32000) {
                return 0;
            }
            int n = Math.min(maxReceive, 32000 - this.energy_stored_);
            if (n > 8192) {
                n = 8192;
            }
            if (!simulate) {
                this.energy_stored_ += n;
                this.m_6596_();
            }
            return n;
        }

        public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
            if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
                return this.item_handler_.cast();
            }
            if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
                return this.fluid_handler_.cast();
            }
            if (capability == CapabilityEnergy.ENERGY) {
                return this.energy_handler_.cast();
            }
            return super.getCapability(capability, facing);
        }

        @Override
        public void tick() {
            if (this.f_58857_.f_46443_) {
                return;
            }
            if (--this.tick_timer_ > 0) {
                return;
            }
            this.tick_timer_ = 20;
            BlockState state = this.f_58857_.m_8055_(this.f_58858_);
            if (!(state.m_60734_() instanceof FreezerBlock)) {
                return;
            }
            boolean dirty = false;
            int last_phase = this.phase();
            if (this.tank_.getFluidAmount() < 1000) {
                this.progress_ = 0;
            } else if (this.energy_stored_ <= 0 || this.f_58857_.m_46753_(this.f_58858_)) {
                this.progress_ = Mth.m_14045_((int)(this.progress_ - reheat_rate), (int)0, (int)100);
            } else if (this.progress_ >= 100) {
                this.progress_ = 100;
                this.energy_stored_ = Mth.m_14045_((int)(this.energy_stored_ - energy_consumption * 20 / 20), (int)0, (int)32000);
            } else {
                this.energy_stored_ = Mth.m_14045_((int)(this.energy_stored_ - energy_consumption * 20), (int)0, (int)32000);
                this.progress_ = Mth.m_14045_((int)(this.progress_ + cooldown_rate), (int)0, (int)100);
            }
            int new_phase = this.phase();
            if (new_phase > last_phase) {
                this.f_58857_.m_5594_(null, this.f_58858_, SoundEvents.f_12332_, SoundSource.BLOCKS, 0.2f, 0.7f);
            } else if (new_phase < last_phase) {
                this.f_58857_.m_5594_(null, this.f_58858_, SoundEvents.f_12332_, SoundSource.BLOCKS, 0.2f, 0.7f);
            }
            if (this.force_block_update_ || (Integer)state.m_61143_((Property)FreezerBlock.PHASE) != new_phase) {
                state = (BlockState)state.m_61124_((Property)FreezerBlock.PHASE, (Comparable)Integer.valueOf(new_phase));
                this.f_58857_.m_7731_(this.f_58858_, state, 19);
                this.f_58857_.m_46672_(this.m_58899_(), state.m_60734_());
                this.force_block_update_ = false;
            }
            if (dirty) {
                this.m_6596_();
            }
        }

        protected static class FreezerItemHandler
        implements IItemHandler {
            private final FreezerTileEntity te;

            FreezerItemHandler(FreezerTileEntity te) {
                this.te = te;
            }

            public int getSlots() {
                return 1;
            }

            public int getSlotLimit(int index) {
                return 1;
            }

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                return false;
            }

            @Nonnull
            public ItemStack getStackInSlot(int index) {
                return index != 0 ? ItemStack.f_41583_ : this.te.getIceItem(false);
            }

            @Nonnull
            public ItemStack insertItem(int index, @Nonnull ItemStack stack, boolean simulate) {
                return ItemStack.f_41583_;
            }

            @Nonnull
            public ItemStack extractItem(int index, int amount, boolean simulate) {
                return this.te.getIceItem(!simulate);
            }
        }
    }

    public static class FreezerBlock
    extends StandardBlocks.Horizontal
    implements StandardEntityBlocks.IStandardEntityBlock<FreezerTileEntity> {
        public static final int PHASE_MAX = 4;
        public static final IntegerProperty PHASE = IntegerProperty.m_61631_((String)"phase", (int)0, (int)4);

        public FreezerBlock(long config, BlockBehaviour.Properties builder, AABB unrotatedAABB) {
            super(config, builder, unrotatedAABB);
        }

        @Override
        public boolean isBlockEntityTicking(Level world, BlockState state) {
            return true;
        }

        @Override
        public VoxelShape m_5939_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext selectionContext) {
            return Shapes.m_83144_();
        }

        @Override
        protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
            super.m_7926_(builder);
            builder.m_61104_(new Property[]{PHASE});
        }

        @Override
        @Nullable
        public BlockState m_5573_(BlockPlaceContext context) {
            return (BlockState)super.m_5573_(context).m_61124_((Property)PHASE, (Comparable)Integer.valueOf(0));
        }

        public boolean m_7278_(BlockState state) {
            return true;
        }

        public int m_6782_(BlockState state, Level world, BlockPos pos) {
            return Mth.m_14045_((int)((Integer)state.m_61143_((Property)PHASE) * 4), (int)0, (int)15);
        }

        public void m_6402_(Level world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        }

        @Override
        public boolean hasDynamicDropList() {
            return true;
        }

        @Override
        public List<ItemStack> dropList(BlockState state, Level world, BlockEntity te, boolean explosion) {
            ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
            if (world.f_46443_) {
                return stacks;
            }
            if (!(te instanceof FreezerTileEntity)) {
                return stacks;
            }
            ((FreezerTileEntity)te).reset_process();
            stacks.add(new ItemStack((ItemLike)this, 1));
            return stacks;
        }

        public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult rayTraceResult) {
            if (player.m_6144_()) {
                return InteractionResult.PASS;
            }
            if (world.m_5776_()) {
                return InteractionResult.SUCCESS;
            }
            FreezerTileEntity te = this.getTe(world, pos);
            if (te == null) {
                return InteractionResult.FAIL;
            }
            ItemStack stack = player.m_21120_(hand);
            boolean dirty = false;
            if (Fluidics.manualFluidHandlerInteraction(world, pos, null, player, hand)) {
                world.m_5594_(null, pos, SoundEvents.f_11778_, SoundSource.BLOCKS, 0.5f, 1.4f);
                return InteractionResult.CONSUME;
            }
            if (stack.m_41720_() == Items.f_42447_) {
                return InteractionResult.CONSUME;
            }
            if (stack.m_41619_()) {
                ItemStack ice = te.getIceItem(true);
                if (!ice.m_41619_()) {
                    player.m_36356_(ice);
                    world.m_5594_(null, pos, SoundEvents.f_12019_, SoundSource.BLOCKS, 0.3f, 1.1f);
                } else {
                    world.m_5594_(null, pos, SoundEvents.f_12012_, SoundSource.BLOCKS, 0.2f, 0.02f);
                }
                return InteractionResult.CONSUME;
            }
            return InteractionResult.PASS;
        }

        public boolean shouldCheckWeakPower(BlockState state, LevelReader world, BlockPos pos, Direction side) {
            return false;
        }

        @OnlyIn(value=Dist.CLIENT)
        public void m_214162_(BlockState state, Level world, BlockPos pos, RandomSource rnd) {
        }

        @Nullable
        private FreezerTileEntity getTe(Level world, BlockPos pos) {
            BlockEntity te = world.m_7702_(pos);
            return !(te instanceof FreezerTileEntity) ? null : (FreezerTileEntity)te;
        }
    }
}

