/*
 * Decompiled with CFR 0.152.
 */
package wile.engineersdecor.blocks;

import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import wile.engineersdecor.ModConfig;
import wile.engineersdecor.ModContent;
import wile.engineersdecor.libmc.Auxiliaries;
import wile.engineersdecor.libmc.Overlay;
import wile.engineersdecor.libmc.RfEnergy;
import wile.engineersdecor.libmc.StandardBlocks;
import wile.engineersdecor.libmc.StandardEntityBlocks;

public class EdSolarPanel {
    public static final int DEFAULT_PEAK_POWER = 40;
    private static int peak_power_per_tick_ = 40;
    private static int max_power_storage_ = 64000;
    private static int max_feed_power = 4096;
    private static int feeding_threshold = max_power_storage_ / 5;
    private static int balancing_threshold = max_power_storage_ / 10;

    public static void on_config(int peak_power_per_tick, int battery_capacity, int max_feed_in_power) {
        int t = 4;
        peak_power_per_tick_ = Mth.m_14045_((int)peak_power_per_tick, (int)12, (int)8192);
        feeding_threshold = Math.max(max_power_storage_ / 5, 1000);
        balancing_threshold = Math.max(max_power_storage_ / 10, 1000);
        max_power_storage_ = battery_capacity;
        max_feed_power = max_feed_in_power * 4;
        ModConfig.log("Config small solar panel: Peak production:" + peak_power_per_tick_ + "/t, capacity:" + max_power_storage_ + "rf, max-feed:" + max_feed_power / 4 + "rf/t");
    }

    public static class SolarPanelTileEntity
    extends StandardEntityBlocks.StandardBlockEntity {
        public static final int TICK_INTERVAL = 4;
        public static final int ACCUMULATION_INTERVAL = 8;
        private static final Direction[] transfer_directions_ = new Direction[]{Direction.DOWN, Direction.EAST, Direction.SOUTH, Direction.WEST, Direction.NORTH};
        private int tick_timer_ = 0;
        private int recalc_timer_ = 0;
        private int current_production_ = 0;
        private int current_feedin_ = 0;
        private boolean output_enabled_ = false;
        private final RfEnergy.Battery battery_ = new RfEnergy.Battery(max_power_storage_, 0, 1024);
        private final LazyOptional<IEnergyStorage> energy_handler_ = this.battery_.createEnergyHandler();

        public SolarPanelTileEntity(BlockPos pos, BlockState state) {
            super(ModContent.getBlockEntityTypeOfBlock(state.m_60734_()), pos, state);
        }

        public void readnbt(CompoundTag nbt, boolean update_packet) {
            this.battery_.load(nbt);
        }

        protected void writenbt(CompoundTag nbt, boolean update_packet) {
            this.battery_.save(nbt);
        }

        public void state_message(Player player) {
            String soc = Integer.toString(Mth.m_14045_((int)(this.battery_.getEnergyStored() * 100 / max_power_storage_), (int)0, (int)100));
            Overlay.show(player, (Component)Auxiliaries.localizable("block.engineersdecor.small_solar_panel.status", soc, max_power_storage_, this.current_production_, this.current_feedin_));
        }

        public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
            if (capability == CapabilityEnergy.ENERGY) {
                return this.energy_handler_.cast();
            }
            return super.getCapability(capability, facing);
        }

        public void m_142466_(CompoundTag nbt) {
            super.m_142466_(nbt);
            this.readnbt(nbt, false);
        }

        protected void m_183515_(CompoundTag nbt) {
            super.m_183515_(nbt);
            this.writenbt(nbt, false);
        }

        public void m_7651_() {
            super.m_7651_();
            this.energy_handler_.invalidate();
        }

        @Override
        public void tick() {
            if (this.f_58857_.f_46443_ || --this.tick_timer_ > 0) {
                return;
            }
            this.tick_timer_ = 4;
            BlockState state = this.f_58857_.m_8055_(this.f_58858_);
            if (!(state.m_60734_() instanceof SolarPanelBlock)) {
                return;
            }
            this.current_feedin_ = 0;
            ArrayList<SolarPanelTileEntity> adjacent_panels = new ArrayList<SolarPanelTileEntity>();
            if (this.output_enabled_) {
                for (int i = 0; i < transfer_directions_.length && !this.battery_.isEmpty(); ++i) {
                    IEnergyStorage es;
                    Direction f = transfer_directions_[i];
                    BlockEntity te = this.f_58857_.m_7702_(this.f_58858_.m_121945_(f));
                    if (te == null || (es = (IEnergyStorage)te.getCapability(CapabilityEnergy.ENERGY, f.m_122424_()).orElse(null)) == null) continue;
                    if (!es.canReceive()) {
                        if (!(te instanceof SolarPanelTileEntity)) continue;
                        adjacent_panels.add((SolarPanelTileEntity)te);
                        continue;
                    }
                    int feed_power = this.battery_.getEnergyStored() > max_power_storage_ / 10 ? max_feed_power : Math.max(this.current_production_ * 2, peak_power_per_tick_ / 4);
                    int fed = es.receiveEnergy(Math.min(this.battery_.getEnergyStored(), feed_power * 4), false);
                    this.battery_.draw(fed);
                    this.current_feedin_ += fed;
                }
            }
            this.current_feedin_ /= 4;
            if (this.current_feedin_ <= 0 && (this.battery_.getEnergyStored() >= balancing_threshold || this.current_production_ <= 0)) {
                for (SolarPanelTileEntity panel : adjacent_panels) {
                    if (panel.battery_.getEnergyStored() >= this.battery_.getEnergyStored() - balancing_threshold) continue;
                    panel.battery_.setEnergyStored(panel.battery_.getEnergyStored() + balancing_threshold);
                    this.battery_.setEnergyStored(this.battery_.getEnergyStored() - balancing_threshold);
                    if (this.battery_.getEnergyStored() >= balancing_threshold) continue;
                    break;
                }
            }
            if (!this.f_58857_.m_46861_(this.f_58858_)) {
                this.tick_timer_ = 40;
                this.current_production_ = 0;
                if (!this.battery_.isEmpty()) {
                    this.output_enabled_ = true;
                }
                if ((Integer)state.m_61143_((Property)SolarPanelBlock.EXPOSITION) != 2) {
                    this.f_58857_.m_46597_(this.f_58858_, (BlockState)state.m_61124_((Property)SolarPanelBlock.EXPOSITION, (Comparable)Integer.valueOf(2)));
                }
                return;
            }
            if (this.battery_.isEmpty()) {
                this.output_enabled_ = false;
            }
            if (--this.recalc_timer_ > 0) {
                return;
            }
            this.recalc_timer_ = 8 + (int)(Math.random() + 0.5);
            int theta = ((int)((double)this.f_58857_.m_46490_(1.0f) * 57.29577951308232) + 90) % 360;
            int e = 2;
            if (theta > 340) {
                e = 2;
            } else if (theta < 45) {
                e = 0;
            } else if (theta < 80) {
                e = 1;
            } else if (theta < 100) {
                e = 2;
            } else if (theta < 135) {
                e = 3;
            } else if (theta < 190) {
                e = 4;
            }
            BlockState nstate = (BlockState)state.m_61124_((Property)SolarPanelBlock.EXPOSITION, (Comparable)Integer.valueOf(e));
            if (nstate != state) {
                this.f_58857_.m_7731_(this.f_58858_, nstate, 3);
            }
            double eff = 1.0 - ((double)this.f_58857_.m_46722_(1.0f) * 0.6 + (double)this.f_58857_.m_46661_(1.0f) * 0.3);
            double ll = (double)this.f_58857_.m_5518_().m_75814_(LightLayer.SKY).m_7768_(this.m_58899_()) / 15.0;
            double rf = Math.sin(1.5707963267948966 * Math.sqrt((double)(theta < 0 || theta > 180 ? 0 : (theta > 90 ? 180 - theta : theta)) / 90.0));
            this.current_production_ = (int)(Math.min(rf * rf * eff * ll, 1.0) * (double)peak_power_per_tick_);
            this.battery_.setEnergyStored(Math.min(this.battery_.getEnergyStored() + this.current_production_ * 32, max_power_storage_));
            if (this.battery_.getEnergyStored() >= feeding_threshold) {
                this.output_enabled_ = true;
            }
        }
    }

    public static class SolarPanelBlock
    extends StandardBlocks.Cutout
    implements StandardEntityBlocks.IStandardEntityBlock<SolarPanelTileEntity> {
        public static final IntegerProperty EXPOSITION = IntegerProperty.m_61631_((String)"exposition", (int)0, (int)4);

        public SolarPanelBlock(long config, BlockBehaviour.Properties builder, AABB[] unrotatedAABB) {
            super(config, builder, unrotatedAABB);
            this.m_49959_((BlockState)super.m_49966_().m_61124_((Property)EXPOSITION, (Comparable)Integer.valueOf(1)));
        }

        @Override
        public boolean isBlockEntityTicking(Level world, BlockState state) {
            return true;
        }

        protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
            super.m_7926_(builder);
            builder.m_61104_(new Property[]{EXPOSITION});
        }

        public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
            if (world.m_5776_()) {
                return InteractionResult.SUCCESS;
            }
            BlockEntity te = world.m_7702_(pos);
            if (te instanceof SolarPanelTileEntity) {
                ((SolarPanelTileEntity)te).state_message(player);
            }
            return InteractionResult.CONSUME;
        }

        public boolean shouldCheckWeakPower(BlockState state, LevelReader world, BlockPos pos, Direction side) {
            return false;
        }
    }
}

