/*
 * Decompiled with CFR 0.152.
 */
package wile.engineersdecor.blocks;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import wile.engineersdecor.ModConfig;
import wile.engineersdecor.ModContent;
import wile.engineersdecor.libmc.Auxiliaries;
import wile.engineersdecor.libmc.Fluidics;
import wile.engineersdecor.libmc.Inventories;
import wile.engineersdecor.libmc.RfEnergy;
import wile.engineersdecor.libmc.StandardBlocks;
import wile.engineersdecor.libmc.StandardEntityBlocks;

public class EdMineralSmelter {
    public static void on_config(int consumption, int heatup_per_second) {
        MineralSmelterTileEntity.on_config(consumption, heatup_per_second);
    }

    public static class MineralSmelterTileEntity
    extends StandardEntityBlocks.StandardBlockEntity {
        public static final int NUM_OF_SLOTS = 2;
        public static final int TICK_INTERVAL = 20;
        public static final int MAX_FLUID_LEVEL = 2000;
        public static final int MAX_BUCKET_EXTRACT_FLUID_LEVEL = 900;
        public static final int MAX_ENERGY_BUFFER = 32000;
        public static final int MAX_ENERGY_TRANSFER = 8192;
        public static final int DEFAULT_ENERGY_CONSUMPTION = 92;
        public static final int DEFAULT_HEATUP_RATE = 2;
        public static final int PHASE_WARMUP = 0;
        public static final int PHASE_HOT = 1;
        public static final int PHASE_MAGMABLOCK = 2;
        public static final int PHASE_LAVA = 3;
        private static final ItemStack MAGMA_STACK = new ItemStack((ItemLike)Blocks.f_50450_);
        private static final ItemStack BUCKET_STACK = new ItemStack((ItemLike)Items.f_42446_);
        private static final ItemStack LAVA_BUCKET_STACK = new ItemStack((ItemLike)Items.f_42448_);
        private static final FluidStack LAVA_BUCKET_FLUID_STACK = new FluidStack((Fluid)Fluids.f_76195_, 1000);
        private static final Set<Item> accepted_minerals = new HashSet<Item>();
        private static final Set<Item> accepted_lava_contrainers = new HashSet<Item>();
        private static int energy_consumption = 92;
        private static int heatup_rate = 2;
        private static int cooldown_rate = 1;
        private int tick_timer_;
        private int progress_;
        private boolean force_block_update_;
        private final RfEnergy.Battery battery_ = new RfEnergy.Battery(32000, 8192, 0);
        private final LazyOptional<IEnergyStorage> energy_handler_ = this.battery_.createEnergyHandler();
        private final Fluidics.Tank tank_ = new Fluidics.Tank(2000, 0, 100);
        private final LazyOptional<? extends IFluidHandler> fluid_handler_ = this.tank_.createOutputFluidHandler();
        private final Inventories.StorageInventory main_inventory_ = new Inventories.StorageInventory(this, 2, 1).setStackLimit(1);
        private final LazyOptional<? extends IItemHandler> item_handler_ = Inventories.MappedItemHandler.createGenericHandler(this.main_inventory_, (index, stack) -> index == 1 && this.phase() != 3, (index, stack) -> index == 0 && this.progress_ == 0 && this.accepts_input((ItemStack)stack), (index, stack) -> {}, (index, stack) -> {
            if (index != 0) {
                this.reset_process();
            }
        });

        public static void on_config(int consumption, int heatup_per_second) {
            energy_consumption = Mth.m_14045_((int)consumption, (int)8, (int)4096);
            heatup_rate = Mth.m_14045_((int)heatup_per_second, (int)1, (int)5);
            cooldown_rate = Mth.m_14045_((int)(heatup_per_second / 2), (int)1, (int)5);
            ModConfig.log("Config mineal smelter: energy consumption:" + energy_consumption + "rf/t, heat-up rate: " + heatup_rate + "%/s.");
        }

        public MineralSmelterTileEntity(BlockPos pos, BlockState state) {
            super(ModContent.getBlockEntityTypeOfBlock(state.m_60734_()), pos, state);
        }

        public int progress() {
            return this.progress_;
        }

        public int phase() {
            if (this.progress_ >= 100) {
                return 3;
            }
            if (this.progress_ >= 90) {
                return 2;
            }
            if (this.progress_ >= 5) {
                return 1;
            }
            return 0;
        }

        public boolean bucket_extraction_possible() {
            return this.tank_.getFluidAmount() >= 900;
        }

        public int comparator_signal() {
            return this.phase() * 5;
        }

        private boolean accepts_lava_container(ItemStack stack) {
            return accepted_lava_contrainers.contains(stack.m_41720_());
        }

        private boolean accepts_input(ItemStack stack) {
            if (!this.main_inventory_.m_7983_()) {
                return false;
            }
            if (this.bucket_extraction_possible()) {
                return this.accepts_lava_container(stack);
            }
            return accepted_minerals.contains(stack.m_41720_()) || Auxiliaries.isInItemTag(stack.m_41720_(), new ResourceLocation(Auxiliaries.modid(), "accepted_mineral_smelter_input"));
        }

        public boolean insert(ItemStack stack, boolean simulate) {
            if (stack.m_41619_() || !this.accepts_input(stack)) {
                return false;
            }
            if (!simulate) {
                ItemStack st = stack.m_41777_();
                st.m_41764_(1);
                this.main_inventory_.m_6836_(0, st);
                if (!this.accepts_lava_container(stack)) {
                    this.progress_ = 0;
                }
                this.force_block_update_ = true;
            }
            return true;
        }

        public ItemStack extract(boolean simulate) {
            ItemStack stack = this.main_inventory_.m_8020_(1).m_41777_();
            if (stack.m_41619_()) {
                return ItemStack.f_41583_;
            }
            if (!simulate) {
                this.reset_process();
            }
            return stack;
        }

        protected void reset_process() {
            this.main_inventory_.m_6836_(0, ItemStack.f_41583_);
            this.main_inventory_.m_6836_(1, ItemStack.f_41583_);
            this.tank_.clear();
            this.force_block_update_ = true;
            this.tick_timer_ = 0;
            this.progress_ = 0;
        }

        public void readnbt(CompoundTag nbt) {
            this.main_inventory_.load(nbt);
            this.battery_.load(nbt);
            this.tank_.load(nbt);
            this.progress_ = nbt.m_128451_("progress");
        }

        protected void writenbt(CompoundTag nbt) {
            this.main_inventory_.save(nbt);
            this.battery_.save(nbt);
            this.tank_.save(nbt);
            nbt.m_128405_("progress", Mth.m_14045_((int)this.progress_, (int)0, (int)100));
        }

        public void m_142466_(CompoundTag nbt) {
            super.m_142466_(nbt);
            this.readnbt(nbt);
        }

        protected void m_183515_(CompoundTag nbt) {
            super.m_183515_(nbt);
            this.writenbt(nbt);
        }

        public void m_7651_() {
            super.m_7651_();
            this.energy_handler_.invalidate();
            this.fluid_handler_.invalidate();
            this.item_handler_.invalidate();
        }

        public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
            if (capability == ForgeCapabilities.ITEM_HANDLER) {
                return this.item_handler_.cast();
            }
            if (capability == ForgeCapabilities.FLUID_HANDLER) {
                return this.fluid_handler_.cast();
            }
            if (capability == ForgeCapabilities.ENERGY) {
                return this.energy_handler_.cast();
            }
            return super.getCapability(capability, facing);
        }

        @Override
        public void tick() {
            if (--this.tick_timer_ > 0) {
                return;
            }
            this.tick_timer_ = 20;
            BlockState state = this.f_58857_.m_8055_(this.f_58858_);
            if (!(state.m_60734_() instanceof MineralSmelterBlock)) {
                return;
            }
            boolean dirty = false;
            int last_phase = this.phase();
            ItemStack istack = this.main_inventory_.m_8020_(0);
            if (istack.m_41619_() && this.tank_.getFluidAmount() < 900 && this.phase() != 3) {
                this.progress_ = 0;
                this.tank_.clear();
                this.main_inventory_.m_6211_();
            } else if (this.battery_.isEmpty() || this.f_58857_.m_46753_(this.f_58858_)) {
                this.progress_ = Mth.m_14045_((int)(this.progress_ - cooldown_rate), (int)0, (int)100);
            } else if (this.progress_ >= 100) {
                this.progress_ = 100;
                if (!this.battery_.draw(energy_consumption * 20 / 20)) {
                    this.battery_.clear();
                }
            } else if (this.phase() >= 3 || !istack.m_41619_()) {
                if (!this.battery_.draw(energy_consumption * 20)) {
                    this.battery_.clear();
                }
                this.progress_ = Mth.m_14045_((int)(this.progress_ + heatup_rate), (int)0, (int)100);
            }
            int new_phase = this.phase();
            if (this.accepts_lava_container(istack)) {
                if (istack.m_41656_(BUCKET_STACK)) {
                    if (!this.main_inventory_.m_8020_(1).m_41656_(LAVA_BUCKET_STACK)) {
                        if (this.bucket_extraction_possible()) {
                            this.reset_process();
                            this.main_inventory_.m_6836_(1, LAVA_BUCKET_STACK);
                            this.f_58857_.m_5594_(null, this.f_58858_, SoundEvents.f_11783_, SoundSource.BLOCKS, 0.2f, 1.3f);
                        } else {
                            this.main_inventory_.m_6836_(1, istack.m_41777_());
                        }
                        dirty = true;
                    }
                } else {
                    this.main_inventory_.m_6836_(1, istack.m_41777_());
                }
            } else if (new_phase > last_phase) {
                switch (new_phase) {
                    case 3: {
                        this.tank_.fill(new FluidStack((Fluid)Fluids.f_76195_, 1000), IFluidHandler.FluidAction.EXECUTE);
                        this.main_inventory_.m_6836_(1, ItemStack.f_41583_);
                        this.main_inventory_.m_6836_(0, ItemStack.f_41583_);
                        this.f_58857_.m_5594_(null, this.f_58858_, SoundEvents.f_12030_, SoundSource.BLOCKS, 0.2f, 1.0f);
                        dirty = true;
                        break;
                    }
                    case 2: {
                        this.main_inventory_.m_6836_(1, MAGMA_STACK.m_41777_());
                        this.f_58857_.m_5594_(null, this.f_58858_, SoundEvents.f_11936_, SoundSource.BLOCKS, 0.2f, 0.8f);
                        dirty = true;
                        break;
                    }
                    case 1: {
                        this.f_58857_.m_5594_(null, this.f_58858_, SoundEvents.f_11936_, SoundSource.BLOCKS, 0.2f, 0.8f);
                    }
                }
            } else if (new_phase < last_phase) {
                switch (new_phase) {
                    case 2: {
                        if (this.tank_.getFluidAmount() < 900) {
                            this.reset_process();
                        } else {
                            this.main_inventory_.m_6836_(0, MAGMA_STACK.m_41777_());
                            this.main_inventory_.m_6836_(1, MAGMA_STACK.m_41777_());
                            this.tank_.drain(1000);
                        }
                        this.f_58857_.m_5594_(null, this.f_58858_, SoundEvents.f_12031_, SoundSource.BLOCKS, 0.5f, 1.1f);
                        dirty = true;
                        break;
                    }
                    case 1: {
                        if (istack.m_41656_(MAGMA_STACK)) {
                            this.main_inventory_.m_6836_(1, new ItemStack((ItemLike)Blocks.f_50080_));
                        } else {
                            this.main_inventory_.m_6836_(1, new ItemStack((ItemLike)Blocks.f_50652_));
                        }
                        this.f_58857_.m_5594_(null, this.f_58858_, SoundEvents.f_12031_, SoundSource.BLOCKS, 0.3f, 0.9f);
                        dirty = true;
                        break;
                    }
                    case 0: {
                        this.f_58857_.m_5594_(null, this.f_58858_, SoundEvents.f_12031_, SoundSource.BLOCKS, 0.3f, 0.7f);
                    }
                }
            } else if (this.phase() >= 3) {
                if (this.tank_.getFluidAmount() <= 0) {
                    this.reset_process();
                    this.f_58857_.m_5594_(null, this.f_58858_, SoundEvents.f_12031_, SoundSource.BLOCKS, 0.3f, 0.7f);
                } else {
                    int n;
                    FluidStack fs = this.tank_.getFluid().copy();
                    if (fs.getAmount() > 100) {
                        fs.setAmount(100);
                    }
                    if ((n = Fluidics.fill(this.f_58857_, this.m_58899_().m_7495_(), Direction.UP, fs)) > 0) {
                        this.tank_.drain(n);
                        if (this.tank_.isEmpty()) {
                            ItemStack prev = this.main_inventory_.m_8020_(0);
                            this.reset_process();
                            this.main_inventory_.m_6836_(0, prev);
                            this.f_58857_.m_5594_(null, this.f_58858_, SoundEvents.f_12031_, SoundSource.BLOCKS, 0.3f, 0.7f);
                        }
                    }
                }
            }
            if (this.force_block_update_ || (Integer)state.m_61143_((Property)MineralSmelterBlock.PHASE) != new_phase) {
                state = (BlockState)state.m_61124_((Property)MineralSmelterBlock.PHASE, (Comparable)Integer.valueOf(new_phase));
                this.f_58857_.m_7731_(this.f_58858_, state, 19);
                this.f_58857_.m_46672_(this.m_58899_(), state.m_60734_());
                this.force_block_update_ = false;
            }
            if (dirty) {
                this.m_6596_();
            }
        }

        static {
            accepted_lava_contrainers.add(Items.f_42446_);
        }
    }

    public static class MineralSmelterBlock
    extends StandardBlocks.Horizontal
    implements StandardEntityBlocks.IStandardEntityBlock<MineralSmelterTileEntity> {
        public static final int PHASE_MAX = 3;
        public static final IntegerProperty PHASE = IntegerProperty.m_61631_((String)"phase", (int)0, (int)3);

        public MineralSmelterBlock(long config, BlockBehaviour.Properties builder, AABB unrotatedAABB) {
            super(config, builder, unrotatedAABB);
        }

        @Override
        public boolean isBlockEntityTicking(Level world, BlockState state) {
            return true;
        }

        @Override
        public VoxelShape m_5939_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext selectionContext) {
            return Shapes.m_83144_();
        }

        @Override
        protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
            super.m_7926_(builder);
            builder.m_61104_(new Property[]{PHASE});
        }

        @Override
        @Nullable
        public BlockState m_5573_(BlockPlaceContext context) {
            return (BlockState)super.m_5573_(context).m_61124_((Property)PHASE, (Comparable)Integer.valueOf(0));
        }

        public boolean m_7278_(BlockState state) {
            return true;
        }

        public int m_6782_(BlockState state, Level world, BlockPos pos) {
            return Mth.m_14045_((int)((Integer)state.m_61143_((Property)PHASE) * 5), (int)0, (int)15);
        }

        public boolean shouldCheckWeakPower(BlockState state, LevelReader world, BlockPos pos, Direction side) {
            return false;
        }

        public void m_6402_(Level world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        }

        @Override
        public boolean hasDynamicDropList() {
            return true;
        }

        @Override
        public List<ItemStack> dropList(BlockState state, Level world, BlockEntity te, boolean explosion) {
            ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
            if (world.f_46443_) {
                return stacks;
            }
            if (!(te instanceof MineralSmelterTileEntity)) {
                return stacks;
            }
            ((MineralSmelterTileEntity)te).reset_process();
            stacks.add(new ItemStack((ItemLike)this, 1));
            return stacks;
        }

        public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult rayTraceResult) {
            if (player.m_6144_()) {
                return InteractionResult.PASS;
            }
            if (world.m_5776_()) {
                return InteractionResult.SUCCESS;
            }
            MineralSmelterTileEntity te = this.getTe(world, pos);
            if (te == null) {
                return InteractionResult.FAIL;
            }
            ItemStack stack = player.m_21120_(hand);
            boolean dirty = false;
            if (te.accepts_lava_container(stack)) {
                if (stack.m_41726_(MineralSmelterTileEntity.BUCKET_STACK) && te.bucket_extraction_possible()) {
                    if (stack.m_41613_() > 1) {
                        int target_stack_index = -1;
                        for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
                            if (!player.m_150109_().m_8020_(i).m_41619_()) continue;
                            target_stack_index = i;
                            break;
                        }
                        if (target_stack_index >= 0) {
                            te.reset_process();
                            stack.m_41774_(1);
                            player.m_21008_(hand, stack);
                            player.m_150109_().m_6836_(target_stack_index, MineralSmelterTileEntity.LAVA_BUCKET_STACK.m_41777_());
                            world.m_5594_(null, pos, SoundEvents.f_11783_, SoundSource.BLOCKS, 1.0f, 1.0f);
                            dirty = true;
                        }
                    } else {
                        te.reset_process();
                        player.m_21008_(hand, MineralSmelterTileEntity.LAVA_BUCKET_STACK.m_41777_());
                        world.m_5594_(null, pos, SoundEvents.f_11783_, SoundSource.BLOCKS, 1.0f, 1.0f);
                        dirty = true;
                    }
                }
            } else if (stack.m_41619_()) {
                ItemStack istack = te.extract(true);
                if (te.phase() > 0) {
                    player.m_20254_(1);
                }
                if (!istack.m_41619_()) {
                    player.m_21008_(hand, te.extract(false));
                    dirty = true;
                }
            } else if (te.insert(stack, false)) {
                stack.m_41774_(1);
                dirty = true;
            }
            if (dirty) {
                player.m_150109_().m_6596_();
            }
            return InteractionResult.CONSUME;
        }

        @OnlyIn(value=Dist.CLIENT)
        public void m_214162_(BlockState state, Level world, BlockPos pos, RandomSource rnd) {
            if (state.m_60734_() != this) {
                return;
            }
            SimpleParticleType particle = ParticleTypes.f_123762_;
            switch ((Integer)state.m_61143_((Property)PHASE)) {
                case 0: {
                    return;
                }
                case 1: {
                    if (rnd.m_188503_(10) <= 4) break;
                    return;
                }
                case 2: {
                    if (rnd.m_188503_(10) > 7) {
                        return;
                    }
                    particle = ParticleTypes.f_123755_;
                    break;
                }
                case 3: {
                    if (rnd.m_188503_(10) > 2) {
                        return;
                    }
                    particle = ParticleTypes.f_123756_;
                    break;
                }
                default: {
                    return;
                }
            }
            double x = 0.5 + (double)pos.m_123341_();
            double y = 0.5 + (double)pos.m_123342_();
            double z = 0.5 + (double)pos.m_123343_();
            double xr = rnd.m_188500_() * 0.4 - 0.2;
            double yr = rnd.m_188500_() * 0.5;
            double zr = rnd.m_188500_() * 0.4 - 0.2;
            world.m_7106_((ParticleOptions)particle, x + xr, y + yr, z + zr, 0.0, 0.0, 0.0);
        }

        @Nullable
        private MineralSmelterTileEntity getTe(Level world, BlockPos pos) {
            BlockEntity te = world.m_7702_(pos);
            return !(te instanceof MineralSmelterTileEntity) ? null : (MineralSmelterTileEntity)te;
        }
    }
}

