/*
 * Decompiled with CFR 0.152.
 */
package wile.engineersdecor.detail;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.VineBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.registries.ForgeRegistries;
import wile.engineersdecor.libmc.Auxiliaries;

public class TreeCutting {
    private static final Set<Block> universal_logs_ = new HashSet<Block>();
    private static final List<Vec3i> hoffsets = ImmutableList.of((Object)new Vec3i(1, 0, 0), (Object)new Vec3i(1, 0, 1), (Object)new Vec3i(0, 0, 1), (Object)new Vec3i(-1, 0, 1), (Object)new Vec3i(-1, 0, 0), (Object)new Vec3i(-1, 0, -1), (Object)new Vec3i(0, 0, -1), (Object)new Vec3i(1, 0, -1));

    public static void on_config(List<String> universal_logs) {
        universal_logs_.clear();
        if (universal_logs.isEmpty()) {
            return;
        }
        try {
            universal_logs.forEach(rls -> {
                ResourceLocation rl = ResourceLocation.m_135820_((String)rls);
                if (rl == null || !ForgeRegistries.BLOCKS.containsKey(rl)) {
                    return;
                }
                universal_logs_.add((Block)ForgeRegistries.BLOCKS.getValue(rl));
            });
        }
        catch (Throwable ex) {
            Auxiliaries.logError("Unexpected exception parsing universal log blocks: " + ex.getMessage());
        }
        if (!universal_logs_.isEmpty()) {
            Auxiliaries.logger().info("Tree cutting: Universal logs:" + universal_logs_.stream().map(Block::toString).collect(Collectors.joining()) + ".");
        }
    }

    public static boolean canChop(Level world, BlockState state, BlockPos pos) {
        return TreeCutting.isLog(state) || universal_logs_.contains(state.m_60734_()) && TreeCutting.isLog(world.m_8055_(pos.m_7494_()));
    }

    private static boolean isLog(BlockState state) {
        return state.m_204336_(BlockTags.f_13106_);
    }

    private static boolean isSameLog(BlockState a, BlockState b) {
        Block bb;
        Block ba = a.m_60734_();
        return ba == (bb = b.m_60734_()) || universal_logs_.contains(ba) && TreeCutting.isLog(b) || universal_logs_.contains(bb) && TreeCutting.isLog(a) || universal_logs_.contains(ba) && universal_logs_.contains(bb);
    }

    private static boolean isLeaves(BlockState state) {
        if (state.m_60734_() instanceof LeavesBlock) {
            return true;
        }
        return state.m_204336_(BlockTags.f_13035_);
    }

    private static List<BlockPos> findBlocksAround(Level world, BlockPos centerPos, BlockState leaf_type_state, Set<BlockPos> checked, int recursion_left) {
        ArrayList<BlockPos> to_decay = new ArrayList<BlockPos>();
        for (int y = -1; y <= 1; ++y) {
            BlockPos layer = centerPos.m_7918_(0, y, 0);
            for (Vec3i v : hoffsets) {
                BlockPos pos = layer.m_121955_(v);
                if (checked.contains(pos) || world.m_8055_(pos).m_60734_() != leaf_type_state.m_60734_()) continue;
                checked.add(pos);
                to_decay.add(pos);
                if (recursion_left <= 0) continue;
                to_decay.addAll(TreeCutting.findBlocksAround(world, pos, leaf_type_state, checked, recursion_left - 1));
            }
        }
        return to_decay;
    }

    private static void breakBlock(Level world, BlockPos pos) {
        Block.m_49950_((BlockState)world.m_8055_(pos), (Level)world, (BlockPos)pos);
        world.m_7731_(pos, world.m_6425_(pos).m_76188_(), 11);
    }

    public static int chopTree(Level world, BlockState broken_state, BlockPos startPos, int max_blocks_to_break, boolean without_target_block) {
        if (world.f_46443_) {
            return 0;
        }
        if (universal_logs_.contains(broken_state.m_60734_())) {
            broken_state = world.m_8055_(startPos.m_7494_());
        }
        if (!TreeCutting.isLog(broken_state)) {
            return 0;
        }
        long ymin = startPos.m_123342_();
        long max_leaf_distance = 8L;
        HashSet<BlockPos> checked = new HashSet<BlockPos>();
        ArrayList<BlockPos> to_break = new ArrayList<BlockPos>();
        ArrayList<BlockPos> to_decay = new ArrayList<BlockPos>();
        checked.add(startPos);
        LinkedList<BlockPos> queue = new LinkedList<BlockPos>();
        LinkedList<BlockPos> upqueue = new LinkedList<BlockPos>();
        queue.add(startPos);
        int cutlevel = 0;
        int steps_left = 128;
        while (!queue.isEmpty() && --steps_left >= 0) {
            BlockPos pos = (BlockPos)queue.removeFirst();
            BlockPos uppos = pos.m_7494_();
            BlockState upstate = world.m_8055_(uppos);
            if (!checked.contains(uppos)) {
                checked.add(uppos);
                if (TreeCutting.isSameLog(upstate, broken_state)) {
                    upqueue.add(uppos);
                    to_break.add(uppos);
                    steps_left = 128;
                } else {
                    boolean isleaf = TreeCutting.isLeaves(upstate);
                    if (isleaf || world.m_46859_(uppos) || upstate.m_60734_() instanceof VineBlock) {
                        if (isleaf) {
                            to_decay.add(uppos);
                        }
                        for (Vec3i v : hoffsets) {
                            BlockPos p = uppos.m_121955_(v);
                            if (checked.contains(p)) continue;
                            checked.add(p);
                            BlockState st = world.m_8055_(p);
                            Block bl = st.m_60734_();
                            if (TreeCutting.isSameLog(st, broken_state)) {
                                queue.add(p);
                                to_break.add(p);
                                continue;
                            }
                            if (!TreeCutting.isLeaves(st)) continue;
                            to_decay.add(p);
                        }
                    }
                }
            }
            for (Vec3i v : hoffsets) {
                BlockPos p = pos.m_121955_(v);
                if (checked.contains(p)) continue;
                checked.add(p);
                if (p.m_123331_((Vec3i)new BlockPos(startPos.m_123341_(), p.m_123342_(), startPos.m_123343_())) > (double)(cutlevel > 2 ? 256 : 9)) continue;
                BlockState st = world.m_8055_(p);
                Block bl = st.m_60734_();
                if (TreeCutting.isSameLog(st, broken_state)) {
                    queue.add(p);
                    to_break.add(p);
                    continue;
                }
                if (!TreeCutting.isLeaves(st)) continue;
                queue.add(p);
                to_decay.add(p);
            }
            if (!queue.isEmpty() || upqueue.isEmpty()) continue;
            queue = upqueue;
            upqueue = new LinkedList();
            ++cutlevel;
        }
        for (BlockPos pos : to_decay) {
            int dist = 1;
            to_break.addAll(TreeCutting.findBlocksAround(world, pos, broken_state, checked, dist));
        }
        if (!to_decay.isEmpty()) {
            BlockState leaf_type_state = world.m_8055_((BlockPos)to_decay.get(0));
            ArrayList<BlockPos> leafs = to_decay;
            to_decay = new ArrayList();
            for (BlockPos pos : leafs) {
                int dist = 3;
                to_decay.add(pos);
                to_decay.addAll(TreeCutting.findBlocksAround(world, pos, leaf_type_state, checked, dist));
            }
        }
        if (without_target_block) {
            checked.remove(startPos);
        } else {
            to_break.add(startPos);
        }
        for (BlockPos pos : to_break) {
            TreeCutting.breakBlock(world, pos);
        }
        for (BlockPos pos : to_decay) {
            TreeCutting.breakBlock(world, pos);
        }
        return Mth.m_14045_((int)(to_break.size() * 6 / 5 + to_decay.size() / 10 - 1), (int)1, (int)65535);
    }
}

