/*
 * Decompiled with CFR 0.152.
 */
package wile.engineersdecor.blocks;

import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFurnace;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.fluid.IFluidState;
import net.minecraft.init.Items;
import net.minecraft.init.Particles;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.inventory.Slot;
import net.minecraft.inventory.SlotFurnaceFuel;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipe;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.INBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.particles.IParticleData;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.stats.StatList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IInteractionObject;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.crafting.VanillaRecipeTypes;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.hooks.BasicEventHooks;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;
import wile.engineersdecor.ModEngineersDecor;
import wile.engineersdecor.blocks.BlockDecorDirected;
import wile.engineersdecor.blocks.ModBlocks;
import wile.engineersdecor.detail.ExtItems;

public class BlockDecorFurnace
extends BlockDecorDirected {
    public static final BooleanProperty LIT = BlockFurnace.field_196325_b;

    public BlockDecorFurnace(long config, Block.Properties builder, AxisAlignedBB unrotatedAABB) {
        super(config, builder, unrotatedAABB);
        this.func_180632_j((IBlockState)((IBlockState)((IBlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)FACING, (Comparable)EnumFacing.NORTH)).func_206870_a((IProperty)LIT, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, IBlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new IProperty[]{LIT});
    }

    @Override
    public int func_149750_m(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)LIT) != false ? super.func_149750_m(state) : 0;
    }

    public void func_196243_a(IBlockState state, World world, BlockPos pos, IBlockState newState, boolean isMoving) {
        if (state.func_177230_c() == newState.func_177230_c()) {
            return;
        }
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof BTileEntity) {
            InventoryHelper.func_180175_a((World)world, (BlockPos)pos, (IInventory)((BTileEntity)te));
            world.func_175666_e(pos, (Block)this);
        }
        super.func_196243_a(state, world, pos, newState, isMoving);
    }

    @Override
    @Nullable
    public IBlockState func_196258_a(BlockItemUseContext context) {
        return (IBlockState)((IBlockState)this.func_176223_P().func_206870_a((IProperty)FACING, (Comparable)context.func_195992_f().func_176734_d())).func_206870_a((IProperty)LIT, (Comparable)Boolean.valueOf(false));
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    public int func_180641_l(IBlockState blockState, World world, BlockPos pos) {
        return Container.func_178144_a((TileEntity)world.func_175625_s(pos));
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(IBlockState state, IBlockReader world) {
        return new BTileEntity();
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        world.func_175656_a(pos, (IBlockState)state.func_206870_a((IProperty)LIT, (Comparable)Boolean.valueOf(false)));
        if (world.field_72995_K) {
            return;
        }
        if (!stack.func_77942_o() || !stack.func_77978_p().func_74764_b("inventory")) {
            return;
        }
        NBTTagCompound inventory_nbt = stack.func_77978_p().func_74775_l("inventory");
        if (inventory_nbt.isEmpty()) {
            return;
        }
        TileEntity te = world.func_175625_s(pos);
        if (!(te instanceof BTileEntity)) {
            return;
        }
        BTileEntity bte = (BTileEntity)te;
        bte.readnbt(inventory_nbt);
        bte.func_70296_d();
        world.func_175656_a(pos, (IBlockState)state.func_206870_a((IProperty)LIT, (Comparable)Boolean.valueOf(bte.isBurning())));
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest, IFluidState fluid) {
        if (world.field_72995_K) {
            return true;
        }
        TileEntity te = world.func_175625_s(pos);
        if (!(te instanceof BTileEntity)) {
            return super.removedByPlayer(state, world, pos, player, willHarvest, fluid);
        }
        ItemStack stack = new ItemStack((IItemProvider)this, 1);
        NBTTagCompound inventory_nbt = ((BTileEntity)te).reset_getnbt();
        if (!inventory_nbt.isEmpty()) {
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74782_a("inventory", (INBTBase)inventory_nbt);
            stack.func_77982_d(nbt);
        }
        world.func_175713_t(pos);
        world.func_175655_b(pos, false);
        world.func_72838_d((Entity)new EntityItem(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, stack));
        return false;
    }

    public void func_180652_a(World world, BlockPos pos, Explosion explosion) {
        if (world.field_72995_K) {
            return;
        }
        TileEntity te = world.func_175625_s(pos);
        if (!(te instanceof BTileEntity)) {
            return;
        }
        for (ItemStack stack : ((BTileEntity)te).stacks_) {
            if (stack.func_190926_b()) continue;
            world.func_72838_d((Entity)new EntityItem(world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), stack));
        }
        ((BTileEntity)te).reset();
        super.func_180652_a(world, pos, explosion);
    }

    public boolean func_196250_a(IBlockState state, World world, BlockPos pos, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return true;
        }
        TileEntity te = world.func_175625_s(pos);
        if (!(te instanceof BTileEntity)) {
            return true;
        }
        if (!(player instanceof EntityPlayerMP) && !(player instanceof FakePlayer)) {
            return true;
        }
        NetworkHooks.openGui((EntityPlayerMP)((EntityPlayerMP)player), (IInteractionObject)new BInteraction(world, pos, (BTileEntity)te), buf -> buf.func_179255_a(pos));
        player.func_195066_a(StatList.field_188061_aa);
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rnd) {
        if (state.func_177230_c() != this || !((Boolean)state.func_177229_b((IProperty)LIT)).booleanValue()) {
            return;
        }
        double rv = rnd.nextDouble();
        if (rv > 0.5) {
            return;
        }
        double x = 0.5 + (double)pos.func_177958_n();
        double y = 0.5 + (double)pos.func_177956_o();
        double z = 0.5 + (double)pos.func_177952_p();
        double xc = 0.52;
        double xr = rnd.nextDouble() * 0.4 - 0.2;
        double yr = y - 0.3 + rnd.nextDouble() * 0.2;
        if (rv < 0.1) {
            world.func_184134_a(x, y, z, SoundEvents.field_187652_bv, SoundCategory.BLOCKS, 0.4f, 0.5f, false);
        }
        switch ((EnumFacing)state.func_177229_b((IProperty)FACING)) {
            case WEST: {
                world.func_195594_a((IParticleData)Particles.field_197601_L, x - 0.52, yr, z + xr, 0.0, 0.0, 0.0);
                break;
            }
            case EAST: {
                world.func_195594_a((IParticleData)Particles.field_197601_L, x + 0.52, yr, z + xr, 0.0, 0.0, 0.0);
                break;
            }
            case NORTH: {
                world.func_195594_a((IParticleData)Particles.field_197601_L, x + xr, yr, z - 0.52, 0.0, 0.0, 0.0);
                break;
            }
            default: {
                world.func_195594_a((IParticleData)Particles.field_197601_L, x + xr, yr, z + 0.52, 0.0, 0.0, 0.0);
            }
        }
    }

    public static class BTileEntity
    extends TileEntity
    implements ITickable,
    ISidedInventory,
    IEnergyStorage {
        public static final int TICK_INTERVAL = 4;
        public static final int FIFO_INTERVAL = 20;
        public static final int MAX_BURNTIME = Short.MAX_VALUE;
        public static final int DEFAULT_BOOST_ENERGY = 32;
        public static final int VANILLA_FURNACE_SPEED_INTERVAL = 200;
        public static final int DEFAULT_SPEED_INTERVAL = 150;
        public static final int NUM_OF_SLOTS = 11;
        public static final int SMELTING_INPUT_SLOT_NO = 0;
        public static final int SMELTING_FUEL_SLOT_NO = 1;
        public static final int SMELTING_OUTPUT_SLOT_NO = 2;
        public static final int FIFO_INPUT_0_SLOT_NO = 3;
        public static final int FIFO_INPUT_1_SLOT_NO = 4;
        public static final int FIFO_FUEL_0_SLOT_NO = 5;
        public static final int FIFO_FUEL_1_SLOT_NO = 6;
        public static final int FIFO_OUTPUT_0_SLOT_NO = 7;
        public static final int FIFO_OUTPUT_1_SLOT_NO = 8;
        public static final int AUX_0_SLOT_NO = 9;
        public static final int AUX_1_SLOT_NO = 10;
        private static final int[] SLOTS_TOP = new int[]{4};
        private static final int[] SLOTS_BOTTOM = new int[]{8};
        private static final int[] SLOTS_SIDES = new int[]{6};
        private static double proc_fuel_efficiency_ = 1.0;
        private static int proc_speed_interval_ = 150;
        private static int boost_energy_consumption = 128;
        private int tick_timer_;
        private int fifo_timer_;
        private int burntime_left_;
        private int fuel_burntime_;
        private int proc_time_elapsed_;
        private int proc_time_needed_;
        private int boost_energy_;
        private boolean heater_inserted_ = false;
        protected NonNullList<ItemStack> stacks_;
        @Nullable
        private IRecipe current_recipe_ = null;
        private final Map<Item, IRecipe> recent_recipes_ = new HashMap<Item, IRecipe>();
        LazyOptional<? extends IItemHandler>[] item_handlers = SidedInvWrapper.create((ISidedInventory)this, (EnumFacing[])new EnumFacing[]{EnumFacing.UP, EnumFacing.DOWN, EnumFacing.NORTH});
        protected LazyOptional<IEnergyStorage> energy_handler_ = LazyOptional.of(() -> this);

        public static void on_config(int speed_percent, int fuel_efficiency_percent, int boost_energy_per_tick) {
            double ratio = 100.0 / (double)MathHelper.func_76125_a((int)speed_percent, (int)10, (int)500);
            proc_speed_interval_ = MathHelper.func_76125_a((int)((int)(ratio * 200.0)), (int)20, (int)400);
            proc_fuel_efficiency_ = (double)MathHelper.func_76125_a((int)fuel_efficiency_percent, (int)10, (int)500) / 100.0;
            boost_energy_consumption = 4 * MathHelper.func_76125_a((int)boost_energy_per_tick, (int)16, (int)512);
            ModEngineersDecor.logger().info("Config lab furnace interval:" + proc_speed_interval_ + ", efficiency:" + proc_fuel_efficiency_);
        }

        public BTileEntity() {
            this(ModBlocks.TET_SMALL_LAB_FURNACE);
        }

        public BTileEntity(TileEntityType<?> te_type) {
            super(te_type);
            this.reset();
        }

        public NBTTagCompound reset_getnbt() {
            NBTTagCompound nbt = new NBTTagCompound();
            this.writenbt(nbt);
            this.reset();
            return nbt;
        }

        public void reset() {
            this.stacks_ = NonNullList.func_191197_a((int)11, (Object)ItemStack.field_190927_a);
            this.proc_time_elapsed_ = 0;
            this.proc_time_needed_ = 0;
            this.burntime_left_ = 0;
            this.fuel_burntime_ = 0;
            this.fifo_timer_ = 0;
            this.tick_timer_ = 0;
            this.current_recipe_ = null;
        }

        @Nullable
        protected IRecipe currentRecipe() {
            return this.current_recipe_;
        }

        public void readnbt(NBTTagCompound nbt) {
            ItemStackHelper.func_191283_b((NBTTagCompound)nbt, this.stacks_);
            while (this.stacks_.size() < 11) {
                this.stacks_.add((Object)ItemStack.field_190927_a);
            }
            this.burntime_left_ = nbt.func_74762_e("BurnTime");
            this.proc_time_elapsed_ = nbt.func_74762_e("CookTime");
            this.proc_time_needed_ = nbt.func_74762_e("CookTimeTotal");
            this.fuel_burntime_ = BTileEntity.getItemBurnTime((ItemStack)this.stacks_.get(1));
            try {
                String recipe_id;
                NBTTagCompound rr = nbt.func_74775_l("Recipes");
                for (int i = 0; i < rr.func_186856_d() && !(recipe_id = rr.func_74779_i(Integer.toString(i))).isEmpty(); ++i) {
                    IRecipe r = this.field_145850_b.func_199532_z().func_199517_a(new ResourceLocation(recipe_id));
                    if (r == null) continue;
                    this.recent_recipes_.putIfAbsent(r.func_77571_b().func_77973_b(), r);
                }
            }
            catch (Throwable e) {
                ModEngineersDecor.logger().error("Failed to read recent recipes in lab furnace NBT");
            }
        }

        private void writenbt(NBTTagCompound nbt) {
            nbt.func_74768_a("BurnTime", MathHelper.func_76125_a((int)this.burntime_left_, (int)0, (int)Short.MAX_VALUE));
            nbt.func_74768_a("CookTime", MathHelper.func_76125_a((int)this.proc_time_elapsed_, (int)0, (int)Short.MAX_VALUE));
            nbt.func_74768_a("CookTimeTotal", MathHelper.func_76125_a((int)this.proc_time_needed_, (int)0, (int)Short.MAX_VALUE));
            ItemStackHelper.func_191282_a((NBTTagCompound)nbt, this.stacks_);
            try {
                NBTTagCompound rr = new NBTTagCompound();
                int i = -1;
                for (IRecipe r : this.recent_recipes_.values()) {
                    rr.func_74778_a(Integer.toString(++i), r.func_199560_c().toString());
                }
                nbt.func_74782_a("Recipes", (INBTBase)rr);
            }
            catch (Throwable e) {
                ModEngineersDecor.logger().error("Failed to write recent recipes in lab furnace NBT");
            }
        }

        public void func_145839_a(NBTTagCompound nbt) {
            super.func_145839_a(nbt);
            this.readnbt(nbt);
        }

        public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
            super.func_189515_b(nbt);
            this.writenbt(nbt);
            return nbt;
        }

        public ITextComponent func_200200_C_() {
            Block block = this.func_195044_w().func_177230_c();
            return block != null ? block.func_200291_n() : new TextComponentString("Lab furnace");
        }

        public boolean func_145818_k_() {
            return false;
        }

        public ITextComponent func_200201_e() {
            return this.func_200200_C_();
        }

        public int func_70302_i_() {
            return this.stacks_.size();
        }

        public boolean func_191420_l() {
            for (ItemStack stack : this.stacks_) {
                if (stack.func_190926_b()) continue;
                return false;
            }
            return true;
        }

        public ItemStack func_70301_a(int index) {
            return index < this.func_70302_i_() ? (ItemStack)this.stacks_.get(index) : ItemStack.field_190927_a;
        }

        public ItemStack func_70298_a(int index, int count) {
            return ItemStackHelper.func_188382_a(this.stacks_, (int)index, (int)count);
        }

        public ItemStack func_70304_b(int index) {
            return ItemStackHelper.func_188383_a(this.stacks_, (int)index);
        }

        public void func_70299_a(int index, ItemStack stack) {
            ItemStack slot_stack = (ItemStack)this.stacks_.get(index);
            boolean already_in_slot = !stack.func_190926_b() && stack.func_77969_a(slot_stack) && ItemStack.func_77970_a((ItemStack)stack, (ItemStack)slot_stack);
            this.stacks_.set(index, (Object)stack);
            if (stack.func_190916_E() > this.func_70297_j_()) {
                stack.func_190920_e(this.func_70297_j_());
            }
            if (index == 0 && !already_in_slot) {
                this.proc_time_needed_ = this.getCookTime(stack);
                this.proc_time_elapsed_ = 0;
                this.func_70296_d();
            }
        }

        public int func_70297_j_() {
            return 64;
        }

        public void func_70296_d() {
            super.func_70296_d();
        }

        public boolean func_70300_a(EntityPlayer player) {
            return this.field_145850_b.func_175625_s(this.field_174879_c) == this && player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
        }

        public void func_174889_b(EntityPlayer player) {
        }

        public void func_174886_c(EntityPlayer player) {
            this.func_70296_d();
        }

        public boolean func_94041_b(int index, ItemStack stack) {
            switch (index) {
                case 2: 
                case 7: 
                case 8: {
                    return false;
                }
                case 0: 
                case 3: 
                case 4: {
                    return true;
                }
                case 9: 
                case 10: {
                    return true;
                }
            }
            ItemStack slot_stack = (ItemStack)this.stacks_.get(6);
            return BTileEntity.isItemFuel(stack) || SlotFurnaceFuel.func_178173_c_((ItemStack)stack) && slot_stack.func_77973_b() != Items.field_151133_ar;
        }

        public int func_174887_a_(int id) {
            switch (id) {
                case 0: {
                    return this.burntime_left_;
                }
                case 1: {
                    return this.fuel_burntime_;
                }
                case 2: {
                    return this.proc_time_elapsed_;
                }
                case 3: {
                    return this.proc_time_needed_;
                }
            }
            return 0;
        }

        public void func_174885_b(int id, int value) {
            switch (id) {
                case 0: {
                    this.burntime_left_ = value;
                    break;
                }
                case 1: {
                    this.fuel_burntime_ = value;
                    break;
                }
                case 2: {
                    this.proc_time_elapsed_ = value;
                    break;
                }
                case 3: {
                    this.proc_time_needed_ = value;
                }
            }
        }

        public int func_174890_g() {
            return 4;
        }

        public void func_174888_l() {
            this.stacks_.clear();
        }

        public int[] func_180463_a(EnumFacing side) {
            if (side == EnumFacing.DOWN) {
                return SLOTS_BOTTOM;
            }
            if (side == EnumFacing.UP) {
                return SLOTS_TOP;
            }
            return SLOTS_SIDES;
        }

        public boolean func_180462_a(int index, ItemStack itemStackIn, EnumFacing direction) {
            return this.func_94041_b(index, itemStackIn);
        }

        public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
            if (direction != EnumFacing.DOWN || index != 1 && index != 5 && index != 6) {
                return true;
            }
            return stack.func_77973_b() == Items.field_151133_ar;
        }

        public boolean canExtract() {
            return false;
        }

        public boolean canReceive() {
            return true;
        }

        public int getMaxEnergyStored() {
            return boost_energy_consumption;
        }

        public int getEnergyStored() {
            return this.boost_energy_;
        }

        public int extractEnergy(int maxExtract, boolean simulate) {
            return 0;
        }

        public int receiveEnergy(int maxReceive, boolean simulate) {
            if (this.boost_energy_ >= boost_energy_consumption || maxReceive < boost_energy_consumption) {
                return 0;
            }
            if (!simulate) {
                this.boost_energy_ = boost_energy_consumption;
            }
            return boost_energy_consumption;
        }

        public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
            if (!this.field_145846_f && facing != null) {
                if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
                    if (facing == EnumFacing.UP) {
                        return this.item_handlers[0].cast();
                    }
                    if (facing == EnumFacing.DOWN) {
                        return this.item_handlers[1].cast();
                    }
                    return this.item_handlers[2].cast();
                }
                if (capability == CapabilityEnergy.ENERGY) {
                    return this.energy_handler_.cast();
                }
            }
            return super.getCapability(capability, facing);
        }

        public boolean isBurning() {
            return this.burntime_left_ > 0;
        }

        @OnlyIn(value=Dist.CLIENT)
        public static boolean isBurning(IInventory inventory) {
            return inventory.func_174887_a_(0) > 0;
        }

        public int getCookTime(ItemStack stack) {
            return proc_speed_interval_ < 10 ? 10 : proc_speed_interval_;
        }

        private boolean transferItems(int index_from, int index_to, int count) {
            ItemStack from = (ItemStack)this.stacks_.get(index_from);
            if (from.func_190926_b()) {
                return false;
            }
            ItemStack to = (ItemStack)this.stacks_.get(index_to);
            if (from.func_190916_E() < count) {
                count = from.func_190916_E();
            }
            if (count <= 0) {
                return false;
            }
            boolean changed = true;
            if (to.func_190926_b()) {
                this.stacks_.set(index_to, (Object)from.func_77979_a(count));
            } else if (to.func_190916_E() >= to.func_77976_d()) {
                changed = false;
            } else if (!from.func_77969_a(to) || !ItemStack.func_77970_a((ItemStack)from, (ItemStack)to)) {
                changed = false;
            } else if (to.func_190916_E() + count >= to.func_77976_d()) {
                from.func_190918_g(to.func_77976_d() - to.func_190916_E());
                to.func_190920_e(to.func_77976_d());
            } else {
                from.func_190918_g(count);
                to.func_190917_f(count);
            }
            if (from.func_190926_b() && from != ItemStack.field_190927_a) {
                this.stacks_.set(index_from, (Object)ItemStack.field_190927_a);
                changed = true;
            }
            return changed;
        }

        protected boolean canSmelt() {
            if (this.currentRecipe() == null || ((ItemStack)this.stacks_.get(0)).func_190926_b()) {
                return false;
            }
            ItemStack recipe_result_items = this.getSmeltingResult((ItemStack)this.stacks_.get(0));
            if (recipe_result_items.func_190926_b()) {
                return false;
            }
            ItemStack result_stack = (ItemStack)this.stacks_.get(2);
            if (result_stack.func_190926_b()) {
                return true;
            }
            if (!result_stack.func_77969_a(recipe_result_items)) {
                return false;
            }
            if (result_stack.func_190916_E() + recipe_result_items.func_190916_E() <= this.func_70297_j_() && result_stack.func_190916_E() + recipe_result_items.func_190916_E() <= result_stack.func_77976_d()) {
                return true;
            }
            return result_stack.func_190916_E() + recipe_result_items.func_190916_E() <= recipe_result_items.func_77976_d();
        }

        public void smeltItem() {
            if (!this.canSmelt()) {
                return;
            }
            ItemStack smelting_input_stack = (ItemStack)this.stacks_.get(0);
            ItemStack recipe_result_items = this.getSmeltingResult(smelting_input_stack);
            ItemStack smelting_output_stack = (ItemStack)this.stacks_.get(2);
            ItemStack fuel_stack = (ItemStack)this.stacks_.get(1);
            if (smelting_output_stack.func_190926_b()) {
                this.stacks_.set(2, (Object)recipe_result_items.func_77946_l());
            } else if (smelting_output_stack.func_77973_b() == recipe_result_items.func_77973_b()) {
                smelting_output_stack.func_190917_f(recipe_result_items.func_190916_E());
            }
            smelting_input_stack.func_190918_g(1);
        }

        public static int getItemBurnTime(ItemStack stack) {
            if (stack.func_190926_b()) {
                return 0;
            }
            Item item = stack.func_77973_b();
            int ret = stack.getBurnTime();
            return ForgeEventFactory.getItemBurnTime((ItemStack)stack, (int)(ret < 0 ? TileEntityFurnace.func_201564_p().getOrDefault(item, 0) : ret));
        }

        public static boolean isItemFuel(ItemStack stack) {
            return BTileEntity.getItemBurnTime(stack) > 0;
        }

        public float getSmeltingExperience(ItemStack stack) {
            float xp = stack.func_77973_b().getSmeltingExperience(stack);
            if (xp >= 0.0f) {
                return xp;
            }
            IRecipe recently_matched = this.recent_recipes_.getOrDefault(stack.func_77973_b(), null);
            if (!(recently_matched instanceof FurnaceRecipe)) {
                return 0.0f;
            }
            xp = ((FurnaceRecipe)recently_matched).func_201831_g();
            return xp <= 0.0f ? 0.0f : xp;
        }

        public ItemStack getSmeltingResult(ItemStack stack) {
            return this.currentRecipe() == null ? ItemStack.field_190927_a : this.currentRecipe().func_77571_b();
        }

        public boolean canBeSmelted(ItemStack stack) {
            for (IRecipe recipe : this.field_145850_b.func_199532_z().getRecipes(VanillaRecipeTypes.SMELTING)) {
                if (recipe.func_192400_c().size() != 1 || !((Ingredient)recipe.func_192400_c().get(0)).test(stack)) continue;
                return true;
            }
            return false;
        }

        protected void update_current_recipe() {
            ItemStack inp = (ItemStack)this.stacks_.get(0);
            if (inp.func_190926_b()) {
                this.current_recipe_ = null;
                return;
            }
            for (IRecipe recipe : this.field_145850_b.func_199532_z().getRecipes(VanillaRecipeTypes.SMELTING)) {
                if (recipe.func_192400_c().size() != 1 || !((Ingredient)recipe.func_192400_c().get(0)).test(inp)) continue;
                this.current_recipe_ = recipe;
                ItemStack st = recipe.func_77571_b();
                if (!st.func_190926_b()) {
                    this.recent_recipes_.putIfAbsent(st.func_77973_b(), recipe);
                }
                return;
            }
            this.current_recipe_ = null;
        }

        private void cleanup_recent_recipes() {
            if (this.recent_recipes_.isEmpty()) {
                return;
            }
            for (int i = 0; i < 9; ++i) {
                if (((ItemStack)this.stacks_.get(i)).func_190926_b()) continue;
                return;
            }
            this.recent_recipes_.clear();
        }

        public void func_73660_a() {
            if (--this.tick_timer_ > 0) {
                return;
            }
            this.tick_timer_ = 4;
            boolean was_burning = this.isBurning();
            if (was_burning) {
                this.burntime_left_ -= 4;
            }
            if (this.burntime_left_ < 0) {
                this.burntime_left_ = 0;
            }
            if (this.field_145850_b.field_72995_K) {
                return;
            }
            boolean dirty = false;
            if (--this.fifo_timer_ <= 0) {
                this.fifo_timer_ = 5;
                if (this.transferItems(7, 8, 1)) {
                    dirty = true;
                }
                if (this.transferItems(2, 7, 1)) {
                    dirty = true;
                }
                if (this.transferItems(5, 1, 1)) {
                    dirty = true;
                }
                if (this.transferItems(6, 5, 1)) {
                    dirty = true;
                }
                if (this.transferItems(3, 0, 1)) {
                    dirty = true;
                }
                if (this.transferItems(4, 3, 1)) {
                    dirty = true;
                }
                boolean bl = this.heater_inserted_ = ExtItems.IE_EXTERNAL_HEATER == null || ((ItemStack)this.stacks_.get(9)).func_77973_b() == ExtItems.IE_EXTERNAL_HEATER || ((ItemStack)this.stacks_.get(10)).func_77973_b() == ExtItems.IE_EXTERNAL_HEATER;
                if (!this.isBurning()) {
                    this.cleanup_recent_recipes();
                }
            }
            ItemStack fuel = (ItemStack)this.stacks_.get(1);
            if (this.isBurning() || !fuel.func_190926_b() && !((ItemStack)this.stacks_.get(0)).func_190926_b()) {
                this.update_current_recipe();
                if (!this.isBurning() && this.canSmelt()) {
                    this.burntime_left_ = (int)MathHelper.func_151237_a((double)(proc_fuel_efficiency_ * (double)BTileEntity.getItemBurnTime(fuel)), (double)0.0, (double)32767.0);
                    this.fuel_burntime_ = this.burntime_left_ * proc_speed_interval_ / 200;
                    if (this.isBurning()) {
                        dirty = true;
                        if (!fuel.func_190926_b()) {
                            Item fuel_item = fuel.func_77973_b();
                            fuel.func_190918_g(1);
                            if (fuel.func_190926_b()) {
                                this.stacks_.set(1, (Object)fuel_item.getContainerItem(fuel));
                            }
                        }
                    }
                }
                if (this.isBurning() && this.canSmelt()) {
                    this.proc_time_elapsed_ += 4;
                    if (this.heater_inserted_ && this.boost_energy_ >= boost_energy_consumption) {
                        this.boost_energy_ = 0;
                        this.proc_time_elapsed_ += 4;
                    }
                    if (this.proc_time_elapsed_ >= this.proc_time_needed_) {
                        this.proc_time_elapsed_ = 0;
                        this.proc_time_needed_ = this.getCookTime((ItemStack)this.stacks_.get(0));
                        this.smeltItem();
                        dirty = true;
                    }
                } else {
                    this.proc_time_elapsed_ = 0;
                }
            } else if (!this.isBurning() && this.proc_time_elapsed_ > 0) {
                this.proc_time_elapsed_ = MathHelper.func_76125_a((int)(this.proc_time_elapsed_ - 2), (int)0, (int)this.proc_time_needed_);
            }
            if (was_burning != this.isBurning()) {
                dirty = true;
                IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
                if (state.func_177230_c() instanceof BlockDecorFurnace) {
                    this.field_145850_b.func_175656_a(this.field_174879_c, (IBlockState)state.func_206870_a((IProperty)LIT, (Comparable)Boolean.valueOf(this.isBurning())));
                }
            }
            if (dirty) {
                this.func_70296_d();
            }
        }
    }

    public static class BContainer
    extends Container {
        private static final int PLAYER_INV_START_SLOTNO = 11;
        private final World world;
        private final BlockPos pos;
        private final EntityPlayer player;
        private final BTileEntity te;
        private int proc_time_elapsed_;
        private int burntime_left_;
        private int fuel_burntime_;
        private int proc_time_needed_;

        public BContainer(InventoryPlayer playerInventory, World world, BlockPos pos, BTileEntity te) {
            this.player = playerInventory.field_70458_d;
            this.world = world;
            this.pos = pos;
            this.te = te;
            this.func_75146_a(new Slot((IInventory)te, 0, 59, 17));
            this.func_75146_a((Slot)new SlotFurnaceFuel((IInventory)te, 1, 59, 53));
            this.func_75146_a(new BSlotResult(playerInventory.field_70458_d, te, 2, 101, 35));
            this.func_75146_a(new BSlotInpFifo((IInventory)te, 3, 34, 17));
            this.func_75146_a(new BSlotInpFifo((IInventory)te, 4, 16, 17));
            this.func_75146_a(new BSlotFuelFifo((IInventory)te, 5, 34, 53));
            this.func_75146_a(new BSlotFuelFifo((IInventory)te, 6, 16, 53));
            this.func_75146_a(new BSlotOutFifo(playerInventory.field_70458_d, te, 7, 126, 35));
            this.func_75146_a(new BSlotOutFifo(playerInventory.field_70458_d, te, 8, 144, 35));
            this.func_75146_a(new Slot((IInventory)te, 9, 126, 61));
            this.func_75146_a(new Slot((IInventory)te, 10, 144, 61));
            for (int x = 0; x < 9; ++x) {
                this.func_75146_a(new Slot((IInventory)playerInventory, x, 8 + x * 18, 144));
            }
            for (int y = 0; y < 3; ++y) {
                for (int x = 0; x < 9; ++x) {
                    this.func_75146_a(new Slot((IInventory)playerInventory, x + y * 9 + 9, 8 + x * 18, 86 + y * 18));
                }
            }
        }

        public void func_75132_a(IContainerListener listener) {
            super.func_75132_a(listener);
            listener.func_175173_a((Container)this, (IInventory)this.te);
        }

        public void func_75142_b() {
            super.func_75142_b();
            for (int i = 0; i < this.field_75149_d.size(); ++i) {
                IContainerListener lis = (IContainerListener)this.field_75149_d.get(i);
                if (this.proc_time_elapsed_ != this.te.func_174887_a_(2)) {
                    lis.func_71112_a((Container)this, 2, this.te.func_174887_a_(2));
                }
                if (this.burntime_left_ != this.te.func_174887_a_(0)) {
                    lis.func_71112_a((Container)this, 0, this.te.func_174887_a_(0));
                }
                if (this.fuel_burntime_ != this.te.func_174887_a_(1)) {
                    lis.func_71112_a((Container)this, 1, this.te.func_174887_a_(1));
                }
                if (this.proc_time_needed_ == this.te.func_174887_a_(3)) continue;
                lis.func_71112_a((Container)this, 3, this.te.func_174887_a_(3));
            }
            this.proc_time_elapsed_ = this.te.func_174887_a_(2);
            this.burntime_left_ = this.te.func_174887_a_(0);
            this.fuel_burntime_ = this.te.func_174887_a_(1);
            this.proc_time_needed_ = this.te.func_174887_a_(3);
        }

        @OnlyIn(value=Dist.CLIENT)
        public void func_75137_b(int id, int data) {
            this.te.func_174885_b(id, data);
        }

        public boolean func_75145_c(EntityPlayer player) {
            return this.world.func_180495_p(this.pos).func_177230_c() instanceof BlockDecorFurnace && player.func_174818_b(this.pos) <= 64.0;
        }

        public ItemStack func_82846_b(EntityPlayer player, int index) {
            Slot slot = (Slot)this.field_75151_b.get(index);
            if (slot == null || !slot.func_75216_d()) {
                return ItemStack.field_190927_a;
            }
            ItemStack slot_stack = slot.func_75211_c();
            ItemStack transferred = slot_stack.func_77946_l();
            if (index == 2 || index == 7 || index == 8) {
                if (!this.func_75135_a(slot_stack, 11, 47, true)) {
                    return ItemStack.field_190927_a;
                }
                slot.func_75220_a(slot_stack, transferred);
            } else if (index == 0 || index == 3 || index == 4) {
                if (!this.func_75135_a(slot_stack, 11, 47, false)) {
                    return ItemStack.field_190927_a;
                }
            } else if (index == 1 || index == 5 || index == 6) {
                if (!this.func_75135_a(slot_stack, 11, 47, false)) {
                    return ItemStack.field_190927_a;
                }
            } else if (index == 9 || index == 10) {
                if (!this.func_75135_a(slot_stack, 11, 47, false)) {
                    return ItemStack.field_190927_a;
                }
            } else if (index >= 11 && index <= 47) {
                if (this.te.canBeSmelted(slot_stack) ? !this.func_75135_a(slot_stack, 0, 1, false) && !this.func_75135_a(slot_stack, 3, 4, false) && !this.func_75135_a(slot_stack, 4, 5, false) : (BTileEntity.isItemFuel(slot_stack) ? !this.func_75135_a(slot_stack, 1, 2, false) && !this.func_75135_a(slot_stack, 5, 6, false) && !this.func_75135_a(slot_stack, 6, 7, false) : (index >= 11 && index < 38 ? !this.func_75135_a(slot_stack, 38, 47, false) : index >= 38 && index < 47 && !this.func_75135_a(slot_stack, 11, 38, false)))) {
                    return ItemStack.field_190927_a;
                }
            } else {
                return ItemStack.field_190927_a;
            }
            if (slot_stack.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
            if (slot_stack.func_190916_E() == transferred.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            slot.func_190901_a(player, slot_stack);
            return transferred;
        }
    }

    public static class BSlotResult
    extends Slot {
        private final EntityPlayer player;
        private final BTileEntity te;
        private int removeCount = 0;

        public BSlotResult(EntityPlayer player, BTileEntity te, int index, int xpos, int ypos) {
            super((IInventory)te, index, xpos, ypos);
            this.player = player;
            this.te = te;
        }

        public boolean func_75214_a(ItemStack stack) {
            return false;
        }

        public ItemStack func_75209_a(int amount) {
            this.removeCount += this.func_75216_d() ? Math.min(amount, this.func_75211_c().func_190916_E()) : 0;
            return super.func_75209_a(amount);
        }

        public ItemStack func_190901_a(EntityPlayer thePlayer, ItemStack stack) {
            this.func_75208_c(stack);
            super.func_190901_a(thePlayer, stack);
            return stack;
        }

        protected void func_75210_a(ItemStack stack, int amount) {
            this.removeCount += amount;
            this.func_75208_c(stack);
        }

        protected void func_75208_c(ItemStack stack) {
            stack.func_77980_a(this.player.field_70170_p, this.player, this.removeCount);
            if (!this.player.field_70170_p.field_72995_K) {
                int xp = this.removeCount;
                float sxp = this.te.getSmeltingExperience(stack);
                if (sxp == 0.0f) {
                    xp = 0;
                } else if ((double)sxp < 1.0) {
                    xp = (int)(sxp * (float)xp + (float)Math.round(Math.random() + 0.75));
                }
                while (xp > 0) {
                    int k = EntityXPOrb.func_70527_a((int)xp);
                    xp -= k;
                    this.player.field_70170_p.func_72838_d((Entity)new EntityXPOrb(this.player.field_70170_p, this.player.field_70165_t, this.player.field_70163_u + 0.5, this.player.field_70161_v + 0.5, k));
                }
            }
            this.removeCount = 0;
            BasicEventHooks.firePlayerSmeltedEvent((EntityPlayer)this.player, (ItemStack)stack);
        }
    }

    public static class BSlotOutFifo
    extends BSlotResult {
        public BSlotOutFifo(EntityPlayer player, BTileEntity te, int index, int xpos, int ypos) {
            super(player, te, index, xpos, ypos);
        }
    }

    public static class BSlotFuelFifo
    extends Slot {
        public BSlotFuelFifo(IInventory inv, int index, int xpos, int ypos) {
            super(inv, index, xpos, ypos);
        }
    }

    public static class BSlotInpFifo
    extends Slot {
        public BSlotInpFifo(IInventory inv, int index, int xpos, int ypos) {
            super(inv, index, xpos, ypos);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class BGui
    extends GuiContainer {
        private final BTileEntity te;

        public BGui(InventoryPlayer playerInventory, World world, BlockPos pos, BTileEntity te) {
            super((Container)new BContainer(playerInventory, world, pos, te));
            this.te = te;
        }

        public void func_73866_w_() {
            super.func_73866_w_();
        }

        public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
            this.func_146276_q_();
            super.func_73863_a(mouseX, mouseY, partialTicks);
            this.func_191948_b(mouseX, mouseY);
        }

        protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.field_146297_k.func_110434_K().func_110577_a(new ResourceLocation("engineersdecor", "textures/gui/small_lab_furnace_gui.png"));
            int x0 = (this.field_146294_l - this.field_146999_f) / 2;
            int y0 = (this.field_146295_m - this.field_147000_g) / 2;
            int w = this.field_146999_f;
            int h = this.field_147000_g;
            this.func_73729_b(x0, y0, 0, 0, w, h);
            if (BTileEntity.isBurning((IInventory)this.te)) {
                int k = this.flame_px(13);
                this.func_73729_b(x0 + 59, y0 + 36 + 12 - k, 176, 12 - k, 14, k + 1);
            }
            this.func_73729_b(x0 + 79, y0 + 36, 176, 15, 1 + this.progress_px(17), 15);
        }

        private int progress_px(int pixels) {
            int tc = this.te.func_174887_a_(2);
            int T = this.te.func_174887_a_(3);
            return T > 0 && tc > 0 ? tc * pixels / T : 0;
        }

        private int flame_px(int pixels) {
            int ibt = this.te.func_174887_a_(1);
            return this.te.func_174887_a_(0) * pixels / (ibt > 0 ? ibt : BTileEntity.proc_speed_interval_);
        }
    }

    public static class BInteraction
    implements IInteractionObject {
        private final World world;
        private final BlockPos pos;
        private final BTileEntity te;

        public BInteraction(World world, BlockPos pos, BTileEntity te) {
            this.world = world;
            this.pos = pos;
            this.te = te;
        }

        public ITextComponent func_200200_C_() {
            return new TextComponentTranslation(ModBlocks.SMALL_LAB_FURNACE.func_149739_a(), new Object[0]);
        }

        public boolean func_145818_k_() {
            return false;
        }

        public String func_174875_k() {
            return ModBlocks.SMALL_LAB_FURNACE.getRegistryName().toString();
        }

        @Nullable
        public ITextComponent func_200201_e() {
            return null;
        }

        public Container func_174876_a(InventoryPlayer inv, EntityPlayer player) {
            return new BContainer(inv, this.world, this.pos, this.te);
        }
    }
}

