/*
 * Decompiled with CFR 0.152.
 */
package wile.engineersdecor.blocks;

import java.util.ArrayList;
import java.util.Arrays;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import wile.engineersdecor.blocks.BlockDecor;
import wile.engineersdecor.blocks.BlockDecorStraightPole;
import wile.engineersdecor.blocks.ModBlocks;
import wile.engineersdecor.detail.ModAuxiliaries;

public class BlockDecorHorizontalSupport
extends BlockDecor {
    public static final BooleanProperty EASTWEST = BooleanProperty.func_177716_a((String)"eastwest");
    public static final BooleanProperty LEFTBEAM = BooleanProperty.func_177716_a((String)"leftbeam");
    public static final BooleanProperty RIGHTBEAM = BooleanProperty.func_177716_a((String)"rightbeam");
    public static final IntegerProperty DOWNCONNECT = IntegerProperty.func_177719_a((String)"downconnect", (int)0, (int)2);
    protected final ArrayList<VoxelShape> AABBs;

    public BlockDecorHorizontalSupport(long config, Block.Properties builder, AxisAlignedBB unrotatedAABB) {
        super(config | 2L, builder);
        this.AABBs = new ArrayList<VoxelShape>(Arrays.asList(VoxelShapes.func_197881_a((AxisAlignedBB)ModAuxiliaries.getRotatedAABB(unrotatedAABB.func_72314_b(0.125, 0.0, 0.0), EnumFacing.NORTH, true)), VoxelShapes.func_197881_a((AxisAlignedBB)ModAuxiliaries.getRotatedAABB(unrotatedAABB.func_72314_b(0.125, 0.0, 0.0), EnumFacing.WEST, true)), VoxelShapes.func_197881_a((AxisAlignedBB)ModAuxiliaries.getRotatedAABB(unrotatedAABB, EnumFacing.NORTH, true)), VoxelShapes.func_197881_a((AxisAlignedBB)ModAuxiliaries.getRotatedAABB(unrotatedAABB, EnumFacing.WEST, true))));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    @Override
    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @Override
    public boolean func_149721_r(IBlockState state) {
        return false;
    }

    @Override
    public boolean func_181623_g() {
        return false;
    }

    public boolean func_189872_a(IBlockState state, Entity entityIn) {
        return false;
    }

    public BlockFaceShape func_193383_a(IBlockReader world, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    @Override
    public VoxelShape func_196244_b(IBlockState state, IBlockReader source, BlockPos pos) {
        return this.AABBs.get((Boolean)state.func_177229_b((IProperty)EASTWEST) != false ? 1 : 0);
    }

    @Override
    public VoxelShape func_196268_f(IBlockState state, IBlockReader world, BlockPos pos) {
        return this.func_196244_b(state, world, pos);
    }

    protected void func_206840_a(StateContainer.Builder<Block, IBlockState> builder) {
        builder.func_206894_a(new IProperty[]{EASTWEST, RIGHTBEAM, LEFTBEAM, DOWNCONNECT});
    }

    @Nullable
    public IBlockState func_196258_a(BlockItemUseContext context) {
        return this.temp_block_update_until_better((IBlockState)this.func_176223_P().func_206870_a((IProperty)EASTWEST, (Comparable)Boolean.valueOf(context.func_195992_f().func_176740_k() == EnumFacing.Axis.X)), (IWorld)context.func_195991_k(), context.func_195995_a());
    }

    private IBlockState temp_block_update_until_better(IBlockState state, IWorld world, BlockPos pos) {
        boolean ew = (Boolean)state.func_177229_b((IProperty)EASTWEST);
        IBlockState rstate = world.func_180495_p(!ew ? pos.func_177974_f() : pos.func_177968_d());
        IBlockState lstate = world.func_180495_p(!ew ? pos.func_177976_e() : pos.func_177978_c());
        IBlockState dstate = world.func_180495_p(pos.func_177977_b());
        int down_connector = 0;
        if (dstate.func_177230_c() instanceof BlockDecorStraightPole) {
            EnumFacing dfacing = (EnumFacing)dstate.func_177229_b((IProperty)BlockDecorStraightPole.FACING);
            BlockDecorStraightPole pole = (BlockDecorStraightPole)dstate.func_177230_c();
            if (dfacing.func_176740_k() == EnumFacing.Axis.Y) {
                if (pole == ModBlocks.THICK_STEEL_POLE || pole == ModBlocks.THICK_STEEL_POLE_HEAD && dfacing == EnumFacing.UP) {
                    down_connector = 2;
                } else if (pole == ModBlocks.THIN_STEEL_POLE || pole == ModBlocks.THIN_STEEL_POLE_HEAD && dfacing == EnumFacing.UP) {
                    down_connector = 1;
                }
            }
        }
        return (IBlockState)((IBlockState)((IBlockState)state.func_206870_a((IProperty)RIGHTBEAM, (Comparable)Boolean.valueOf(rstate.func_177230_c() == this && (Boolean)rstate.func_177229_b((IProperty)EASTWEST) != ew))).func_206870_a((IProperty)LEFTBEAM, (Comparable)Boolean.valueOf(lstate.func_177230_c() == this && (Boolean)lstate.func_177229_b((IProperty)EASTWEST) != ew))).func_206870_a((IProperty)DOWNCONNECT, (Comparable)Integer.valueOf(down_connector));
    }

    public IBlockState func_196271_a(IBlockState state, EnumFacing facing, IBlockState facingState, IWorld world, BlockPos pos, BlockPos facingPos) {
        return this.temp_block_update_until_better(state, world, pos);
    }

    @Deprecated
    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos fromPos) {
        world.func_175656_a(pos, this.temp_block_update_until_better(state, (IWorld)world, pos));
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return rot == Rotation.CLOCKWISE_180 ? state : (IBlockState)state.func_206870_a((IProperty)EASTWEST, (Comparable)Boolean.valueOf((Boolean)state.func_177229_b((IProperty)EASTWEST) == false));
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirrorIn) {
        return state;
    }
}

