/*
 * Decompiled with CFR 0.152.
 */
package wile.engineersdecor.blocks;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLadder;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IProperty;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import wile.engineersdecor.detail.ModAuxiliaries;

public class BlockDecorLadder
extends BlockLadder {
    protected static final AxisAlignedBB EDLADDER_UNROTATED_AABB = ModAuxiliaries.getPixeledAABB(3.0, 0.0, 0.0, 13.0, 16.0, 3.0);
    protected static final VoxelShape EDLADDER_SOUTH_AABB = VoxelShapes.func_197881_a((AxisAlignedBB)ModAuxiliaries.getRotatedAABB(EDLADDER_UNROTATED_AABB, EnumFacing.SOUTH, false));
    protected static final VoxelShape EDLADDER_EAST_AABB = VoxelShapes.func_197881_a((AxisAlignedBB)ModAuxiliaries.getRotatedAABB(EDLADDER_UNROTATED_AABB, EnumFacing.EAST, false));
    protected static final VoxelShape EDLADDER_WEST_AABB = VoxelShapes.func_197881_a((AxisAlignedBB)ModAuxiliaries.getRotatedAABB(EDLADDER_UNROTATED_AABB, EnumFacing.WEST, false));
    protected static final VoxelShape EDLADDER_NORTH_AABB = VoxelShapes.func_197881_a((AxisAlignedBB)ModAuxiliaries.getRotatedAABB(EDLADDER_UNROTATED_AABB, EnumFacing.NORTH, false));

    public BlockDecorLadder(long config, Block.Properties builder) {
        super(builder);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable IBlockReader world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        ModAuxiliaries.Tooltip.addInformation(stack, world, tooltip, flag, true);
    }

    public VoxelShape func_196244_b(IBlockState state, IBlockReader worldIn, BlockPos pos) {
        switch ((EnumFacing)state.func_177229_b((IProperty)field_176382_a)) {
            case NORTH: {
                return EDLADDER_NORTH_AABB;
            }
            case SOUTH: {
                return EDLADDER_SOUTH_AABB;
            }
            case WEST: {
                return EDLADDER_WEST_AABB;
            }
        }
        return EDLADDER_EAST_AABB;
    }

    public boolean func_181623_g() {
        return false;
    }

    public boolean func_189872_a(IBlockState state, Entity entityIn) {
        return false;
    }

    public EnumPushReaction func_149656_h(IBlockState state) {
        return EnumPushReaction.NORMAL;
    }

    public static void onPlayerUpdateEvent(EntityPlayer player) {
        if (!player.func_70617_f_() || player.func_70093_af() || player.func_175149_v()) {
            return;
        }
        if (Math.abs(player.field_70181_x) < 0.1 || Math.abs(player.field_70181_x) > 0.7 || player.func_70040_Z().field_72448_b > 0.0 != player.field_70181_x > 0.0) {
            return;
        }
        if (Math.abs(player.func_70040_Z().field_72448_b) < 0.9) {
            return;
        }
        BlockPos pos = new BlockPos(player.field_70165_t, player.field_70163_u, player.field_70161_v);
        if (!(player.field_70170_p.func_180495_p(pos).func_177230_c() instanceof BlockDecorLadder)) {
            return;
        }
        player.field_70143_R = 0.0f;
        player.field_70181_x = player.field_70181_x < -0.25 ? -0.7 : (player.field_70181_x > 0.25 ? 0.7 : player.field_70181_x);
        player.field_70159_w = MathHelper.func_151237_a((double)player.field_70159_w, (double)-0.15, (double)0.15);
        player.field_70179_y = MathHelper.func_151237_a((double)player.field_70159_w, (double)-0.15, (double)0.15);
        player.func_70091_d(MoverType.PLAYER, player.field_70159_w, player.field_70181_x, player.field_70179_y);
    }
}

