/*
 * Decompiled with CFR 0.152.
 */
package wile.engineersdecor.blocks;

import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.fluid.IFluidState;
import net.minecraft.init.Particles;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.inventory.Slot;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.INBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.particles.IParticleData;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IInteractionObject;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import wile.engineersdecor.ModEngineersDecor;
import wile.engineersdecor.blocks.BlockDecor;
import wile.engineersdecor.blocks.BlockDecorFurnace;
import wile.engineersdecor.blocks.ModBlocks;

public class BlockDecorWasteIncinerator
extends BlockDecor {
    public static final BooleanProperty LIT = BlockDecorFurnace.LIT;

    public BlockDecorWasteIncinerator(long config, Block.Properties builder, AxisAlignedBB unrotatedAABB) {
        super(config, builder, unrotatedAABB);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.SOLID;
    }

    public BlockFaceShape func_193383_a(IBlockReader world, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.SOLID;
    }

    protected void func_206840_a(StateContainer.Builder<Block, IBlockState> builder) {
        builder.func_206894_a(new IProperty[]{LIT});
    }

    @Nullable
    public IBlockState func_196258_a(BlockItemUseContext context) {
        return (IBlockState)super.func_196258_a(context).func_206870_a((IProperty)LIT, (Comparable)Boolean.valueOf(false));
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    public int func_180641_l(IBlockState blockState, World world, BlockPos pos) {
        return Container.func_178144_a((TileEntity)world.func_175625_s(pos));
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(IBlockState state, IBlockReader world) {
        return new BTileEntity();
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        if (world.field_72995_K) {
            return;
        }
        if (!stack.func_77942_o() || !stack.func_77978_p().func_74764_b("tedata")) {
            return;
        }
        NBTTagCompound te_nbt = stack.func_77978_p().func_74775_l("tedata");
        if (te_nbt.isEmpty()) {
            return;
        }
        TileEntity te = world.func_175625_s(pos);
        if (!(te instanceof BTileEntity)) {
            return;
        }
        ((BTileEntity)te).readnbt(te_nbt);
        ((BTileEntity)te).func_70296_d();
    }

    public void func_196243_a(IBlockState state, World world, BlockPos pos, IBlockState newState, boolean isMoving) {
        if (state.func_177230_c() == newState.func_177230_c()) {
            return;
        }
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof BTileEntity) {
            InventoryHelper.func_180175_a((World)world, (BlockPos)pos, (IInventory)((BTileEntity)te));
            world.func_175666_e(pos, (Block)this);
        }
        super.func_196243_a(state, world, pos, newState, isMoving);
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest, IFluidState fluid) {
        if (world.field_72995_K) {
            return true;
        }
        TileEntity te = world.func_175625_s(pos);
        if (!(te instanceof BTileEntity)) {
            return super.removedByPlayer(state, world, pos, player, willHarvest, fluid);
        }
        ItemStack stack = new ItemStack((IItemProvider)this, 1);
        NBTTagCompound te_nbt = ((BTileEntity)te).reset_getnbt();
        if (!te_nbt.isEmpty()) {
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74782_a("tedata", (INBTBase)te_nbt);
            stack.func_77982_d(nbt);
        }
        world.func_175713_t(pos);
        world.func_175655_b(pos, false);
        world.func_72838_d((Entity)new EntityItem(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, stack));
        return false;
    }

    public void func_180652_a(World world, BlockPos pos, Explosion explosion) {
        if (world.field_72995_K) {
            return;
        }
        TileEntity te = world.func_175625_s(pos);
        if (!(te instanceof BTileEntity)) {
            return;
        }
        for (ItemStack stack : ((BTileEntity)te).stacks_) {
            if (stack.func_190926_b()) continue;
            world.func_72838_d((Entity)new EntityItem(world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), stack));
        }
        ((BTileEntity)te).reset_getnbt();
        super.func_180652_a(world, pos, explosion);
    }

    public boolean func_196250_a(IBlockState state, World world, BlockPos pos, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return true;
        }
        TileEntity te = world.func_175625_s(pos);
        if (!(te instanceof BTileEntity)) {
            return true;
        }
        if (!(player instanceof EntityPlayerMP) && !(player instanceof FakePlayer)) {
            return true;
        }
        NetworkHooks.openGui((EntityPlayerMP)((EntityPlayerMP)player), (IInteractionObject)new BInteraction(world, pos, (BTileEntity)te), buf -> buf.func_179255_a(pos));
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rnd) {
        if (state.func_177230_c() != this || !((Boolean)state.func_177229_b((IProperty)LIT)).booleanValue()) {
            return;
        }
        double rv = rnd.nextDouble();
        if (rv > 0.5) {
            return;
        }
        double x = 0.5 + (double)pos.func_177958_n();
        double y = 0.5 + (double)pos.func_177956_o();
        double z = 0.5 + (double)pos.func_177952_p();
        double xr = rnd.nextDouble() * 0.4 - 0.2;
        double yr = rnd.nextDouble() * 0.5;
        double zr = rnd.nextDouble() * 0.4 - 0.2;
        world.func_195594_a((IParticleData)Particles.field_197601_L, x + xr, y + yr, z + zr, 0.0, 0.0, 0.0);
    }

    public static class BTileEntity
    extends TileEntity
    implements ITickable,
    ISidedInventory,
    IEnergyStorage {
        public static final int TICK_INTERVAL = 20;
        public static final int ENERGIZED_TICK_INTERVAL = 5;
        public static final int MAX_ENERGY_BUFFER = 16000;
        public static final int MAX_ENERGY_TRANSFER = 256;
        public static final int DEFAULT_ENERGY_CONSUMPTION = 16;
        public static final int NUM_OF_SLOTS = 16;
        public static final int INPUT_SLOT_NO = 0;
        public static final int BURN_SLOT_NO = 15;
        private static int energy_consumption = 16;
        private int tick_timer_;
        private int check_timer_;
        private int energy_stored_;
        protected NonNullList<ItemStack> stacks_ = NonNullList.func_191197_a((int)16, (Object)ItemStack.field_190927_a);
        private static final int[] SIDED_INV_SLOTS = new int[]{0};
        protected LazyOptional<IItemHandler> item_handler_ = LazyOptional.of(() -> new BItemHandler(this));
        protected LazyOptional<IEnergyStorage> energy_handler_ = LazyOptional.of(() -> this);

        public static void on_config(int speed_percent, int fuel_efficiency_percent, int boost_energy_per_tick) {
            energy_consumption = MathHelper.func_76125_a((int)boost_energy_per_tick, (int)16, (int)512);
            ModEngineersDecor.logger().info("Config waste incinerator boost energy consumption:" + energy_consumption);
        }

        public BTileEntity() {
            this(ModBlocks.TET_WASTE_INCINERATOR);
        }

        public BTileEntity(TileEntityType<?> te_type) {
            super(te_type);
            this.reset();
        }

        public NBTTagCompound reset_getnbt() {
            NBTTagCompound nbt = new NBTTagCompound();
            this.writenbt(nbt);
            this.reset();
            return nbt;
        }

        protected void reset() {
            this.stacks_ = NonNullList.func_191197_a((int)16, (Object)ItemStack.field_190927_a);
            this.check_timer_ = 0;
            this.tick_timer_ = 0;
        }

        public void readnbt(NBTTagCompound compound) {
            NonNullList stacks = NonNullList.func_191197_a((int)16, (Object)ItemStack.field_190927_a);
            ItemStackHelper.func_191283_b((NBTTagCompound)compound, (NonNullList)stacks);
            while (stacks.size() < 16) {
                stacks.add((Object)ItemStack.field_190927_a);
            }
            this.stacks_ = stacks;
            this.energy_stored_ = compound.func_74762_e("Energy");
        }

        protected void writenbt(NBTTagCompound compound) {
            compound.func_74768_a("Energy", MathHelper.func_76125_a((int)this.energy_stored_, (int)0, (int)16000));
            ItemStackHelper.func_191282_a((NBTTagCompound)compound, this.stacks_);
        }

        private ItemStack shiftStacks(int index_from, int index_to) {
            if (index_from >= index_to) {
                return ItemStack.field_190927_a;
            }
            ItemStack out_stack = ItemStack.field_190927_a;
            ItemStack stack = (ItemStack)this.stacks_.get(index_from);
            for (int i = index_from + 1; i <= index_to; ++i) {
                out_stack = (ItemStack)this.stacks_.get(i);
                this.stacks_.set(i, (Object)stack);
                stack = out_stack;
            }
            this.stacks_.set(index_from, (Object)ItemStack.field_190927_a);
            return out_stack;
        }

        private boolean transferItems(int index_from, int index_to, int count) {
            ItemStack from = (ItemStack)this.stacks_.get(index_from);
            if (from.func_190926_b()) {
                return false;
            }
            ItemStack to = (ItemStack)this.stacks_.get(index_to);
            if (from.func_190916_E() < count) {
                count = from.func_190916_E();
            }
            if (count <= 0) {
                return false;
            }
            boolean changed = true;
            if (to.func_190926_b()) {
                this.stacks_.set(index_to, (Object)from.func_77979_a(count));
            } else if (to.func_190916_E() >= to.func_77976_d()) {
                changed = false;
            } else if (!from.func_77969_a(to) || !ItemStack.func_77970_a((ItemStack)from, (ItemStack)to)) {
                changed = false;
            } else if (to.func_190916_E() + count >= to.func_77976_d()) {
                from.func_190918_g(to.func_77976_d() - to.func_190916_E());
                to.func_190920_e(to.func_77976_d());
            } else {
                from.func_190918_g(count);
                to.func_190917_f(count);
            }
            if (from.func_190926_b() && from != ItemStack.field_190927_a) {
                this.stacks_.set(index_from, (Object)ItemStack.field_190927_a);
                changed = true;
            }
            return changed;
        }

        public void func_145839_a(NBTTagCompound compound) {
            super.func_145839_a(compound);
            this.readnbt(compound);
        }

        public NBTTagCompound func_189515_b(NBTTagCompound compound) {
            super.func_189515_b(compound);
            this.writenbt(compound);
            return compound;
        }

        public ITextComponent func_200200_C_() {
            Block block = this.func_195044_w().func_177230_c();
            return block != null ? block.func_200291_n() : new TextComponentString("Small Waste Incinerator");
        }

        public boolean func_145818_k_() {
            return false;
        }

        public ITextComponent func_200201_e() {
            return this.func_200200_C_();
        }

        public int func_70302_i_() {
            return this.stacks_.size();
        }

        public boolean func_191420_l() {
            for (ItemStack stack : this.stacks_) {
                if (stack.func_190926_b()) continue;
                return false;
            }
            return true;
        }

        public ItemStack func_70301_a(int index) {
            return index >= 0 && index < this.func_70302_i_() ? (ItemStack)this.stacks_.get(index) : ItemStack.field_190927_a;
        }

        public ItemStack func_70298_a(int index, int count) {
            return ItemStackHelper.func_188382_a(this.stacks_, (int)index, (int)count);
        }

        public ItemStack func_70304_b(int index) {
            return ItemStackHelper.func_188383_a(this.stacks_, (int)index);
        }

        public void func_70299_a(int index, ItemStack stack) {
            if (stack.func_190916_E() > this.func_70297_j_()) {
                stack.func_190920_e(this.func_70297_j_());
            }
            this.stacks_.set(index, (Object)stack);
            this.func_70296_d();
        }

        public int func_70297_j_() {
            return 64;
        }

        public void func_70296_d() {
            super.func_70296_d();
        }

        public boolean func_70300_a(EntityPlayer player) {
            return this.field_145850_b.func_175625_s(this.field_174879_c) == this && player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
        }

        public void func_174889_b(EntityPlayer player) {
        }

        public void func_174886_c(EntityPlayer player) {
            this.func_70296_d();
        }

        public boolean func_94041_b(int index, ItemStack stack) {
            return index == 0;
        }

        public int func_174887_a_(int id) {
            return 0;
        }

        public void func_174885_b(int id, int value) {
        }

        public int func_174890_g() {
            return 4;
        }

        public void func_174888_l() {
            this.stacks_.clear();
        }

        public int[] func_180463_a(EnumFacing side) {
            return SIDED_INV_SLOTS;
        }

        public boolean func_180462_a(int index, ItemStack itemStackIn, EnumFacing direction) {
            return this.func_94041_b(index, itemStackIn);
        }

        public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
            return false;
        }

        public boolean canExtract() {
            return false;
        }

        public boolean canReceive() {
            return true;
        }

        public int getMaxEnergyStored() {
            return 16000;
        }

        public int getEnergyStored() {
            return this.energy_stored_;
        }

        public int extractEnergy(int maxExtract, boolean simulate) {
            return 0;
        }

        public int receiveEnergy(int maxReceive, boolean simulate) {
            if (this.energy_stored_ >= 16000) {
                return 0;
            }
            int n = Math.min(maxReceive, 16000 - this.energy_stored_);
            if (n > 256) {
                n = 256;
            }
            if (!simulate) {
                this.energy_stored_ += n;
                this.func_70296_d();
            }
            return n;
        }

        public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
            if (!this.field_145846_f && facing != null) {
                if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
                    return this.item_handler_.cast();
                }
                if (capability == CapabilityEnergy.ENERGY) {
                    return this.energy_handler_.cast();
                }
            }
            return super.getCapability(capability, facing);
        }

        public void func_73660_a() {
            ItemStack first_stack;
            boolean shift;
            boolean was_processing;
            if (--this.tick_timer_ > 0) {
                return;
            }
            this.tick_timer_ = 20;
            if (this.field_145850_b.field_72995_K) {
                return;
            }
            boolean dirty = false;
            ItemStack processing_stack = (ItemStack)this.stacks_.get(15);
            boolean is_processing = was_processing = !processing_stack.func_190926_b();
            boolean new_stack_processing = false;
            if (!((ItemStack)this.stacks_.get(0)).func_190926_b() && this.transferItems(0, 1, this.func_70297_j_())) {
                dirty = true;
            }
            boolean bl = shift = !(first_stack = (ItemStack)this.stacks_.get(0)).func_190926_b();
            if (is_processing) {
                processing_stack.func_190918_g(1);
                if (processing_stack.func_190916_E() <= 0) {
                    processing_stack = ItemStack.field_190927_a;
                    is_processing = false;
                }
                this.stacks_.set(15, (Object)processing_stack);
                if (this.energy_stored_ >= energy_consumption * 20) {
                    this.energy_stored_ -= energy_consumption * 20;
                    this.tick_timer_ = 5;
                }
                dirty = true;
            }
            if (shift) {
                int max_shift_slot_no = 14;
                for (int i = 1; i < 14; ++i) {
                    if (!((ItemStack)this.stacks_.get(i)).func_190926_b()) continue;
                    max_shift_slot_no = i;
                    break;
                }
                if (max_shift_slot_no < 14) {
                    boolean stacked = false;
                    for (int i = 1; i <= max_shift_slot_no; ++i) {
                        if (!this.transferItems(i - 1, i, this.func_70297_j_())) continue;
                        dirty = true;
                        stacked = true;
                        break;
                    }
                    if (!stacked) {
                        this.shiftStacks(0, max_shift_slot_no);
                    }
                } else if (!is_processing) {
                    this.shiftStacks(0, 15);
                    dirty = true;
                }
            }
            if (was_processing != is_processing || new_stack_processing) {
                IBlockState state;
                if (new_stack_processing) {
                    this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundEvents.field_187656_cX, SoundCategory.BLOCKS, 0.05f, 2.4f);
                }
                if ((state = this.field_145850_b.func_180495_p(this.field_174879_c)).func_177230_c() instanceof BlockDecorWasteIncinerator) {
                    this.field_145850_b.func_180501_a(this.field_174879_c, (IBlockState)state.func_206870_a((IProperty)LIT, (Comparable)Boolean.valueOf(is_processing)), 18);
                }
            }
            if (dirty) {
                this.func_70296_d();
            }
        }

        protected static class BItemHandler
        implements IItemHandler {
            private BTileEntity te;

            BItemHandler(BTileEntity te) {
                this.te = te;
            }

            public int getSlots() {
                return 1;
            }

            public int getSlotLimit(int index) {
                return this.te.func_70297_j_();
            }

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                return true;
            }

            @Nonnull
            public ItemStack insertItem(int index, @Nonnull ItemStack stack, boolean simulate) {
                if (stack.func_190926_b()) {
                    return ItemStack.field_190927_a;
                }
                if (index != 0) {
                    return ItemStack.field_190927_a;
                }
                int slotno = 0;
                ItemStack slotstack = this.getStackInSlot(slotno);
                if (!slotstack.func_190926_b()) {
                    if (slotstack.func_190916_E() >= Math.min(slotstack.func_77976_d(), this.getSlotLimit(index))) {
                        return stack;
                    }
                    if (!ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)slotstack)) {
                        return stack;
                    }
                    if (!this.te.func_180462_a(slotno, stack, EnumFacing.UP) || !this.te.func_94041_b(slotno, stack)) {
                        return stack;
                    }
                    int n = Math.min(stack.func_77976_d(), this.getSlotLimit(index)) - slotstack.func_190916_E();
                    if (stack.func_190916_E() <= n) {
                        if (!simulate) {
                            ItemStack copy = stack.func_77946_l();
                            copy.func_190917_f(slotstack.func_190916_E());
                            this.te.func_70299_a(slotno, copy);
                        }
                        return ItemStack.field_190927_a;
                    }
                    stack = stack.func_77946_l();
                    if (!simulate) {
                        ItemStack copy = stack.func_77979_a(n);
                        copy.func_190917_f(slotstack.func_190916_E());
                        this.te.func_70299_a(slotno, copy);
                        return stack;
                    }
                    stack.func_190918_g(n);
                    return stack;
                }
                if (!this.te.func_180462_a(slotno, stack, EnumFacing.UP) || !this.te.func_94041_b(slotno, stack)) {
                    return stack;
                }
                int n = Math.min(stack.func_77976_d(), this.getSlotLimit(index));
                if (n < stack.func_190916_E()) {
                    stack = stack.func_77946_l();
                    if (!simulate) {
                        this.te.func_70299_a(slotno, stack.func_77979_a(n));
                        return stack;
                    }
                    stack.func_190918_g(n);
                    return stack;
                }
                if (!simulate) {
                    this.te.func_70299_a(slotno, stack);
                }
                return ItemStack.field_190927_a;
            }

            @Nonnull
            public ItemStack extractItem(int index, int amount, boolean simulate) {
                return ItemStack.field_190927_a;
            }

            @Nonnull
            public ItemStack getStackInSlot(int index) {
                return this.te.func_70301_a(index);
            }
        }
    }

    public static class BContainer
    extends Container {
        private static final int PLAYER_INV_START_SLOTNO = 16;
        private final World world;
        private final BlockPos pos;
        private final EntityPlayer player;
        private final BTileEntity te;
        private int proc_time_needed_;

        public BContainer(InventoryPlayer playerInventory, World world, BlockPos pos, BTileEntity te) {
            this.player = playerInventory.field_70458_d;
            this.world = world;
            this.pos = pos;
            this.te = te;
            int i = -1;
            this.func_75146_a(new Slot((IInventory)te, ++i, 13, 9));
            this.func_75146_a(new Slot((IInventory)te, ++i, 37, 12));
            this.func_75146_a(new Slot((IInventory)te, ++i, 54, 13));
            this.func_75146_a(new Slot((IInventory)te, ++i, 71, 14));
            this.func_75146_a(new Slot((IInventory)te, ++i, 88, 15));
            this.func_75146_a(new Slot((IInventory)te, ++i, 105, 16));
            this.func_75146_a(new Slot((IInventory)te, ++i, 122, 17));
            this.func_75146_a(new Slot((IInventory)te, ++i, 139, 18));
            this.func_75146_a(new Slot((IInventory)te, ++i, 144, 38));
            this.func_75146_a(new Slot((IInventory)te, ++i, 127, 39));
            this.func_75146_a(new Slot((IInventory)te, ++i, 110, 40));
            this.func_75146_a(new Slot((IInventory)te, ++i, 93, 41));
            this.func_75146_a(new Slot((IInventory)te, ++i, 76, 42));
            this.func_75146_a(new Slot((IInventory)te, ++i, 59, 43));
            this.func_75146_a(new Slot((IInventory)te, ++i, 42, 44));
            this.func_75146_a(new Slot((IInventory)te, ++i, 17, 58));
            for (int x = 0; x < 9; ++x) {
                this.func_75146_a(new Slot((IInventory)playerInventory, x, 8 + x * 18, 144));
            }
            for (int y = 0; y < 3; ++y) {
                for (int x = 0; x < 9; ++x) {
                    this.func_75146_a(new Slot((IInventory)playerInventory, x + y * 9 + 9, 8 + x * 18, 86 + y * 18));
                }
            }
        }

        public void func_75132_a(IContainerListener listener) {
            super.func_75132_a(listener);
            listener.func_175173_a((Container)this, (IInventory)this.te);
        }

        public void func_75142_b() {
            super.func_75142_b();
            for (int i = 0; i < this.field_75149_d.size(); ++i) {
                IContainerListener lis = (IContainerListener)this.field_75149_d.get(i);
                if (this.proc_time_needed_ == this.te.func_174887_a_(3)) continue;
                lis.func_71112_a((Container)this, 3, this.te.func_174887_a_(3));
            }
            this.proc_time_needed_ = this.te.func_174887_a_(3);
        }

        @OnlyIn(value=Dist.CLIENT)
        public void func_75137_b(int id, int data) {
            this.te.func_174885_b(id, data);
        }

        public boolean func_75145_c(EntityPlayer player) {
            return this.world.func_180495_p(this.pos).func_177230_c() instanceof BlockDecorWasteIncinerator && player.func_174818_b(this.pos) <= 64.0;
        }

        public ItemStack func_82846_b(EntityPlayer player, int index) {
            Slot slot = (Slot)this.field_75151_b.get(index);
            if (slot == null || !slot.func_75216_d()) {
                return ItemStack.field_190927_a;
            }
            ItemStack slot_stack = slot.func_75211_c();
            ItemStack transferred = slot_stack.func_77946_l();
            if (index >= 0 && index < 16) {
                if (!this.func_75135_a(slot_stack, 16, 52, true)) {
                    return ItemStack.field_190927_a;
                }
            } else if (index >= 16 && index <= 52) {
                if (!this.func_75135_a(slot_stack, 0, 15, true)) {
                    return ItemStack.field_190927_a;
                }
            } else {
                return ItemStack.field_190927_a;
            }
            if (slot_stack.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
            if (slot_stack.func_190916_E() == transferred.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            slot.func_190901_a(player, slot_stack);
            return transferred;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class BGui
    extends GuiContainer {
        private final BTileEntity te;

        public BGui(InventoryPlayer playerInventory, World world, BlockPos pos, BTileEntity te) {
            super((Container)new BContainer(playerInventory, world, pos, te));
            this.te = te;
        }

        public void func_73866_w_() {
            super.func_73866_w_();
        }

        public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
            this.func_146276_q_();
            super.func_73863_a(mouseX, mouseY, partialTicks);
            this.func_191948_b(mouseX, mouseY);
        }

        protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.field_146297_k.func_110434_K().func_110577_a(new ResourceLocation("engineersdecor", "textures/gui/small_waste_incinerator_gui.png"));
            int x0 = (this.field_146294_l - this.field_146999_f) / 2;
            int y0 = (this.field_146295_m - this.field_147000_g) / 2;
            int w = this.field_146999_f;
            int h = this.field_147000_g;
            this.func_73729_b(x0, y0, 0, 0, w, h);
        }
    }

    public static class BInteraction
    implements IInteractionObject {
        private final World world;
        private final BlockPos pos;
        private final BTileEntity te;

        public BInteraction(World world, BlockPos pos, BTileEntity te) {
            this.world = world;
            this.pos = pos;
            this.te = te;
        }

        public ITextComponent func_200200_C_() {
            return new TextComponentTranslation(ModBlocks.SMALL_WASTE_INCINERATOR.func_149739_a(), new Object[0]);
        }

        public boolean func_145818_k_() {
            return false;
        }

        public String func_174875_k() {
            return ModBlocks.SMALL_WASTE_INCINERATOR.getRegistryName().toString();
        }

        @Nullable
        public ITextComponent func_200201_e() {
            return null;
        }

        public Container func_174876_a(InventoryPlayer inv, EntityPlayer player) {
            return new BContainer(inv, this.world, this.pos, this.te);
        }
    }
}

