/*
 * Decompiled with CFR 0.152.
 */
package wile.engineersdecor.detail;

import java.util.function.Supplier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.simple.SimpleChannel;
import wile.engineersdecor.ModEngineersDecor;

public class Networking {
    private static final String PROTOCOL = "1";
    private static final SimpleChannel DEFAULT_CHANNEL = NetworkRegistry.ChannelBuilder.named((ResourceLocation)new ResourceLocation("engineersdecor", "default_ch")).clientAcceptedVersions("1"::equals).serverAcceptedVersions("1"::equals).networkProtocolVersion(() -> "1").simpleChannel();

    public static void init() {
        int discr = -1;
        DEFAULT_CHANNEL.registerMessage(++discr, PacketTileNotifyClientToServer.class, PacketTileNotifyClientToServer::compose, PacketTileNotifyClientToServer::parse, PacketTileNotifyClientToServer.Handler::handle);
        DEFAULT_CHANNEL.registerMessage(++discr, PacketTileNotifyServerToClient.class, PacketTileNotifyServerToClient::compose, PacketTileNotifyServerToClient::parse, PacketTileNotifyServerToClient.Handler::handle);
    }

    public static class PacketTileNotifyServerToClient {
        NBTTagCompound nbt = null;
        BlockPos pos = BlockPos.field_177992_a;

        public static void sendToPlayer(EntityPlayer player, TileEntity te, NBTTagCompound nbt) {
            if (!(player instanceof EntityPlayerMP) || player instanceof FakePlayer || te == null || nbt == null) {
                return;
            }
            DEFAULT_CHANNEL.sendTo((Object)new PacketTileNotifyServerToClient(te, nbt), ((EntityPlayerMP)player).field_71135_a.field_147371_a, NetworkDirection.PLAY_TO_CLIENT);
        }

        public PacketTileNotifyServerToClient() {
        }

        public PacketTileNotifyServerToClient(BlockPos pos, NBTTagCompound nbt) {
            this.nbt = nbt;
            this.pos = pos;
        }

        public PacketTileNotifyServerToClient(TileEntity te, NBTTagCompound nbt) {
            this.nbt = nbt;
            this.pos = te.func_174877_v();
        }

        public static PacketTileNotifyServerToClient parse(PacketBuffer buf) {
            return new PacketTileNotifyServerToClient(buf.func_179259_c(), buf.func_150793_b());
        }

        public static void compose(PacketTileNotifyServerToClient pkt, PacketBuffer buf) {
            buf.func_179255_a(pkt.pos);
            buf.func_150786_a(pkt.nbt);
        }

        public static class Handler {
            public static void handle(PacketTileNotifyServerToClient pkt, Supplier<NetworkEvent.Context> ctx) {
                ctx.get().enqueueWork(() -> {
                    World world = ModEngineersDecor.proxy.getWorlClientSide();
                    if (world == null) {
                        return;
                    }
                    TileEntity te = world.func_175625_s(pkt.pos);
                    if (!(te instanceof IPacketTileNotifyReceiver)) {
                        return;
                    }
                    ((IPacketTileNotifyReceiver)te).onServerPacketReceived(pkt.nbt);
                });
                ctx.get().setPacketHandled(true);
            }
        }
    }

    public static class PacketTileNotifyClientToServer {
        NBTTagCompound nbt = null;
        BlockPos pos = BlockPos.field_177992_a;

        public static void sendToServer(TileEntity te, NBTTagCompound nbt) {
            if (te == null || nbt == null) {
                return;
            }
            DEFAULT_CHANNEL.sendToServer((Object)new PacketTileNotifyClientToServer(te, nbt));
        }

        public PacketTileNotifyClientToServer() {
        }

        public PacketTileNotifyClientToServer(BlockPos pos, NBTTagCompound nbt) {
            this.nbt = nbt;
            this.pos = pos;
        }

        public PacketTileNotifyClientToServer(TileEntity te, NBTTagCompound nbt) {
            this.nbt = nbt;
            this.pos = te.func_174877_v();
        }

        public static PacketTileNotifyClientToServer parse(PacketBuffer buf) {
            return new PacketTileNotifyClientToServer(buf.func_179259_c(), buf.func_150793_b());
        }

        public static void compose(PacketTileNotifyClientToServer pkt, PacketBuffer buf) {
            buf.func_179255_a(pkt.pos);
            buf.func_150786_a(pkt.nbt);
        }

        public static class Handler {
            public static void handle(PacketTileNotifyClientToServer pkt, Supplier<NetworkEvent.Context> ctx) {
                ctx.get().enqueueWork(() -> {
                    EntityPlayerMP player = ((NetworkEvent.Context)ctx.get()).getSender();
                    World world = player.field_70170_p;
                    if (world == null) {
                        return;
                    }
                    TileEntity te = world.func_175625_s(pkt.pos);
                    if (!(te instanceof IPacketTileNotifyReceiver)) {
                        return;
                    }
                    ((IPacketTileNotifyReceiver)te).onClientPacketReceived((EntityPlayer)((NetworkEvent.Context)ctx.get()).getSender(), pkt.nbt);
                });
                ctx.get().setPacketHandled(true);
            }
        }
    }

    public static interface IPacketTileNotifyReceiver {
        default public void onServerPacketReceived(NBTTagCompound nbt) {
        }

        default public void onClientPacketReceived(EntityPlayer player, NBTTagCompound nbt) {
        }
    }
}

