/*
 * Decompiled with CFR 0.152.
 */
package wile.engineersdecor.detail;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.function.BooleanSupplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.IConditionSerializer;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import wile.engineersdecor.detail.ModAuxiliaries;

public class RecipeCondModSpecific
implements IConditionSerializer {
    public static final BooleanSupplier RECIPE_INCLUDE = () -> true;
    public static final BooleanSupplier RECIPE_EXCLUDE = () -> false;

    @Nonnull
    public BooleanSupplier parse(@Nullable JsonObject json) {
        try {
            ResourceLocation rl;
            JsonPrimitive result;
            if (json == null) {
                return RECIPE_EXCLUDE;
            }
            IForgeRegistry block_registry = ForgeRegistries.BLOCKS;
            IForgeRegistry item_registry = ForgeRegistries.ITEMS;
            JsonArray items = json.getAsJsonArray("required");
            if (items != null) {
                for (JsonElement e : items) {
                    ResourceLocation rl2;
                    if (!e.isJsonPrimitive() || block_registry.containsKey(rl2 = new ResourceLocation(((JsonPrimitive)e).getAsString())) || item_registry.containsKey(rl2)) continue;
                    return RECIPE_EXCLUDE;
                }
            }
            if ((result = json.getAsJsonPrimitive("result")) != null && !block_registry.containsKey(rl = new ResourceLocation(result.getAsString())) && !item_registry.containsKey(rl)) {
                return RECIPE_EXCLUDE;
            }
            JsonArray missing = json.getAsJsonArray("missing");
            if (missing != null && missing.size() > 0) {
                for (JsonElement e : missing) {
                    ResourceLocation rl3;
                    if (!e.isJsonPrimitive() || block_registry.containsKey(rl3 = new ResourceLocation(((JsonPrimitive)e).getAsString())) || item_registry.containsKey(rl3)) continue;
                    return RECIPE_INCLUDE;
                }
                return RECIPE_EXCLUDE;
            }
            return RECIPE_INCLUDE;
        }
        catch (Throwable ex) {
            ModAuxiliaries.logError("rsgauges::ResultRegisteredCondition failed: " + ex.toString());
            return RECIPE_EXCLUDE;
        }
    }
}

