/*
 * Decompiled with CFR 0.152.
 */
package wile.engineersdecor.blocks;

import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.Half;
import net.minecraft.state.properties.StairsShape;
import net.minecraft.util.Direction;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import wile.engineersdecor.blocks.IDecorBlock;
import wile.engineersdecor.libmc.blocks.StandardBlocks;
import wile.engineersdecor.libmc.detail.Auxiliaries;

public class EdRoofBlock
extends StandardBlocks.HorizontalWaterLoggable
implements IDecorBlock {
    public static final EnumProperty<StairsShape> SHAPE = BlockStateProperties.field_208146_au;
    public static final EnumProperty<Half> HALF = BlockStateProperties.field_208164_Q;
    private static final VoxelShape[][][] SHAPE_CACHE = EdRoofBlock.makeShapes();

    public EdRoofBlock(long config, AbstractBlock.Properties properties) {
        super(config, properties.func_235838_a_(state -> 1), Auxiliaries.getPixeledAABB(0.0, 0.0, 0.0, 16.0, 8.0, 16.0));
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)HORIZONTAL_FACING, (Comparable)Direction.NORTH)).func_206870_a(SHAPE, (Comparable)StairsShape.STRAIGHT)).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        return SHAPE_CACHE[((Half)state.func_177229_b(HALF)).ordinal()][((Direction)state.func_177229_b((Property)HORIZONTAL_FACING)).func_176745_a()][((StairsShape)state.func_177229_b(SHAPE)).ordinal()];
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{SHAPE, HALF});
    }

    @Override
    public FluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((Property)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    @Override
    public boolean func_196266_a(BlockState state, IBlockReader world, BlockPos pos, PathType type) {
        return false;
    }

    @Override
    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockPos pos = context.func_195995_a();
        Direction face = context.func_196000_l();
        BlockState state = (BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)HORIZONTAL_FACING, (Comparable)context.func_195992_f())).func_206870_a(HALF, (Comparable)(face == Direction.DOWN ? Half.TOP : Half.BOTTOM))).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(context.func_195991_k().func_204610_c(pos).func_206886_c() == Fluids.field_204546_a));
        return (BlockState)state.func_206870_a(SHAPE, (Comparable)EdRoofBlock.getStairsShapeProperty(state, (IBlockReader)context.func_195991_k(), pos));
    }

    @Override
    public BlockState func_196271_a(BlockState state, Direction facing, BlockState facingState, IWorld world, BlockPos pos, BlockPos facingPos) {
        if (((Boolean)state.func_177229_b((Property)WATERLOGGED)).booleanValue()) {
            world.func_205219_F_().func_205360_a(pos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)world));
        }
        return facing.func_176740_k().func_176722_c() ? (BlockState)state.func_206870_a(SHAPE, (Comparable)EdRoofBlock.getStairsShapeProperty(state, (IBlockReader)world, pos)) : super.func_196271_a(state, facing, facingState, world, pos, facingPos);
    }

    @Override
    public BlockState func_185499_a(BlockState state, Rotation rot) {
        return (BlockState)state.func_206870_a((Property)HORIZONTAL_FACING, (Comparable)rot.func_185831_a((Direction)state.func_177229_b((Property)HORIZONTAL_FACING)));
    }

    @Override
    public BlockState func_185471_a(BlockState state, Mirror where) {
        if (where == Mirror.LEFT_RIGHT && ((Direction)state.func_177229_b((Property)HORIZONTAL_FACING)).func_176740_k() == Direction.Axis.Z) {
            switch ((StairsShape)state.func_177229_b(SHAPE)) {
                case INNER_LEFT: {
                    return (BlockState)state.func_185907_a(Rotation.CLOCKWISE_180).func_206870_a(SHAPE, (Comparable)StairsShape.INNER_RIGHT);
                }
                case INNER_RIGHT: {
                    return (BlockState)state.func_185907_a(Rotation.CLOCKWISE_180).func_206870_a(SHAPE, (Comparable)StairsShape.INNER_LEFT);
                }
                case OUTER_LEFT: {
                    return (BlockState)state.func_185907_a(Rotation.CLOCKWISE_180).func_206870_a(SHAPE, (Comparable)StairsShape.OUTER_RIGHT);
                }
                case OUTER_RIGHT: {
                    return (BlockState)state.func_185907_a(Rotation.CLOCKWISE_180).func_206870_a(SHAPE, (Comparable)StairsShape.OUTER_LEFT);
                }
            }
            return state.func_185907_a(Rotation.CLOCKWISE_180);
        }
        if (where == Mirror.FRONT_BACK && ((Direction)state.func_177229_b((Property)HORIZONTAL_FACING)).func_176740_k() == Direction.Axis.X) {
            switch ((StairsShape)state.func_177229_b(SHAPE)) {
                case INNER_LEFT: {
                    return (BlockState)state.func_185907_a(Rotation.CLOCKWISE_180).func_206870_a(SHAPE, (Comparable)StairsShape.INNER_LEFT);
                }
                case INNER_RIGHT: {
                    return (BlockState)state.func_185907_a(Rotation.CLOCKWISE_180).func_206870_a(SHAPE, (Comparable)StairsShape.INNER_RIGHT);
                }
                case OUTER_LEFT: {
                    return (BlockState)state.func_185907_a(Rotation.CLOCKWISE_180).func_206870_a(SHAPE, (Comparable)StairsShape.OUTER_RIGHT);
                }
                case OUTER_RIGHT: {
                    return (BlockState)state.func_185907_a(Rotation.CLOCKWISE_180).func_206870_a(SHAPE, (Comparable)StairsShape.OUTER_LEFT);
                }
                case STRAIGHT: {
                    return state.func_185907_a(Rotation.CLOCKWISE_180);
                }
            }
        }
        return super.func_185471_a(state, where);
    }

    private static boolean isRoofBlock(BlockState state) {
        return state.func_177230_c() instanceof EdRoofBlock;
    }

    private static boolean isOtherRoofState(BlockState state, IBlockReader world, BlockPos pos, Direction facing) {
        BlockState st = world.func_180495_p(pos.func_177972_a(facing));
        return !EdRoofBlock.isRoofBlock(st) || st.func_177229_b((Property)HORIZONTAL_FACING) != state.func_177229_b((Property)HORIZONTAL_FACING);
    }

    private static VoxelShape[][][] makeShapes() {
        VoxelShape[][][] shapes = new VoxelShape[2][6][5];
        for (int half_index = 0; half_index < Half.values().length; ++half_index) {
            for (int direction_index = 0; direction_index < Direction.values().length; ++direction_index) {
                for (int stairs_shape_index = 0; stairs_shape_index < StairsShape.values().length; ++stairs_shape_index) {
                    shapes[half_index][direction_index][stairs_shape_index] = EdRoofBlock.makeShape(half_index, direction_index, stairs_shape_index);
                }
            }
        }
        return shapes;
    }

    private static VoxelShape makeShape(int half_index, int direction_index, int stairs_shape_index) {
        Direction direction;
        AxisAlignedBB[] straight = new AxisAlignedBB[]{Auxiliaries.getPixeledAABB(0.0, 0.0, 0.0, 16.0, 4.0, 16.0), Auxiliaries.getPixeledAABB(4.0, 4.0, 0.0, 16.0, 8.0, 16.0), Auxiliaries.getPixeledAABB(8.0, 8.0, 0.0, 16.0, 12.0, 16.0), Auxiliaries.getPixeledAABB(12.0, 12.0, 0.0, 16.0, 16.0, 16.0)};
        AxisAlignedBB[] pyramid = new AxisAlignedBB[]{Auxiliaries.getPixeledAABB(0.0, 0.0, 0.0, 16.0, 4.0, 16.0), Auxiliaries.getPixeledAABB(4.0, 4.0, 4.0, 16.0, 8.0, 16.0), Auxiliaries.getPixeledAABB(8.0, 8.0, 8.0, 16.0, 12.0, 16.0), Auxiliaries.getPixeledAABB(12.0, 12.0, 12.0, 16.0, 16.0, 16.0)};
        Half half = Half.values()[half_index];
        if (half == Half.TOP) {
            straight = Auxiliaries.getMirroredAABB(straight, Direction.Axis.Y);
            pyramid = Auxiliaries.getMirroredAABB(pyramid, Direction.Axis.Y);
        }
        if ((direction = Direction.func_82600_a((int)direction_index)) == Direction.UP || direction == Direction.DOWN) {
            return VoxelShapes.func_197868_b();
        }
        direction_index = direction.func_176736_b() + 1 & 3;
        StairsShape stairs = StairsShape.values()[stairs_shape_index];
        switch (stairs) {
            case STRAIGHT: {
                return Auxiliaries.getUnionShape(new AxisAlignedBB[][]{Auxiliaries.getYRotatedAABB(straight, direction_index)});
            }
            case OUTER_LEFT: {
                return Auxiliaries.getUnionShape(new AxisAlignedBB[][]{Auxiliaries.getYRotatedAABB(pyramid, direction_index - 1)});
            }
            case OUTER_RIGHT: {
                return Auxiliaries.getUnionShape(new AxisAlignedBB[][]{Auxiliaries.getYRotatedAABB(pyramid, direction_index)});
            }
            case INNER_LEFT: {
                return Auxiliaries.getUnionShape(Auxiliaries.getYRotatedAABB(straight, direction_index), Auxiliaries.getYRotatedAABB(straight, direction_index - 1));
            }
            case INNER_RIGHT: {
                return Auxiliaries.getUnionShape(Auxiliaries.getYRotatedAABB(straight, direction_index), Auxiliaries.getYRotatedAABB(straight, direction_index + 1));
            }
        }
        return VoxelShapes.func_197868_b();
    }

    private static StairsShape getStairsShapeProperty(BlockState state, IBlockReader world, BlockPos pos) {
        Direction nf;
        Direction direction = (Direction)state.func_177229_b((Property)HORIZONTAL_FACING);
        BlockState ns = world.func_180495_p(pos.func_177972_a(direction));
        if (EdRoofBlock.isRoofBlock(ns) && state.func_177229_b(HALF) == ns.func_177229_b(HALF) && (nf = (Direction)ns.func_177229_b((Property)HORIZONTAL_FACING)).func_176740_k() != ((Direction)state.func_177229_b((Property)HORIZONTAL_FACING)).func_176740_k() && EdRoofBlock.isOtherRoofState(state, world, pos, nf.func_176734_d())) {
            return nf == direction.func_176735_f() ? StairsShape.OUTER_LEFT : StairsShape.OUTER_RIGHT;
        }
        ns = world.func_180495_p(pos.func_177972_a(direction.func_176734_d()));
        if (EdRoofBlock.isRoofBlock(ns) && state.func_177229_b(HALF) == ns.func_177229_b(HALF) && (nf = (Direction)ns.func_177229_b((Property)HORIZONTAL_FACING)).func_176740_k() != ((Direction)state.func_177229_b((Property)HORIZONTAL_FACING)).func_176740_k() && EdRoofBlock.isOtherRoofState(state, world, pos, nf)) {
            return nf == direction.func_176735_f() ? StairsShape.INNER_LEFT : StairsShape.INNER_RIGHT;
        }
        return StairsShape.STRAIGHT;
    }
}

