/*
 * Decompiled with CFR 0.152.
 */
package wile.engineersdecor.blocks;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IIntArray;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.INameable;
import net.minecraft.util.IWorldPosCallable;
import net.minecraft.util.IntArray;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import wile.engineersdecor.ModContent;
import wile.engineersdecor.ModEngineersDecor;
import wile.engineersdecor.blocks.DecorBlock;
import wile.engineersdecor.blocks.EdFurnace;
import wile.engineersdecor.blocks.IDecorBlock;
import wile.engineersdecor.libmc.detail.Inventories;

public class EdWasteIncinerator {

    @OnlyIn(value=Dist.CLIENT)
    public static class WasteIncineratorGui
    extends ContainerScreen<WasteIncineratorContainer> {
        protected final PlayerEntity player_;

        public WasteIncineratorGui(WasteIncineratorContainer container, PlayerInventory player_inventory, ITextComponent title) {
            super((Container)container, player_inventory, title);
            this.player_ = player_inventory.field_70458_d;
        }

        public void func_231160_c_() {
            super.func_231160_c_();
        }

        public void func_230430_a_(MatrixStack mx, int mouseX, int mouseY, float partialTicks) {
            this.func_230446_a_(mx);
            super.func_230430_a_(mx, mouseX, mouseY, partialTicks);
            this.func_230459_a_(mx, mouseX, mouseY);
        }

        protected void func_230451_b_(MatrixStack mx, int x, int y) {
        }

        protected void func_230450_a_(MatrixStack mx, float partialTicks, int mouseX, int mouseY) {
            RenderSystem.enableBlend();
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.getMinecraft().func_110434_K().func_110577_a(new ResourceLocation("engineersdecor", "textures/gui/small_waste_incinerator_gui.png"));
            int x0 = this.field_147003_i;
            int y0 = this.field_147009_r;
            int w = this.field_146999_f;
            int h = this.field_147000_g;
            this.func_238474_b_(mx, x0, y0, 0, 0, w, h);
            RenderSystem.disableBlend();
        }
    }

    public static class WasteIncineratorContainer
    extends Container {
        private static final int PLAYER_INV_START_SLOTNO = 16;
        protected final PlayerEntity player_;
        protected final IInventory inventory_;
        protected final IWorldPosCallable wpc_;
        private final IIntArray fields_;
        private int proc_time_needed_;

        public int field(int index) {
            return this.fields_.func_221476_a(index);
        }

        public PlayerEntity player() {
            return this.player_;
        }

        public IInventory inventory() {
            return this.inventory_;
        }

        public World world() {
            return this.player_.field_70170_p;
        }

        public WasteIncineratorContainer(int cid, PlayerInventory player_inventory) {
            this(cid, player_inventory, (IInventory)new Inventory(16), IWorldPosCallable.field_221489_a, (IIntArray)new IntArray(1));
        }

        private WasteIncineratorContainer(int cid, PlayerInventory player_inventory, IInventory block_inventory, IWorldPosCallable wpc, IIntArray fields) {
            super(ModContent.CT_WASTE_INCINERATOR, cid);
            this.player_ = player_inventory.field_70458_d;
            this.inventory_ = block_inventory;
            this.wpc_ = wpc;
            this.fields_ = fields;
            int i = -1;
            this.func_75146_a(new Slot(this.inventory_, ++i, 13, 9));
            this.func_75146_a(new Slot(this.inventory_, ++i, 37, 12));
            this.func_75146_a(new Slot(this.inventory_, ++i, 54, 13));
            this.func_75146_a(new Slot(this.inventory_, ++i, 71, 14));
            this.func_75146_a(new Slot(this.inventory_, ++i, 88, 15));
            this.func_75146_a(new Slot(this.inventory_, ++i, 105, 16));
            this.func_75146_a(new Slot(this.inventory_, ++i, 122, 17));
            this.func_75146_a(new Slot(this.inventory_, ++i, 139, 18));
            this.func_75146_a(new Slot(this.inventory_, ++i, 144, 38));
            this.func_75146_a(new Slot(this.inventory_, ++i, 127, 39));
            this.func_75146_a(new Slot(this.inventory_, ++i, 110, 40));
            this.func_75146_a(new Slot(this.inventory_, ++i, 93, 41));
            this.func_75146_a(new Slot(this.inventory_, ++i, 76, 42));
            this.func_75146_a(new Slot(this.inventory_, ++i, 59, 43));
            this.func_75146_a(new Slot(this.inventory_, ++i, 42, 44));
            this.func_75146_a(new Slot(this.inventory_, ++i, 17, 58));
            for (int x = 0; x < 9; ++x) {
                this.func_75146_a(new Slot((IInventory)player_inventory, x, 8 + x * 18, 144));
            }
            for (int y = 0; y < 3; ++y) {
                for (int x = 0; x < 9; ++x) {
                    this.func_75146_a(new Slot((IInventory)player_inventory, x + y * 9 + 9, 8 + x * 18, 86 + y * 18));
                }
            }
        }

        public boolean func_75145_c(PlayerEntity player) {
            return this.inventory_.func_70300_a(player);
        }

        public ItemStack func_82846_b(PlayerEntity player, int index) {
            Slot slot = this.func_75139_a(index);
            if (slot == null || !slot.func_75216_d()) {
                return ItemStack.field_190927_a;
            }
            ItemStack slot_stack = slot.func_75211_c();
            ItemStack transferred = slot_stack.func_77946_l();
            if (index >= 0 && index < 16) {
                if (!this.func_75135_a(slot_stack, 16, 52, true)) {
                    return ItemStack.field_190927_a;
                }
            } else if (index >= 16 && index <= 52) {
                if (!this.func_75135_a(slot_stack, 0, 15, true)) {
                    return ItemStack.field_190927_a;
                }
            } else {
                return ItemStack.field_190927_a;
            }
            if (slot_stack.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
            if (slot_stack.func_190916_E() == transferred.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            slot.func_190901_a(player, slot_stack);
            return transferred;
        }
    }

    public static class WasteIncineratorTileEntity
    extends TileEntity
    implements ITickableTileEntity,
    INameable,
    IInventory,
    INamedContainerProvider,
    ISidedInventory,
    IEnergyStorage {
        public static final int NUM_OF_FIELDS = 1;
        public static final int TICK_INTERVAL = 20;
        public static final int ENERGIZED_TICK_INTERVAL = 5;
        public static final int INCINERATION_STACK_DECREMENT = 4;
        public static final int MAX_ENERGY_BUFFER = 16000;
        public static final int MAX_ENERGY_TRANSFER = 256;
        public static final int DEFAULT_ENERGY_CONSUMPTION = 16;
        public static final int NUM_OF_SLOTS = 16;
        public static final int INPUT_SLOT_NO = 0;
        public static final int BURN_SLOT_NO = 15;
        private static int energy_consumption = 16;
        private int tick_timer_;
        private int check_timer_;
        private int energy_stored_;
        protected NonNullList<ItemStack> stacks_ = NonNullList.func_191197_a((int)16, (Object)ItemStack.field_190927_a);
        protected final IIntArray fields = new IntArray(1){

            public int func_221476_a(int id) {
                switch (id) {
                    default: 
                }
                return 0;
            }

            public void func_221477_a(int id, int value) {
                switch (id) {
                    default: 
                }
            }
        };
        private static final int[] SIDED_INV_SLOTS = new int[]{0};
        protected LazyOptional<IItemHandler> item_handler_ = LazyOptional.of(() -> new BItemHandler(this));
        protected LazyOptional<IEnergyStorage> energy_handler_ = LazyOptional.of(() -> this);

        public static void on_config(int speed_percent, int fuel_efficiency_percent, int boost_energy_per_tick) {
            energy_consumption = MathHelper.func_76125_a((int)boost_energy_per_tick, (int)4, (int)4096);
            ModEngineersDecor.logger().info("Config waste incinerator boost energy consumption:" + energy_consumption);
        }

        public WasteIncineratorTileEntity() {
            this(ModContent.TET_WASTE_INCINERATOR);
        }

        public WasteIncineratorTileEntity(TileEntityType<?> te_type) {
            super(te_type);
            this.reset();
        }

        public CompoundNBT reset_getnbt() {
            CompoundNBT nbt = new CompoundNBT();
            this.writenbt(nbt);
            this.reset();
            return nbt;
        }

        protected void reset() {
            this.stacks_ = NonNullList.func_191197_a((int)16, (Object)ItemStack.field_190927_a);
            this.check_timer_ = 0;
            this.tick_timer_ = 0;
        }

        public void readnbt(CompoundNBT compound) {
            NonNullList stacks = NonNullList.func_191197_a((int)16, (Object)ItemStack.field_190927_a);
            ItemStackHelper.func_191283_b((CompoundNBT)compound, (NonNullList)stacks);
            while (stacks.size() < 16) {
                stacks.add((Object)ItemStack.field_190927_a);
            }
            this.stacks_ = stacks;
            this.energy_stored_ = compound.func_74762_e("Energy");
        }

        protected void writenbt(CompoundNBT compound) {
            compound.func_74768_a("Energy", MathHelper.func_76125_a((int)this.energy_stored_, (int)0, (int)16000));
            ItemStackHelper.func_191282_a((CompoundNBT)compound, this.stacks_);
        }

        public void func_230337_a_(BlockState state, CompoundNBT nbt) {
            super.func_230337_a_(state, nbt);
            this.readnbt(nbt);
        }

        public CompoundNBT func_189515_b(CompoundNBT nbt) {
            super.func_189515_b(nbt);
            this.writenbt(nbt);
            return nbt;
        }

        public void func_145843_s() {
            super.func_145843_s();
            this.energy_handler_.invalidate();
            this.item_handler_.invalidate();
        }

        public ITextComponent func_200200_C_() {
            Block block = this.func_195044_w().func_177230_c();
            return new StringTextComponent(block != null ? block.func_149739_a() : "Small Waste Incinerator");
        }

        public boolean func_145818_k_() {
            return false;
        }

        public ITextComponent func_200201_e() {
            return this.func_200200_C_();
        }

        public ITextComponent func_145748_c_() {
            return super.func_145748_c_();
        }

        public Container createMenu(int id, PlayerInventory inventory, PlayerEntity player) {
            return new WasteIncineratorContainer(id, inventory, this, IWorldPosCallable.func_221488_a((World)this.field_145850_b, (BlockPos)this.field_174879_c), this.fields);
        }

        public int func_70302_i_() {
            return this.stacks_.size();
        }

        public boolean func_191420_l() {
            for (ItemStack stack : this.stacks_) {
                if (stack.func_190926_b()) continue;
                return false;
            }
            return true;
        }

        public ItemStack func_70301_a(int index) {
            return index >= 0 && index < this.func_70302_i_() ? (ItemStack)this.stacks_.get(index) : ItemStack.field_190927_a;
        }

        public ItemStack func_70298_a(int index, int count) {
            return ItemStackHelper.func_188382_a(this.stacks_, (int)index, (int)count);
        }

        public ItemStack func_70304_b(int index) {
            return ItemStackHelper.func_188383_a(this.stacks_, (int)index);
        }

        public void func_70299_a(int index, ItemStack stack) {
            if (stack.func_190916_E() > this.func_70297_j_()) {
                stack.func_190920_e(this.func_70297_j_());
            }
            this.stacks_.set(index, (Object)stack);
            this.func_70296_d();
        }

        public int func_70297_j_() {
            return 64;
        }

        public void func_70296_d() {
            super.func_70296_d();
        }

        public boolean func_70300_a(PlayerEntity player) {
            return this.func_174877_v().func_177951_i((Vector3i)player.func_233580_cy_()) < 36.0;
        }

        public void func_174889_b(PlayerEntity player) {
        }

        public void func_174886_c(PlayerEntity player) {
            this.func_70296_d();
        }

        public boolean func_94041_b(int index, ItemStack stack) {
            return index == 0;
        }

        public void func_174888_l() {
            this.stacks_.clear();
        }

        public int[] func_180463_a(Direction side) {
            return SIDED_INV_SLOTS;
        }

        public boolean func_180462_a(int index, ItemStack itemStackIn, Direction direction) {
            return this.func_94041_b(index, itemStackIn);
        }

        public boolean func_180461_b(int index, ItemStack stack, Direction direction) {
            return false;
        }

        public boolean canExtract() {
            return false;
        }

        public boolean canReceive() {
            return true;
        }

        public int getMaxEnergyStored() {
            return 16000;
        }

        public int getEnergyStored() {
            return this.energy_stored_;
        }

        public int extractEnergy(int maxExtract, boolean simulate) {
            return 0;
        }

        public int receiveEnergy(int maxReceive, boolean simulate) {
            if (this.energy_stored_ >= 16000) {
                return 0;
            }
            int n = Math.min(maxReceive, 16000 - this.energy_stored_);
            if (n > 256) {
                n = 256;
            }
            if (!simulate) {
                this.energy_stored_ += n;
                this.func_70296_d();
            }
            return n;
        }

        public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
            if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
                return this.item_handler_.cast();
            }
            if (capability == CapabilityEnergy.ENERGY) {
                return this.energy_handler_.cast();
            }
            return super.getCapability(capability, facing);
        }

        public void func_73660_a() {
            ItemStack first_stack;
            boolean shift;
            boolean was_processing;
            if (--this.tick_timer_ > 0) {
                return;
            }
            this.tick_timer_ = 20;
            if (this.field_145850_b.field_72995_K) {
                return;
            }
            boolean dirty = false;
            ItemStack processing_stack = (ItemStack)this.stacks_.get(15);
            boolean is_processing = was_processing = !processing_stack.func_190926_b();
            boolean new_stack_processing = false;
            if (!((ItemStack)this.stacks_.get(0)).func_190926_b() && this.transferItems(0, 1, this.func_70297_j_())) {
                dirty = true;
            }
            boolean bl = shift = !(first_stack = (ItemStack)this.stacks_.get(0)).func_190926_b();
            if (is_processing) {
                processing_stack.func_190918_g(4);
                if (processing_stack.func_190916_E() <= 0) {
                    processing_stack = ItemStack.field_190927_a;
                    is_processing = false;
                }
                this.stacks_.set(15, (Object)processing_stack);
                if (this.energy_stored_ >= energy_consumption * 20) {
                    this.energy_stored_ -= energy_consumption * 20;
                    this.tick_timer_ = 5;
                }
                dirty = true;
            }
            if (shift) {
                boolean transferred = false;
                for (int i = 14; i > 0; --i) {
                    transferred |= this.transferItems(i - 1, i, this.func_70297_j_());
                }
                if (!is_processing && !transferred) {
                    this.shiftStacks(0, 15);
                    dirty = true;
                }
            }
            if (was_processing != is_processing || new_stack_processing) {
                BlockState state;
                if (new_stack_processing) {
                    this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundEvents.field_187656_cX, SoundCategory.BLOCKS, 0.05f, 2.4f);
                }
                if ((state = this.field_145850_b.func_180495_p(this.field_174879_c)).func_177230_c() instanceof WasteIncineratorBlock) {
                    this.field_145850_b.func_180501_a(this.field_174879_c, (BlockState)state.func_206870_a((Property)WasteIncineratorBlock.LIT, (Comparable)Boolean.valueOf(is_processing)), 18);
                }
            }
            if (dirty) {
                this.func_70296_d();
            }
        }

        private ItemStack shiftStacks(int index_from, int index_to) {
            if (index_from >= index_to) {
                return ItemStack.field_190927_a;
            }
            ItemStack out_stack = ItemStack.field_190927_a;
            ItemStack stack = (ItemStack)this.stacks_.get(index_from);
            for (int i = index_from + 1; i <= index_to; ++i) {
                out_stack = (ItemStack)this.stacks_.get(i);
                this.stacks_.set(i, (Object)stack);
                stack = out_stack;
            }
            this.stacks_.set(index_from, (Object)ItemStack.field_190927_a);
            return out_stack;
        }

        private boolean transferItems(int index_from, int index_to, int count) {
            ItemStack from = (ItemStack)this.stacks_.get(index_from);
            if (from.func_190926_b()) {
                return false;
            }
            ItemStack to = (ItemStack)this.stacks_.get(index_to);
            if (from.func_190916_E() < count) {
                count = from.func_190916_E();
            }
            if (count <= 0) {
                return false;
            }
            boolean changed = true;
            if (to.func_190926_b()) {
                this.stacks_.set(index_to, (Object)from.func_77979_a(count));
            } else if (to.func_190916_E() >= to.func_77976_d()) {
                changed = false;
            } else if (Inventories.areItemStacksDifferent(from, to)) {
                changed = false;
            } else if (to.func_190916_E() + count >= to.func_77976_d()) {
                from.func_190918_g(to.func_77976_d() - to.func_190916_E());
                to.func_190920_e(to.func_77976_d());
            } else {
                from.func_190918_g(count);
                to.func_190917_f(count);
            }
            if (from.func_190926_b() && from != ItemStack.field_190927_a) {
                this.stacks_.set(index_from, (Object)ItemStack.field_190927_a);
                changed = true;
            }
            return changed;
        }

        protected static class BItemHandler
        implements IItemHandler {
            private WasteIncineratorTileEntity te;

            BItemHandler(WasteIncineratorTileEntity te) {
                this.te = te;
            }

            public int getSlots() {
                return 1;
            }

            public int getSlotLimit(int index) {
                return this.te.func_70297_j_();
            }

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                return true;
            }

            @Nonnull
            public ItemStack insertItem(int index, @Nonnull ItemStack stack, boolean simulate) {
                if (stack.func_190926_b()) {
                    return ItemStack.field_190927_a;
                }
                if (index != 0) {
                    return ItemStack.field_190927_a;
                }
                int slotno = 0;
                ItemStack slotstack = this.getStackInSlot(slotno);
                if (!slotstack.func_190926_b()) {
                    if (slotstack.func_190916_E() >= Math.min(slotstack.func_77976_d(), this.getSlotLimit(index))) {
                        return stack;
                    }
                    if (!ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)slotstack)) {
                        return stack;
                    }
                    if (!this.te.func_180462_a(slotno, stack, Direction.UP) || !this.te.func_94041_b(slotno, stack)) {
                        return stack;
                    }
                    int n = Math.min(stack.func_77976_d(), this.getSlotLimit(index)) - slotstack.func_190916_E();
                    if (stack.func_190916_E() <= n) {
                        if (!simulate) {
                            ItemStack copy = stack.func_77946_l();
                            copy.func_190917_f(slotstack.func_190916_E());
                            this.te.func_70299_a(slotno, copy);
                        }
                        return ItemStack.field_190927_a;
                    }
                    stack = stack.func_77946_l();
                    if (!simulate) {
                        ItemStack copy = stack.func_77979_a(n);
                        copy.func_190917_f(slotstack.func_190916_E());
                        this.te.func_70299_a(slotno, copy);
                        return stack;
                    }
                    stack.func_190918_g(n);
                    return stack;
                }
                if (!this.te.func_180462_a(slotno, stack, Direction.UP) || !this.te.func_94041_b(slotno, stack)) {
                    return stack;
                }
                int n = Math.min(stack.func_77976_d(), this.getSlotLimit(index));
                if (n < stack.func_190916_E()) {
                    stack = stack.func_77946_l();
                    if (!simulate) {
                        this.te.func_70299_a(slotno, stack.func_77979_a(n));
                        return stack;
                    }
                    stack.func_190918_g(n);
                    return stack;
                }
                if (!simulate) {
                    this.te.func_70299_a(slotno, stack);
                }
                return ItemStack.field_190927_a;
            }

            @Nonnull
            public ItemStack extractItem(int index, int amount, boolean simulate) {
                return ItemStack.field_190927_a;
            }

            @Nonnull
            public ItemStack getStackInSlot(int index) {
                return this.te.func_70301_a(index);
            }
        }
    }

    public static class WasteIncineratorBlock
    extends DecorBlock.Normal
    implements IDecorBlock {
        public static final BooleanProperty LIT = EdFurnace.FurnaceBlock.LIT;

        public WasteIncineratorBlock(long config, AbstractBlock.Properties builder, AxisAlignedBB unrotatedAABB) {
            super(config, builder, unrotatedAABB);
        }

        protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
            super.func_206840_a(builder);
            builder.func_206894_a(new Property[]{LIT});
        }

        @Override
        @Nullable
        public BlockState func_196258_a(BlockItemUseContext context) {
            return (BlockState)super.func_196258_a(context).func_206870_a((Property)LIT, (Comparable)Boolean.valueOf(false));
        }

        public boolean func_149740_M(BlockState state) {
            return true;
        }

        public int func_180641_l(BlockState blockState, World world, BlockPos pos) {
            return Container.func_178144_a((TileEntity)world.func_175625_s(pos));
        }

        public boolean hasTileEntity(BlockState state) {
            return true;
        }

        @Nullable
        public TileEntity createTileEntity(BlockState state, IBlockReader world) {
            return new WasteIncineratorTileEntity();
        }

        public void func_180633_a(World world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
            if (world.field_72995_K) {
                return;
            }
            if (!stack.func_77942_o() || !stack.func_77978_p().func_74764_b("tedata")) {
                return;
            }
            CompoundNBT te_nbt = stack.func_77978_p().func_74775_l("tedata");
            if (te_nbt.isEmpty()) {
                return;
            }
            TileEntity te = world.func_175625_s(pos);
            if (!(te instanceof WasteIncineratorTileEntity)) {
                return;
            }
            ((WasteIncineratorTileEntity)te).readnbt(te_nbt);
            ((WasteIncineratorTileEntity)te).func_70296_d();
        }

        @Override
        public boolean hasDynamicDropList() {
            return true;
        }

        @Override
        public List<ItemStack> dropList(BlockState state, World world, BlockPos pos, TileEntity te, boolean explosion) {
            ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
            if (world.field_72995_K) {
                return stacks;
            }
            if (!(te instanceof WasteIncineratorTileEntity)) {
                return stacks;
            }
            if (!explosion) {
                ItemStack stack = new ItemStack((IItemProvider)this, 1);
                CompoundNBT te_nbt = ((WasteIncineratorTileEntity)te).reset_getnbt();
                if (!te_nbt.isEmpty()) {
                    CompoundNBT nbt = new CompoundNBT();
                    nbt.func_218657_a("tedata", (INBT)te_nbt);
                    stack.func_77982_d(nbt);
                }
                stacks.add(stack);
            } else {
                for (ItemStack stack : ((WasteIncineratorTileEntity)te).stacks_) {
                    stacks.add(stack);
                }
                ((WasteIncineratorTileEntity)te).reset_getnbt();
            }
            return stacks;
        }

        @Override
        public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult rayTraceResult) {
            if (world.field_72995_K) {
                return ActionResultType.SUCCESS;
            }
            TileEntity te = world.func_175625_s(pos);
            if (!(te instanceof WasteIncineratorTileEntity)) {
                return ActionResultType.FAIL;
            }
            if (!(player instanceof ServerPlayerEntity) && !(player instanceof FakePlayer)) {
                return ActionResultType.FAIL;
            }
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)((INamedContainerProvider)te));
            return ActionResultType.SUCCESS;
        }

        @OnlyIn(value=Dist.CLIENT)
        public void func_180655_c(BlockState state, World world, BlockPos pos, Random rnd) {
            if (state.func_177230_c() != this || !((Boolean)state.func_177229_b((Property)LIT)).booleanValue()) {
                return;
            }
            double rv = rnd.nextDouble();
            if (rv > 0.5) {
                return;
            }
            double x = 0.5 + (double)pos.func_177958_n();
            double y = 0.5 + (double)pos.func_177956_o();
            double z = 0.5 + (double)pos.func_177952_p();
            double xr = rnd.nextDouble() * 0.4 - 0.2;
            double yr = rnd.nextDouble() * 0.5;
            double zr = rnd.nextDouble() * 0.4 - 0.2;
            world.func_195594_a((IParticleData)ParticleTypes.field_197601_L, x + xr, y + yr, z + zr, 0.0, 0.0, 0.0);
        }
    }
}

