/*
 * Decompiled with CFR 0.152.
 */
package wile.engineersdecor.libmc.detail;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.UUID;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.client.util.InputMappings;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.SharedConstants;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.ModList;
import org.apache.logging.log4j.Logger;
import wile.engineersdecor.libmc.detail.SidedProxy;

public class Auxiliaries {
    private static String modid;
    private static Logger logger;
    private static Supplier<CompoundNBT> server_config_supplier;

    public static void init(String modid, Logger logger, Supplier<CompoundNBT> server_config_supplier) {
        Auxiliaries.modid = modid;
        Auxiliaries.logger = logger;
        Auxiliaries.server_config_supplier = server_config_supplier;
    }

    public static String modid() {
        return modid;
    }

    public static Logger logger() {
        return logger;
    }

    public static final boolean isModLoaded(String registry_name) {
        return ModList.get().isLoaded(registry_name);
    }

    public static final boolean isDevelopmentMode() {
        return SharedConstants.field_206244_b;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static final boolean isShiftDown() {
        return InputMappings.func_216506_a((long)SidedProxy.mc().func_228018_at_().func_198092_i(), (int)340) || InputMappings.func_216506_a((long)SidedProxy.mc().func_228018_at_().func_198092_i(), (int)344);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static final boolean isCtrlDown() {
        return InputMappings.func_216506_a((long)SidedProxy.mc().func_228018_at_().func_198092_i(), (int)341) || InputMappings.func_216506_a((long)SidedProxy.mc().func_228018_at_().func_198092_i(), (int)345);
    }

    public static final void logInfo(String msg) {
        logger.info(msg);
    }

    public static final void logWarn(String msg) {
        logger.warn(msg);
    }

    public static final void logError(String msg) {
        logger.error(msg);
    }

    public static TranslationTextComponent localizable(String modtrkey, @Nullable TextFormatting color, Object ... args) {
        TranslationTextComponent tr = new TranslationTextComponent(modtrkey.startsWith("block.") || modtrkey.startsWith("item.") ? modtrkey : modid + "." + modtrkey, args);
        if (color != null) {
            tr.func_240701_a_(new TextFormatting[]{color});
        }
        return tr;
    }

    public static TranslationTextComponent localizable(String modtrkey) {
        return Auxiliaries.localizable(modtrkey, null, new Object[0]);
    }

    public static TranslationTextComponent localizable_block_key(String blocksubkey) {
        return new TranslationTextComponent("block." + modid + "." + blocksubkey);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static String localize(String translationKey, Object ... args) {
        TranslationTextComponent tr = new TranslationTextComponent(translationKey, args);
        tr.func_240701_a_(new TextFormatting[]{TextFormatting.RESET});
        String ft = tr.getString();
        if (ft.contains("${")) {
            Pattern pt = Pattern.compile("\\$\\{([^}]+)\\}");
            Matcher mt = pt.matcher(ft);
            StringBuffer sb = new StringBuffer();
            while (mt.find()) {
                String m = mt.group(1);
                if (m.contains("?")) {
                    String[] kv = m.split("\\?", 2);
                    String key = kv[0].trim();
                    boolean not = key.startsWith("!");
                    if (not) {
                        key = key.replaceFirst("!", "");
                    }
                    m = kv[1].trim();
                    if (!server_config_supplier.get().func_74764_b(key)) {
                        m = "";
                    } else {
                        boolean r = server_config_supplier.get().func_74767_n(key);
                        if (not) {
                            boolean bl = r = !r;
                        }
                        if (!r) {
                            m = "";
                        }
                    }
                }
                mt.appendReplacement(sb, new TranslationTextComponent(m).getString().trim());
            }
            mt.appendTail(sb);
            return sb.toString();
        }
        return ft;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static boolean hasTranslation(String key) {
        return I18n.func_188566_a((String)key);
    }

    public static void playerChatMessage(PlayerEntity player, String message) {
        String s = message.trim();
        if (!s.isEmpty()) {
            player.func_145747_a((ITextComponent)new TranslationTextComponent(s), new UUID(0L, 0L));
        }
    }

    public static final AxisAlignedBB getPixeledAABB(double x0, double y0, double z0, double x1, double y1, double z1) {
        return new AxisAlignedBB(x0 / 16.0, y0 / 16.0, z0 / 16.0, x1 / 16.0, y1 / 16.0, z1 / 16.0);
    }

    public static final AxisAlignedBB getRotatedAABB(AxisAlignedBB bb, Direction new_facing, boolean horizontal_rotation) {
        if (!horizontal_rotation) {
            switch (new_facing.func_176745_a()) {
                case 0: {
                    return new AxisAlignedBB(1.0 - bb.field_72336_d, bb.field_72339_c, bb.field_72338_b, 1.0 - bb.field_72340_a, bb.field_72334_f, bb.field_72337_e);
                }
                case 1: {
                    return new AxisAlignedBB(1.0 - bb.field_72336_d, 1.0 - bb.field_72334_f, 1.0 - bb.field_72337_e, 1.0 - bb.field_72340_a, 1.0 - bb.field_72339_c, 1.0 - bb.field_72338_b);
                }
                case 2: {
                    return new AxisAlignedBB(bb.field_72340_a, bb.field_72338_b, bb.field_72339_c, bb.field_72336_d, bb.field_72337_e, bb.field_72334_f);
                }
                case 3: {
                    return new AxisAlignedBB(1.0 - bb.field_72336_d, bb.field_72338_b, 1.0 - bb.field_72334_f, 1.0 - bb.field_72340_a, bb.field_72337_e, 1.0 - bb.field_72339_c);
                }
                case 4: {
                    return new AxisAlignedBB(bb.field_72339_c, bb.field_72338_b, 1.0 - bb.field_72336_d, bb.field_72334_f, bb.field_72337_e, 1.0 - bb.field_72340_a);
                }
                case 5: {
                    return new AxisAlignedBB(1.0 - bb.field_72334_f, bb.field_72338_b, bb.field_72340_a, 1.0 - bb.field_72339_c, bb.field_72337_e, bb.field_72336_d);
                }
            }
        } else {
            switch (new_facing.func_176745_a()) {
                case 0: {
                    return new AxisAlignedBB(bb.field_72340_a, bb.field_72338_b, bb.field_72339_c, bb.field_72336_d, bb.field_72337_e, bb.field_72334_f);
                }
                case 1: {
                    return new AxisAlignedBB(bb.field_72340_a, bb.field_72338_b, bb.field_72339_c, bb.field_72336_d, bb.field_72337_e, bb.field_72334_f);
                }
                case 2: {
                    return new AxisAlignedBB(bb.field_72340_a, bb.field_72338_b, bb.field_72339_c, bb.field_72336_d, bb.field_72337_e, bb.field_72334_f);
                }
                case 3: {
                    return new AxisAlignedBB(1.0 - bb.field_72336_d, bb.field_72338_b, 1.0 - bb.field_72334_f, 1.0 - bb.field_72340_a, bb.field_72337_e, 1.0 - bb.field_72339_c);
                }
                case 4: {
                    return new AxisAlignedBB(bb.field_72339_c, bb.field_72338_b, 1.0 - bb.field_72336_d, bb.field_72334_f, bb.field_72337_e, 1.0 - bb.field_72340_a);
                }
                case 5: {
                    return new AxisAlignedBB(1.0 - bb.field_72334_f, bb.field_72338_b, bb.field_72340_a, 1.0 - bb.field_72339_c, bb.field_72337_e, bb.field_72336_d);
                }
            }
        }
        return bb;
    }

    public static final AxisAlignedBB[] getRotatedAABB(AxisAlignedBB[] bbs, Direction new_facing, boolean horizontal_rotation) {
        AxisAlignedBB[] transformed = new AxisAlignedBB[bbs.length];
        for (int i = 0; i < bbs.length; ++i) {
            transformed[i] = Auxiliaries.getRotatedAABB(bbs[i], new_facing, horizontal_rotation);
        }
        return transformed;
    }

    public static final AxisAlignedBB getYRotatedAABB(AxisAlignedBB bb, int clockwise_90deg_steps) {
        Direction[] direction_map = new Direction[]{Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST};
        return Auxiliaries.getRotatedAABB(bb, direction_map[clockwise_90deg_steps + 4096 & 3], true);
    }

    public static final AxisAlignedBB[] getYRotatedAABB(AxisAlignedBB[] bbs, int clockwise_90deg_steps) {
        AxisAlignedBB[] transformed = new AxisAlignedBB[bbs.length];
        for (int i = 0; i < bbs.length; ++i) {
            transformed[i] = Auxiliaries.getYRotatedAABB(bbs[i], clockwise_90deg_steps);
        }
        return transformed;
    }

    public static final AxisAlignedBB getMirroredAABB(AxisAlignedBB bb, Direction.Axis axis) {
        switch (axis) {
            case X: {
                return new AxisAlignedBB(1.0 - bb.field_72336_d, bb.field_72338_b, bb.field_72339_c, 1.0 - bb.field_72340_a, bb.field_72337_e, bb.field_72334_f);
            }
            case Y: {
                return new AxisAlignedBB(bb.field_72340_a, 1.0 - bb.field_72337_e, bb.field_72339_c, bb.field_72336_d, 1.0 - bb.field_72338_b, bb.field_72334_f);
            }
            case Z: {
                return new AxisAlignedBB(bb.field_72340_a, bb.field_72338_b, 1.0 - bb.field_72334_f, bb.field_72336_d, bb.field_72337_e, 1.0 - bb.field_72339_c);
            }
        }
        return bb;
    }

    public static final AxisAlignedBB[] getMirroredAABB(AxisAlignedBB[] bbs, Direction.Axis axis) {
        AxisAlignedBB[] transformed = new AxisAlignedBB[bbs.length];
        for (int i = 0; i < bbs.length; ++i) {
            transformed[i] = Auxiliaries.getMirroredAABB(bbs[i], axis);
        }
        return transformed;
    }

    public static final VoxelShape getUnionShape(AxisAlignedBB[] ... aabb_list) {
        VoxelShape shape = VoxelShapes.func_197880_a();
        AxisAlignedBB[][] axisAlignedBBArray = aabb_list;
        int n = axisAlignedBBArray.length;
        for (int i = 0; i < n; ++i) {
            AxisAlignedBB[] aabbs;
            for (AxisAlignedBB aabb : aabbs = axisAlignedBBArray[i]) {
                shape = VoxelShapes.func_197882_b((VoxelShape)shape, (VoxelShape)VoxelShapes.func_197881_a((AxisAlignedBB)aabb), (IBooleanFunction)IBooleanFunction.field_223244_o_);
            }
        }
        return shape;
    }

    public static String loadResourceText(InputStream is) {
        try {
            if (is == null) {
                return "";
            }
            BufferedReader br = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));
            return br.lines().collect(Collectors.joining("\n"));
        }
        catch (Throwable e) {
            return "";
        }
    }

    public static String loadResourceText(String path) {
        return Auxiliaries.loadResourceText(Auxiliaries.class.getResourceAsStream(path));
    }

    public static void logGitVersion(String mod_name) {
        try {
            String version = Auxiliaries.loadResourceText("/.gitversion-" + modid).trim();
            Auxiliaries.logInfo(mod_name + (version.isEmpty() ? " (dev build)" : " GIT id #" + version) + ".");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    static {
        server_config_supplier = () -> new CompoundNBT();
    }

    public static final class Tooltip {
        @OnlyIn(value=Dist.CLIENT)
        public static boolean extendedTipCondition() {
            return Auxiliaries.isShiftDown();
        }

        @OnlyIn(value=Dist.CLIENT)
        public static boolean helpCondition() {
            return Auxiliaries.isShiftDown() && Auxiliaries.isCtrlDown();
        }

        @OnlyIn(value=Dist.CLIENT)
        public static boolean addInformation(@Nullable String advancedTooltipTranslationKey, @Nullable String helpTranslationKey, List<ITextComponent> tooltip, ITooltipFlag flag, boolean addAdvancedTooltipHints) {
            boolean tip_available;
            boolean help_available = helpTranslationKey != null && Auxiliaries.hasTranslation(helpTranslationKey + ".help");
            boolean bl = tip_available = advancedTooltipTranslationKey != null && Auxiliaries.hasTranslation(helpTranslationKey + ".tip");
            if (!help_available && !tip_available) {
                return false;
            }
            if (Tooltip.helpCondition()) {
                if (!help_available) {
                    return false;
                }
                String s = Auxiliaries.localize(helpTranslationKey + ".help", new Object[0]);
                if (s.isEmpty()) {
                    return false;
                }
                tooltip.add((ITextComponent)new StringTextComponent(s));
                return true;
            }
            if (Tooltip.extendedTipCondition()) {
                if (!tip_available) {
                    return false;
                }
                String s = Auxiliaries.localize(advancedTooltipTranslationKey + ".tip", new Object[0]);
                if (s.isEmpty()) {
                    return false;
                }
                tooltip.add((ITextComponent)new StringTextComponent(s));
                return true;
            }
            if (addAdvancedTooltipHints) {
                String s = "";
                if (tip_available) {
                    s = s + Auxiliaries.localize(modid + ".tooltip.hint.extended", new Object[0]) + (help_available ? " " : "");
                }
                if (help_available) {
                    s = s + Auxiliaries.localize(modid + ".tooltip.hint.help", new Object[0]);
                }
                tooltip.add((ITextComponent)new StringTextComponent(s));
            }
            return false;
        }

        @OnlyIn(value=Dist.CLIENT)
        public static boolean addInformation(ItemStack stack, @Nullable IBlockReader world, List<ITextComponent> tooltip, ITooltipFlag flag, boolean addAdvancedTooltipHints) {
            return Tooltip.addInformation(stack.func_77977_a(), stack.func_77977_a(), tooltip, flag, addAdvancedTooltipHints);
        }
    }

    public static interface IExperimentalFeature {
    }
}

