/*
 * Decompiled with CFR 0.152.
 */
package wile.engineersdecor.libmc.detail;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.tags.ITag;
import net.minecraft.tags.TagCollectionManager;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import org.apache.logging.log4j.Logger;

public class OptionalRecipeCondition
implements ICondition {
    private static ResourceLocation NAME;
    private final List<ResourceLocation> all_required;
    private final List<ResourceLocation> any_missing;
    private final List<ResourceLocation> all_required_tags;
    private final List<ResourceLocation> any_missing_tags;
    @Nullable
    private final ResourceLocation result;
    private final boolean result_is_tag;
    private final boolean experimental;
    private static boolean with_experimental;
    private static boolean without_recipes;
    private static Predicate<Block> block_optouts;
    private static Predicate<Item> item_optouts;

    public static void init(String modid, Logger logger) {
        NAME = new ResourceLocation(modid, "optional");
    }

    public static void on_config(boolean enable_experimental, boolean disable_all_recipes, Predicate<Block> block_optout_provider, Predicate<Item> item_optout_provider) {
        with_experimental = enable_experimental;
        without_recipes = disable_all_recipes;
        block_optouts = block_optout_provider;
        item_optouts = item_optout_provider;
    }

    public OptionalRecipeCondition(ResourceLocation result, List<ResourceLocation> required, List<ResourceLocation> missing, List<ResourceLocation> required_tags, List<ResourceLocation> missing_tags, boolean isexperimental, boolean result_is_tag) {
        this.all_required = required;
        this.any_missing = missing;
        this.all_required_tags = required_tags;
        this.any_missing_tags = missing_tags;
        this.result = result;
        this.result_is_tag = result_is_tag;
        this.experimental = isexperimental;
    }

    public ResourceLocation getID() {
        return NAME;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Optional recipe, all-required: [");
        for (ResourceLocation e : this.all_required) {
            sb.append(e.toString()).append(",");
        }
        for (ResourceLocation e : this.all_required_tags) {
            sb.append("#").append(e.toString()).append(",");
        }
        sb.delete(sb.length() - 1, sb.length()).append("], any-missing: [");
        for (ResourceLocation e : this.any_missing) {
            sb.append(e.toString()).append(",");
        }
        for (ResourceLocation e : this.any_missing_tags) {
            sb.append("#").append(e.toString()).append(",");
        }
        sb.delete(sb.length() - 1, sb.length()).append("]");
        if (this.experimental) {
            sb.append(" EXPERIMENTAL");
        }
        return sb.toString();
    }

    public boolean test() {
        if (without_recipes) {
            return false;
        }
        if (this.experimental && !with_experimental) {
            return false;
        }
        IForgeRegistry item_registry = ForgeRegistries.ITEMS;
        Map item_tags = TagCollectionManager.func_232928_e_().func_232925_b_().func_200039_c();
        if (this.result != null) {
            boolean item_registered = item_registry.containsKey(this.result);
            if (!item_registered) {
                return false;
            }
            if (item_registered && item_optouts.test((Item)item_registry.getValue(this.result))) {
                return false;
            }
            if (ForgeRegistries.BLOCKS.containsKey(this.result) && block_optouts.test((Block)ForgeRegistries.BLOCKS.getValue(this.result))) {
                return false;
            }
        }
        if (!this.all_required.isEmpty()) {
            for (ResourceLocation rl : this.all_required) {
                if (item_registry.containsKey(rl)) continue;
                return false;
            }
        }
        if (!this.all_required_tags.isEmpty()) {
            for (ResourceLocation rl : this.all_required_tags) {
                if (!item_tags.containsKey(rl)) {
                    return false;
                }
                if (!((ITag)item_tags.get(rl)).func_230236_b_().isEmpty()) continue;
                return false;
            }
        }
        if (!this.any_missing.isEmpty()) {
            for (ResourceLocation rl : this.any_missing) {
                if (item_registry.containsKey(rl)) continue;
                return true;
            }
            return false;
        }
        if (!this.any_missing_tags.isEmpty()) {
            for (ResourceLocation rl : this.any_missing_tags) {
                if (!item_tags.containsKey(rl)) {
                    return true;
                }
                if (!((ITag)item_tags.get(rl)).func_230236_b_().isEmpty()) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    static {
        with_experimental = false;
        without_recipes = false;
        block_optouts = block -> false;
        item_optouts = item -> false;
    }

    public static class Serializer
    implements IConditionSerializer<OptionalRecipeCondition> {
        public static final Serializer INSTANCE = new Serializer();

        public ResourceLocation getID() {
            return NAME;
        }

        public void write(JsonObject json, OptionalRecipeCondition condition) {
            JsonArray required = new JsonArray();
            JsonArray missing = new JsonArray();
            for (ResourceLocation e : condition.all_required) {
                required.add(e.toString());
            }
            for (ResourceLocation e : condition.any_missing) {
                missing.add(e.toString());
            }
            json.add("required", (JsonElement)required);
            json.add("missing", (JsonElement)missing);
            if (condition.result != null) {
                json.addProperty("result", (condition.result_is_tag ? "#" : "") + condition.result.toString());
            }
        }

        public OptionalRecipeCondition read(JsonObject json) {
            String s;
            ArrayList<ResourceLocation> required = new ArrayList<ResourceLocation>();
            ArrayList<ResourceLocation> missing = new ArrayList<ResourceLocation>();
            ArrayList<ResourceLocation> required_tags = new ArrayList<ResourceLocation>();
            ArrayList<ResourceLocation> missing_tags = new ArrayList<ResourceLocation>();
            ResourceLocation result = null;
            boolean experimental = false;
            boolean result_is_tag = false;
            if (json.has("result")) {
                String s2 = json.get("result").getAsString();
                if (s2.startsWith("#")) {
                    result = new ResourceLocation(s2.substring(1));
                    result_is_tag = true;
                } else {
                    result = new ResourceLocation(s2);
                }
            }
            if (json.has("required")) {
                for (JsonElement e : JSONUtils.func_151214_t((JsonObject)json, (String)"required")) {
                    s = e.getAsString();
                    if (s.startsWith("#")) {
                        required_tags.add(new ResourceLocation(s.substring(1)));
                        continue;
                    }
                    required.add(new ResourceLocation(s));
                }
            }
            if (json.has("missing")) {
                for (JsonElement e : JSONUtils.func_151214_t((JsonObject)json, (String)"missing")) {
                    s = e.getAsString();
                    if (s.startsWith("#")) {
                        missing_tags.add(new ResourceLocation(s.substring(1)));
                        continue;
                    }
                    missing.add(new ResourceLocation(s));
                }
            }
            if (json.has("experimental")) {
                experimental = json.get("experimental").getAsBoolean();
            }
            return new OptionalRecipeCondition(result, required, missing, required_tags, missing_tags, experimental, result_is_tag);
        }
    }
}

