/*
 * Decompiled with CFR 0.152.
 */
package wile.engineersdecor.libmc.detail;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.inventory.container.Container;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import wile.engineersdecor.libmc.detail.Auxiliaries;

@OnlyIn(value=Dist.CLIENT)
public class TooltipDisplay {
    private static long default_delay = 1500L;
    private static int default_max_deviation = 1;
    private List<TipRange> ranges = new ArrayList<TipRange>();
    private long delay = default_delay;
    private int max_deviation = default_max_deviation;
    private int x_last;
    private int y_last;
    private long t = System.currentTimeMillis();
    private static boolean had_render_exception = false;

    public static void config(long delay, int max_deviation) {
        default_delay = MathHelper.func_226163_a_((long)delay, (long)500L, (long)5000L);
        default_max_deviation = MathHelper.func_76125_a((int)max_deviation, (int)1, (int)5);
    }

    public void init(List<TipRange> ranges, long delay_ms, int max_deviation_xy) {
        this.ranges = ranges;
        this.delay = delay_ms;
        this.max_deviation = max_deviation_xy;
        this.t = System.currentTimeMillis();
        this.y_last = 0;
        this.x_last = 0;
    }

    public void init(List<TipRange> ranges) {
        this.init(ranges, default_delay, default_max_deviation);
    }

    public void init(TipRange ... ranges) {
        this.init(Arrays.asList(ranges), default_delay, default_max_deviation);
    }

    public void resetTimer() {
        this.t = System.currentTimeMillis();
    }

    public <T extends Container> boolean render(MatrixStack mx, ContainerScreen<T> gui, int x, int y) {
        if (had_render_exception) {
            return false;
        }
        if (Math.abs(x - this.x_last) > this.max_deviation || Math.abs(y - this.y_last) > this.max_deviation) {
            this.x_last = x;
            this.y_last = y;
            this.resetTimer();
            return false;
        }
        if (Math.abs(System.currentTimeMillis() - this.t) < this.delay) {
            return false;
        }
        if (this.ranges.stream().noneMatch(tip -> {
            if (x < tip.x0 || x > tip.x1 || y < tip.y0 || y > tip.y1) {
                return false;
            }
            String text = tip.text.getString();
            if (!text.isEmpty() && !text.startsWith("block.")) {
                try {
                    gui.renderToolTip(mx, Collections.singletonList(tip.text), x, y, Minecraft.func_71410_x().field_71466_p);
                }
                catch (Exception ex) {
                    had_render_exception = true;
                    Auxiliaries.logError("Tooltip rendering disabled due to exception: '" + ex.getMessage() + "'");
                    return false;
                }
            }
            return true;
        })) {
            this.resetTimer();
            return false;
        }
        return true;
    }

    public static class TipRange {
        public final int x0;
        public final int y0;
        public final int x1;
        public final int y1;
        public final ITextComponent text;

        public TipRange(int x, int y, int w, int h, ITextComponent text) {
            this.text = text;
            this.x0 = x;
            this.y0 = y;
            this.x1 = this.x0 + w - 1;
            this.y1 = this.y0 + h - 1;
        }
    }
}

