/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.server.command;

import com.google.gson.JsonObject;
import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_2172;
import net.minecraft.class_2314;
import net.minecraft.class_2540;
import net.minecraft.class_2588;

public class EnumArgument<T extends Enum<T>>
implements ArgumentType<T> {
    private static final Dynamic2CommandExceptionType INVALID_ENUM = new Dynamic2CommandExceptionType((found, constants) -> new class_2588("commands.forge.arguments.enum.invalid", new Object[]{constants, found}));
    private final Class<T> enumClass;

    private EnumArgument(Class<T> enumClass) {
        this.enumClass = enumClass;
    }

    public static <R extends Enum<R>> EnumArgument<R> enumArgument(Class<R> enumClass) {
        return new EnumArgument<R>(enumClass);
    }

    public T parse(StringReader reader) throws CommandSyntaxException {
        String name = reader.readUnquotedString();
        try {
            return Enum.valueOf(this.enumClass, name);
        }
        catch (IllegalArgumentException e) {
            throw INVALID_ENUM.createWithContext((ImmutableStringReader)reader, (Object)name, (Object)Arrays.toString(this.enumClass.getEnumConstants()));
        }
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        return class_2172.method_9264(Stream.of((Enum[])this.enumClass.getEnumConstants()).map(Object::toString), (SuggestionsBuilder)builder);
    }

    public Collection<String> getExamples() {
        return Stream.of((Enum[])this.enumClass.getEnumConstants()).map(Object::toString).collect(Collectors.toList());
    }

    public static class Serializer
    implements class_2314<EnumArgument<?>> {
        public void serializeToNetwork(EnumArgument<?> argument, class_2540 buffer) {
            buffer.method_10814(((EnumArgument)argument).enumClass.getName());
        }

        public EnumArgument<?> deserializeFromNetwork(class_2540 buffer) {
            try {
                String name = buffer.method_19772();
                return new EnumArgument(Class.forName(name));
            }
            catch (ClassNotFoundException e) {
                return null;
            }
        }

        public void serializeToJson(EnumArgument<?> argument, JsonObject json) {
            json.addProperty("enum", ((EnumArgument)argument).enumClass.getName());
        }
    }
}

