/*
 * Decompiled with CFR 0.152.
 */
package fuzs.forgeconfigapiport.impl.integration.configured;

import com.electronwill.nightconfig.core.AbstractConfig;
import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.UnmodifiableConfig;
import com.electronwill.nightconfig.core.file.FileConfig;
import com.google.common.collect.ImmutableList;
import fuzs.forgeconfigapiport.impl.util.ReflectionHelperV2;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.tuple.Pair;

public class ForgeConfigHelper {
    public static List<Pair<ForgeConfigSpec.ConfigValue<?>, ForgeConfigSpec.ValueSpec>> gatherAllForgeConfigValues(UnmodifiableConfig config, ForgeConfigSpec spec) {
        ArrayList values = new ArrayList();
        ForgeConfigHelper.gatherValuesFromForgeConfig(config, spec, values);
        return ImmutableList.copyOf(values);
    }

    private static void gatherValuesFromForgeConfig(UnmodifiableConfig config, ForgeConfigSpec spec, List<Pair<ForgeConfigSpec.ConfigValue<?>, ForgeConfigSpec.ValueSpec>> values) {
        config.valueMap().forEach((s, o) -> {
            if (o instanceof AbstractConfig) {
                ForgeConfigHelper.gatherValuesFromForgeConfig((UnmodifiableConfig)o, spec, values);
            } else if (o instanceof ForgeConfigSpec.ConfigValue) {
                ForgeConfigSpec.ConfigValue configValue = (ForgeConfigSpec.ConfigValue)o;
                ForgeConfigSpec.ValueSpec valueSpec = (ForgeConfigSpec.ValueSpec)spec.getRaw(configValue.getPath());
                values.add(Pair.of((Object)configValue, (Object)valueSpec));
            }
        });
    }

    public static void setForgeConfigData(ModConfig config, @Nullable CommentedConfig configData) {
        ReflectionHelperV2.invokeMethod(ModConfig.class, "setConfigData", new Class[]{CommentedConfig.class}, config, new Object[]{configData});
        if (configData instanceof FileConfig) {
            config.save();
        }
    }

    public static List<Pair<ForgeConfigSpec.ConfigValue<?>, ForgeConfigSpec.ValueSpec>> gatherAllForgeConfigValues(ModConfig config) {
        return ForgeConfigHelper.gatherAllForgeConfigValues(((ForgeConfigSpec)config.getSpec()).getValues(), (ForgeConfigSpec)config.getSpec());
    }
}

