/*
 * Decompiled with CFR 0.152.
 */
package fuzs.hangglider;

import fuzs.hangglider.HangGlider;
import fuzs.hangglider.capability.GlidingCapability;
import fuzs.hangglider.data.ModItemModelProvider;
import fuzs.hangglider.data.ModLanguageProvider;
import fuzs.hangglider.data.ModRecipeProvider;
import fuzs.hangglider.handler.PlayerGlidingHandler;
import fuzs.hangglider.init.ModRegistry;
import fuzs.puzzleslib.capability.ForgeCapabilityController;
import fuzs.puzzleslib.core.CommonFactories;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLConstructModEvent;

@Mod(value="hangglider")
@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class HangGliderForge {
    @SubscribeEvent
    public static void onConstructMod(FMLConstructModEvent evt) {
        CommonFactories.INSTANCE.modConstructor("hangglider").accept(new HangGlider());
        HangGliderForge.registerCapabilities();
        HangGliderForge.registerHandlers();
    }

    private static void registerCapabilities() {
        ForgeCapabilityController.setCapabilityToken(ModRegistry.GLIDING_CAPABILITY, (CapabilityToken)new CapabilityToken<GlidingCapability>(){});
    }

    private static void registerHandlers() {
        MinecraftForge.EVENT_BUS.addListener(evt -> {
            if (evt.phase == TickEvent.Phase.END) {
                PlayerGlidingHandler.onPlayerTick$End(evt.player);
            }
        });
    }

    @SubscribeEvent
    public static void onGatherData(GatherDataEvent evt) {
        DataGenerator generator = evt.getGenerator();
        ExistingFileHelper existingFileHelper = evt.getExistingFileHelper();
        generator.m_236039_(true, (DataProvider)new ModRecipeProvider(generator));
        generator.m_236039_(true, (DataProvider)new ModLanguageProvider(generator, "hangglider"));
        generator.m_236039_(true, (DataProvider)new ModItemModelProvider(generator, "hangglider", existingFileHelper));
    }
}

