/*
 * Decompiled with CFR 0.152.
 */
package fuzs.hangglider.client;

import fuzs.hangglider.HangGlider;
import fuzs.hangglider.client.handler.ElytraEquippedHandler;
import fuzs.hangglider.client.init.ModClientRegistry;
import fuzs.hangglider.client.model.GliderModel;
import fuzs.hangglider.client.renderer.entity.layers.GliderLayer;
import fuzs.hangglider.helper.PlayerGlidingHelper;
import fuzs.hangglider.init.ModRegistry;
import fuzs.puzzleslib.client.core.ClientModConstructor;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.ItemLike;

public class HangGliderClient
implements ClientModConstructor {
    public void onRegisterLayerDefinitions(ClientModConstructor.LayerDefinitionsContext context) {
        context.registerLayerDefinition(ModClientRegistry.GLIDER, GliderModel::createLayer);
    }

    public void onRegisterLivingEntityRenderLayers(ClientModConstructor.LivingEntityRenderLayersContext context) {
        context.registerRenderLayerV2(EntityType.f_20532_, (renderLayerParent, context1) -> new GliderLayer((RenderLayerParent<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>>)renderLayerParent, context1.m_174027_()));
    }

    public void onRegisterItemModelProperties(ClientModConstructor.ItemModelPropertiesContext context) {
        context.registerItemProperty(HangGlider.id("deployed"), (itemStack, clientLevel, livingEntity, i) -> {
            if (!(livingEntity instanceof Player)) return 0.0f;
            Player player = (Player)livingEntity;
            if (!PlayerGlidingHelper.isValidGlider(itemStack)) return 0.0f;
            if (!PlayerGlidingHelper.isGliderDeployed(player)) return 0.0f;
            if (PlayerGlidingHelper.getGliderInHand(player) != itemStack) return 0.0f;
            return 1.0f;
        }, new ItemLike[]{(ItemLike)ModRegistry.HANG_GLIDER_ITEM.get(), (ItemLike)ModRegistry.REINFORCED_HANG_GLIDER_ITEM.get()});
        context.registerItemProperty(HangGlider.id("broken"), (itemStack, clientLevel, livingEntity, i) -> !PlayerGlidingHelper.isValidGlider(itemStack) ? 1.0f : 0.0f, new ItemLike[]{(ItemLike)ModRegistry.HANG_GLIDER_ITEM.get(), (ItemLike)ModRegistry.REINFORCED_HANG_GLIDER_ITEM.get()});
    }

    public void onRegisterAtlasSprites(ClientModConstructor.AtlasSpritesContext context) {
        context.registerAtlasSprite(InventoryMenu.f_39692_, ElytraEquippedHandler.CROSS_TEXTURE_LOCATION);
    }
}

