/*
 * Decompiled with CFR 0.152.
 */
package fuzs.hangglider.client;

import fuzs.hangglider.HangGlider;
import fuzs.hangglider.client.handler.ElytraEquippedHandler;
import fuzs.hangglider.client.handler.FovModifierHandler;
import fuzs.hangglider.client.handler.GlidingCameraHandler;
import fuzs.hangglider.client.init.ModClientRegistry;
import fuzs.hangglider.client.model.GliderModel;
import fuzs.hangglider.client.renderer.entity.layers.GliderLayer;
import fuzs.hangglider.helper.PlayerGlidingHelper;
import fuzs.hangglider.init.ModRegistry;
import fuzs.puzzleslib.api.client.core.v1.ClientModConstructor;
import fuzs.puzzleslib.api.client.core.v1.context.BuildCreativeModeTabContentsContext;
import fuzs.puzzleslib.api.client.core.v1.context.ItemModelPropertiesContext;
import fuzs.puzzleslib.api.client.core.v1.context.LayerDefinitionsContext;
import fuzs.puzzleslib.api.client.core.v1.context.LivingEntityRenderLayersContext;
import fuzs.puzzleslib.api.client.event.v1.ClientTickEvents;
import fuzs.puzzleslib.api.client.event.v1.ComputeFovModifierCallback;
import fuzs.puzzleslib.api.client.event.v1.RenderGuiCallback;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ItemLike;

public class HangGliderClient
implements ClientModConstructor {
    public void onConstructMod() {
        HangGliderClient.registerHandlers();
    }

    private static void registerHandlers() {
        ComputeFovModifierCallback.EVENT.register(FovModifierHandler::onComputeFovModifier);
        ClientTickEvents.END.register(GlidingCameraHandler::onClientTick$End);
        ClientTickEvents.END.register(ElytraEquippedHandler.INSTANCE::onClientTick$End);
        RenderGuiCallback.EVENT.register(ElytraEquippedHandler.INSTANCE::onRenderGui);
    }

    public void onRegisterLayerDefinitions(LayerDefinitionsContext context) {
        context.registerLayerDefinition(ModClientRegistry.GLIDER, GliderModel::createLayer);
    }

    public void onRegisterLivingEntityRenderLayers(LivingEntityRenderLayersContext context) {
        context.registerRenderLayer(EntityType.f_20532_, (renderLayerParent, context1) -> new GliderLayer((RenderLayerParent<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>>)renderLayerParent, context1.m_174027_()));
    }

    public void onRegisterItemModelProperties(ItemModelPropertiesContext context) {
        context.registerItemProperty(HangGlider.id("deployed"), (itemStack, clientLevel, livingEntity, i) -> {
            if (!(livingEntity instanceof Player)) return 0.0f;
            Player player = (Player)livingEntity;
            if (!PlayerGlidingHelper.isValidGlider(itemStack)) return 0.0f;
            if (!PlayerGlidingHelper.isGliderDeployed(player)) return 0.0f;
            if (PlayerGlidingHelper.getGliderInHand(player) != itemStack) return 0.0f;
            return 1.0f;
        }, (ItemLike)ModRegistry.HANG_GLIDER_ITEM.get(), new ItemLike[]{(ItemLike)ModRegistry.REINFORCED_HANG_GLIDER_ITEM.get()});
        context.registerItemProperty(HangGlider.id("broken"), (itemStack, clientLevel, livingEntity, i) -> !PlayerGlidingHelper.isValidGlider(itemStack) ? 1.0f : 0.0f, (ItemLike)ModRegistry.HANG_GLIDER_ITEM.get(), new ItemLike[]{(ItemLike)ModRegistry.REINFORCED_HANG_GLIDER_ITEM.get()});
    }

    public void onBuildCreativeModeTabContents(BuildCreativeModeTabContentsContext context) {
        context.registerBuildListener("hangglider", (featureFlagSet, output, bl) -> {
            output.m_246326_((ItemLike)ModRegistry.HANG_GLIDER_ITEM.get());
            output.m_246326_((ItemLike)ModRegistry.REINFORCED_HANG_GLIDER_ITEM.get());
            output.m_246326_((ItemLike)ModRegistry.GLIDER_WING_ITEM.get());
            output.m_246326_((ItemLike)ModRegistry.GLIDER_FRAMEWORK_ITEM.get());
        });
    }
}

