/*
 * Decompiled with CFR 0.152.
 */
package fuzs.hangglider.world.item;

import fuzs.hangglider.HangGlider;
import fuzs.hangglider.config.ServerConfig;
import fuzs.hangglider.helper.PlayerGlidingHelper;
import java.util.function.Supplier;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ElytraItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;

public class GliderItem
extends Item {
    private final Type type;

    public GliderItem(Item.Properties properties, Type type) {
        super(properties);
        this.type = type;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand usedHand) {
        ItemStack stack = player.m_21120_(usedHand);
        if (player.m_6844_(EquipmentSlot.CHEST).m_41720_() instanceof ElytraItem) {
            HangGlider.PROXY.addElytraWidget();
        } else if (PlayerGlidingHelper.isValidGlider(stack)) {
            PlayerGlidingHelper.setGliderDeployed(player, !PlayerGlidingHelper.isGliderDeployed(player));
            return InteractionResultHolder.m_19092_((Object)stack, (boolean)level.f_46443_);
        }
        return InteractionResultHolder.m_19100_((Object)stack);
    }

    public boolean m_6832_(ItemStack stack, ItemStack repairCandidate) {
        return repairCandidate.m_150930_(this.type.repairMaterial);
    }

    public ServerConfig.GliderConfig getGliderMaterialSettings() {
        return this.type.materialSettings.get();
    }

    public static enum Type {
        BASIC(() -> ((ServerConfig)HangGlider.CONFIG.get(ServerConfig.class)).hangGlider, Items.f_42454_),
        REINFORCED(() -> ((ServerConfig)HangGlider.CONFIG.get(ServerConfig.class)).reinforcedHangGlider, Items.f_42714_);

        private final Supplier<ServerConfig.GliderConfig> materialSettings;
        private final Item repairMaterial;

        private Type(Supplier<ServerConfig.GliderConfig> materialSettings, Item repairMaterial) {
            this.materialSettings = materialSettings;
            this.repairMaterial = repairMaterial;
        }
    }
}

