/*
 * Decompiled with CFR 0.152.
 */
package fuzs.hangglider.handler;

import fuzs.hangglider.HangGlider;
import fuzs.hangglider.config.ServerConfig;
import fuzs.hangglider.helper.PlayerGlidingHelper;
import fuzs.hangglider.wind.WindHelper;
import fuzs.hangglider.world.item.GliderItem;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1770;
import net.minecraft.class_1799;
import net.minecraft.class_243;

public class PlayerGlidingHandler {
    public static void onPlayerTick$End(class_1657 player) {
        if (PlayerGlidingHelper.isGliderDeployed(player)) {
            class_1799 stack = PlayerGlidingHelper.getGliderInHand(player);
            if (PlayerGlidingHelper.isValidGlider(stack) && !(player.method_6118(class_1304.field_6174).method_7909() instanceof class_1770)) {
                if (PlayerGlidingHelper.isAllowedToGlide(player)) {
                    PlayerGlidingHelper.setGliding(player, true);
                    ServerConfig.GliderConfig glider = ((GliderItem)stack.method_7909()).getGliderMaterialSettings();
                    PlayerGlidingHandler.handleGlidingMovement(player, stack, glider);
                    if (!player.method_37908().field_9236) {
                        PlayerGlidingHandler.handleGliderDurability(player, stack, glider);
                    }
                    PlayerGlidingHandler.resetClientAnimations(player);
                    return;
                }
            } else {
                PlayerGlidingHelper.setGliderDeployed(player, false);
            }
        }
        PlayerGlidingHelper.setGliding(player, false);
    }

    public static void resetClientAnimations(class_1657 player) {
        player.field_42108.method_48567(0.0f);
        player.field_42108.method_48572(0.0f);
    }

    private static void handleGlidingMovement(class_1657 player, class_1799 stack, ServerConfig.GliderConfig glider) {
        double verticalSpeed;
        double horizontalSpeed;
        if (player.method_21752()) {
            horizontalSpeed = glider.fastHorizontalSpeed;
            verticalSpeed = glider.fastVerticalSpeed;
        } else {
            horizontalSpeed = glider.horizontalSpeed;
            verticalSpeed = glider.verticalSpeed;
        }
        WindHelper.applyWind(player, stack);
        class_243 movement = player.method_18798();
        double deltaX = Math.cos(Math.toRadians(player.method_36454() + 90.0f)) * horizontalSpeed;
        double deltaZ = Math.sin(Math.toRadians(player.method_36454() + 90.0f)) * horizontalSpeed;
        player.method_18800(movement.field_1352 + deltaX, movement.field_1351 * verticalSpeed, movement.field_1350 + deltaZ);
        if (((ServerConfig)HangGlider.CONFIG.get(ServerConfig.class)).wind.allowAirResistance) {
            movement = player.method_18798();
            double airResistance = glider.airResistance;
            player.method_18800(movement.field_1352 * airResistance, movement.field_1351, movement.field_1350 * airResistance);
        }
        if (player.method_18798().field_1351 > -0.5) {
            player.field_6017 = 1.0f;
        }
    }

    private static void handleGliderDurability(class_1657 player, class_1799 stack, ServerConfig.GliderConfig glider) {
        if (glider.consumeDurability && player.method_6051().method_43048(glider.durabilityUseInterval) == 0) {
            stack.method_7956(1, (class_1309)player, brokenStack -> brokenStack.method_20235(PlayerGlidingHelper.getGliderHoldingHand(player).orElseThrow(() -> new IllegalStateException("No valid glider held in hand"))));
        }
    }
}

