/*
 * Decompiled with CFR 0.152.
 */
package fuzs.hangglider.handler;

import fuzs.hangglider.HangGlider;
import fuzs.hangglider.config.ServerConfig;
import fuzs.hangglider.helper.PlayerGlidingHelper;
import fuzs.hangglider.wind.WindHelper;
import fuzs.hangglider.world.item.GliderItem;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ElytraItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;

public class PlayerGlidingHandler {
    public static void onPlayerTick$End(Player player) {
        if (PlayerGlidingHelper.isGliderDeployed(player)) {
            ItemStack stack = PlayerGlidingHelper.getGliderInHand(player);
            if (PlayerGlidingHelper.isValidGlider(stack) && !(player.m_6844_(EquipmentSlot.CHEST).m_41720_() instanceof ElytraItem)) {
                if (PlayerGlidingHelper.isAllowedToGlide(player)) {
                    PlayerGlidingHelper.setGliding(player, true);
                    ServerConfig.GliderConfig glider = ((GliderItem)stack.m_41720_()).getGliderMaterialSettings();
                    PlayerGlidingHandler.handleGlidingMovement(player, stack, glider);
                    if (!player.m_9236_().f_46443_) {
                        PlayerGlidingHandler.handleGliderDurability(player, stack, glider);
                    }
                    PlayerGlidingHandler.resetClientAnimations(player);
                    return;
                }
            } else {
                PlayerGlidingHelper.setGliderDeployed(player, false);
            }
        }
        PlayerGlidingHelper.setGliding(player, false);
    }

    public static void resetClientAnimations(Player player) {
        player.f_267362_.m_267771_(0.0f);
        player.f_267362_.m_267590_(0.0f);
    }

    private static void handleGlidingMovement(Player player, ItemStack stack, ServerConfig.GliderConfig glider) {
        double verticalSpeed;
        double horizontalSpeed;
        if (player.m_20164_()) {
            horizontalSpeed = glider.fastHorizontalSpeed;
            verticalSpeed = glider.fastVerticalSpeed;
        } else {
            horizontalSpeed = glider.horizontalSpeed;
            verticalSpeed = glider.verticalSpeed;
        }
        WindHelper.applyWind(player, stack);
        Vec3 movement = player.m_20184_();
        double deltaX = Math.cos(Math.toRadians(player.m_146908_() + 90.0f)) * horizontalSpeed;
        double deltaZ = Math.sin(Math.toRadians(player.m_146908_() + 90.0f)) * horizontalSpeed;
        player.m_20334_(movement.f_82479_ + deltaX, movement.f_82480_ * verticalSpeed, movement.f_82481_ + deltaZ);
        if (((ServerConfig)HangGlider.CONFIG.get(ServerConfig.class)).wind.allowAirResistance) {
            movement = player.m_20184_();
            double airResistance = glider.airResistance;
            player.m_20334_(movement.f_82479_ * airResistance, movement.f_82480_, movement.f_82481_ * airResistance);
        }
        if (player.m_20184_().f_82480_ > -0.5) {
            player.f_19789_ = 1.0f;
        }
    }

    private static void handleGliderDurability(Player player, ItemStack stack, ServerConfig.GliderConfig glider) {
        if (glider.consumeDurability && player.m_217043_().m_188503_(glider.durabilityUseInterval) == 0) {
            stack.m_41622_(1, (LivingEntity)player, brokenStack -> brokenStack.m_21166_(PlayerGlidingHelper.getGliderHoldingHand(player).orElseThrow(() -> new IllegalStateException("No valid glider held in hand"))));
        }
    }
}

