/*
 * Decompiled with CFR 0.152.
 */
package hivestandsteam.hotbath;

import hivestandsteam.hotbath.fluid_blocks.HerbalBathBlock;
import hivestandsteam.hotbath.fluid_blocks.HoneyBathBlock;
import hivestandsteam.hotbath.fluid_blocks.HotWaterBlock;
import hivestandsteam.hotbath.fluid_blocks.MilkBathBlock;
import hivestandsteam.hotbath.fluid_blocks.PeonyBathBlock;
import hivestandsteam.hotbath.fluid_blocks.RoseBathBlock;
import hivestandsteam.hotbath.register.BlocksRegister;
import hivestandsteam.hotbath.register.FluidsRegister;
import hivestandsteam.hotbath.register.ItemRegister;
import hivestandsteam.hotbath.register.ParticleRegister;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.fluid.Fluid;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.event.lifecycle.InterModProcessEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ObjectHolder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="hotbath")
public class HotBath {
    public static final Logger LOGGER = LogManager.getLogger();
    public static final String MOD_ID = "hotbath";
    @ObjectHolder(value="hotbath:hot_water_block")
    public static final HotWaterBlock HOT_WATER_BLOCK = null;
    @ObjectHolder(value="hotbath:herbal_bath_block")
    public static final HerbalBathBlock HERBAL_BATH_BLOCK = null;
    @ObjectHolder(value="hotbath:honey_bath_block")
    public static final HoneyBathBlock HONEY_BATH_BLOCK = null;
    @ObjectHolder(value="hotbath:milk_bath_block")
    public static final MilkBathBlock MILK_BATH_BLOCK = null;
    @ObjectHolder(value="hotbath:peony_bath_block")
    public static final PeonyBathBlock PEONY_BATH_BLOCK = null;
    @ObjectHolder(value="hotbath:rose_bath_block")
    public static final RoseBathBlock ROSE_BATH_BLOCK = null;

    public HotBath() {
        IEventBus eventBus = FMLJavaModLoadingContext.get().getModEventBus();
        ItemRegister.register(eventBus);
        BlocksRegister.register(eventBus);
        FluidsRegister.register(eventBus);
        ParticleRegister.register(eventBus);
        eventBus.addListener(this::setup);
        eventBus.addListener(this::enqueueIMC);
        eventBus.addListener(this::processIMC);
        eventBus.addListener(this::doClientStuff);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    private void setup(FMLCommonSetupEvent event) {
        LOGGER.info("HELLO FROM PREINIT");
        LOGGER.info("DIRT BLOCK >> {}", (Object)Blocks.field_150346_d.getRegistryName());
    }

    private void doClientStuff(FMLClientSetupEvent event) {
        event.enqueueWork(() -> {
            RenderTypeLookup.setRenderLayer((Block)((Block)FluidsRegister.HERBAL_BATH_BLOCK.get()), (RenderType)RenderType.func_228645_f_());
            RenderTypeLookup.setRenderLayer((Fluid)((Fluid)FluidsRegister.HERBAL_BATH_FLOWING.get()), (RenderType)RenderType.func_228645_f_());
            RenderTypeLookup.setRenderLayer((Fluid)((Fluid)FluidsRegister.HERBAL_BATH_FLUID.get()), (RenderType)RenderType.func_228645_f_());
            RenderTypeLookup.setRenderLayer((Block)((Block)FluidsRegister.HONEY_BATH_BLOCK.get()), (RenderType)RenderType.func_228645_f_());
            RenderTypeLookup.setRenderLayer((Fluid)((Fluid)FluidsRegister.HONEY_BATH_FLOWING.get()), (RenderType)RenderType.func_228645_f_());
            RenderTypeLookup.setRenderLayer((Fluid)((Fluid)FluidsRegister.HONEY_BATH_FLUID.get()), (RenderType)RenderType.func_228645_f_());
            RenderTypeLookup.setRenderLayer((Fluid)((Fluid)FluidsRegister.HOT_WATER_FLUID.get()), (RenderType)RenderType.func_228645_f_());
            RenderTypeLookup.setRenderLayer((Block)((Block)FluidsRegister.HOT_WATER_BLOCK.get()), (RenderType)RenderType.func_228645_f_());
            RenderTypeLookup.setRenderLayer((Fluid)((Fluid)FluidsRegister.HOT_WATER_FLOWING.get()), (RenderType)RenderType.func_228645_f_());
            RenderTypeLookup.setRenderLayer((Fluid)((Fluid)FluidsRegister.MILK_BATH_FLUID.get()), (RenderType)RenderType.func_228645_f_());
            RenderTypeLookup.setRenderLayer((Block)((Block)FluidsRegister.MILK_BATH_BLOCK.get()), (RenderType)RenderType.func_228645_f_());
            RenderTypeLookup.setRenderLayer((Fluid)((Fluid)FluidsRegister.MILK_BATH_FLOWING.get()), (RenderType)RenderType.func_228645_f_());
            RenderTypeLookup.setRenderLayer((Block)((Block)FluidsRegister.PEONY_BATH_BLOCK.get()), (RenderType)RenderType.func_228645_f_());
            RenderTypeLookup.setRenderLayer((Fluid)((Fluid)FluidsRegister.PEONY_BATH_FLOWING.get()), (RenderType)RenderType.func_228645_f_());
            RenderTypeLookup.setRenderLayer((Fluid)((Fluid)FluidsRegister.PEONY_BATH_FLUID.get()), (RenderType)RenderType.func_228645_f_());
            RenderTypeLookup.setRenderLayer((Block)((Block)FluidsRegister.ROSE_BATH_BLOCK.get()), (RenderType)RenderType.func_228645_f_());
            RenderTypeLookup.setRenderLayer((Fluid)((Fluid)FluidsRegister.ROSE_BATH_FLOWING.get()), (RenderType)RenderType.func_228645_f_());
            RenderTypeLookup.setRenderLayer((Fluid)((Fluid)FluidsRegister.ROSE_BATH_FLUID.get()), (RenderType)RenderType.func_228645_f_());
        });
    }

    private void enqueueIMC(InterModEnqueueEvent event) {
        InterModComms.sendTo((String)MOD_ID, (String)"helloworld", () -> {
            LOGGER.info("Hello world from Hot Bath");
            return "Hello world from Hot Bath";
        });
    }

    private void processIMC(InterModProcessEvent event) {
        LOGGER.info("Got IMC {}", event.getIMCStream().map(m -> m.getMessageSupplier().get()).collect(Collectors.toList()));
    }

    @SubscribeEvent
    public void onServerStarting(FMLServerStartingEvent event) {
        LOGGER.info("HELLO from Hot Bath");
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class RegistryEvents {
        @SubscribeEvent
        public static void onBlocksRegistry(RegistryEvent.Register<Block> blockRegistryEvent) {
            LOGGER.info("HELLO from Hot Bath");
        }
    }
}

