/*
 * Decompiled with CFR 0.152.
 */
package hivestandsteam.hotbath.events.enter_fluid_events;

import hivestandsteam.hotbath.util.CustomFluidHandler;
import hivestandsteam.hotbath.util.EffectRemovalHandler;
import hivestandsteam.hotbath.util.HealthRegenHandler;
import hivestandsteam.hotbath.util.ResistanceBoostHandler;
import net.minecraft.advancements.Advancement;
import net.minecraft.entity.Entity;
import net.minecraft.entity.monster.SkeletonEntity;
import net.minecraft.entity.monster.ZombieEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="hotbath")
public class HerbalBathEvents {
    private static final int TICK_NUMBER = 20;
    static final String HERBAL_BATH_ENTERED_NUMBER = "HerbalBathEnteredNumber";
    static final String HERBAL_BATH_STAYED_TIME = "HerbalBathStayedTime";
    static final String HAS_ENTERED_HERBAL_BATH = "HasEnteredHerbalBath";
    static final String HERBAL_BATH_ADVANCEMENT_ID = "hotbath:chronic_invalid";
    private static final int HERBAL_BATH_ENTERED_COUNT_TRIGGER_NUMBER = 100;
    private static final int HERBAL_BATH_STAYED_EFFECT_TRIGGER_TIME_SECONDS = 5;

    @SubscribeEvent
    public static void enterHerbalBathBlockEvent(LivingEvent.LivingUpdateEvent event) {
        HerbalBathEvents.enterFluidEvents(event, 100, 5, HERBAL_BATH_ENTERED_NUMBER, HERBAL_BATH_STAYED_TIME, HAS_ENTERED_HERBAL_BATH, HERBAL_BATH_ADVANCEMENT_ID);
    }

    public static void enterFluidEvents(LivingEvent.LivingUpdateEvent event, int enteredCountTriggerNumber, int stayedEffectTriggerTime, String enteredNumberInHerbalBath, String herbalBathStayedTime, String hasEnteredHerbalBath, String herbalBathAdvancementId) {
        if (!(event.getEntityLiving() instanceof PlayerEntity)) {
            boolean isInHerbalBath;
            if ((event.getEntityLiving() instanceof ZombieEntity || event.getEntityLiving() instanceof SkeletonEntity) && (isInHerbalBath = CustomFluidHandler.isEntityInHerbalBathBlock((Entity)event.getEntityLiving()))) {
                int damageIntervalTicks = 20;
                float damagePerSecond = 0.5f;
                if (event.getEntityLiving().field_70173_aa % damageIntervalTicks == 0) {
                    event.getEntityLiving().func_70097_a(DamageSource.field_76376_m, damagePerSecond);
                }
            }
            return;
        }
        boolean isInHerbalBath = CustomFluidHandler.isPlayerInHerbalBathBlock((PlayerEntity)event.getEntityLiving());
        if (event.getEntityLiving() instanceof ServerPlayerEntity) {
            ServerPlayerEntity player = (ServerPlayerEntity)event.getEntityLiving();
            CompoundNBT playerData = player.getPersistentData();
            if (isInHerbalBath) {
                if (!playerData.func_74767_n(hasEnteredHerbalBath)) {
                    Advancement advancement;
                    int enteredCount = playerData.func_74762_e(enteredNumberInHerbalBath) + 1;
                    playerData.func_74768_a(enteredNumberInHerbalBath, enteredCount);
                    playerData.func_74757_a(hasEnteredHerbalBath, true);
                    if (enteredCount >= enteredCountTriggerNumber && (advancement = player.func_184102_h().func_191949_aK().func_192778_a(ResourceLocation.func_208304_a((String)herbalBathAdvancementId))) != null) {
                        player.func_192039_O().func_192750_a(advancement, "code_triggered");
                        playerData.func_74768_a(enteredNumberInHerbalBath, 0);
                    }
                }
                int hotBathTime = playerData.func_74762_e(herbalBathStayedTime) + 1;
                playerData.func_74768_a(herbalBathStayedTime, hotBathTime);
                HealthRegenHandler.regenHealth(0.25f, 2.0, player);
                if (playerData.func_74762_e(herbalBathStayedTime) >= stayedEffectTriggerTime * 20) {
                    ResistanceBoostHandler.applyResistanceBoost(10, player);
                }
                if (playerData.func_74762_e(herbalBathStayedTime) >= 300) {
                    EffectRemovalHandler.removeNegativeEffects(player);
                }
            } else {
                playerData.func_74768_a(herbalBathStayedTime, 0);
                playerData.func_74757_a(hasEnteredHerbalBath, false);
            }
        }
    }
}

