/*
 * Decompiled with CFR 0.152.
 */
package hivestandsteam.hotbath.events.enter_fluid_events;

import hivestandsteam.hotbath.util.CustomFluidHandler;
import hivestandsteam.hotbath.util.EffectRemovalHandler;
import hivestandsteam.hotbath.util.HealthRegenHandler;
import hivestandsteam.hotbath.util.HungerRegenHandler;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="hotbath")
public class HoneyBathEvents {
    private static final int TICK_NUMBER = 20;
    static final String HONEY_BATH_STAYED_TIME = "HoneyBathStayedTime";
    private static final int HONEY_BATH_STAYED_EFFECT_TRIGGER_TIME_SECONDS = 15;

    @SubscribeEvent
    public static void enterHoneyBathEvents(LivingEvent.LivingUpdateEvent event) {
        HoneyBathEvents.enterFluidEvents(event, 15, HONEY_BATH_STAYED_TIME);
    }

    public static void enterFluidEvents(LivingEvent.LivingUpdateEvent event, int stayedEffectTriggerTime, String honeyBathStayedTime) {
        if (event.getEntityLiving() instanceof ServerPlayerEntity) {
            ServerPlayerEntity player = (ServerPlayerEntity)event.getEntityLiving();
            CompoundNBT playerData = player.getPersistentData();
            boolean isInHoneyBath = CustomFluidHandler.isPlayerInHoneyBathBlock((PlayerEntity)player);
            if (isInHoneyBath) {
                int honeyBathTime = playerData.func_74762_e(honeyBathStayedTime) + 1;
                playerData.func_74768_a(honeyBathStayedTime, honeyBathTime);
                HealthRegenHandler.regenHealth(0.25f, 1.0, player);
                HungerRegenHandler.regenHunger(1, 4.0f, player);
                player.func_195064_c(new EffectInstance(Effects.field_76421_d, 200, 0, false, false, true));
                if (playerData.func_74762_e(honeyBathStayedTime) >= stayedEffectTriggerTime * 20) {
                    EffectRemovalHandler.removeNegativeEffectsExceptSlowAndUnluck(player);
                    player.func_195064_c(new EffectInstance(Effects.field_76444_x, 400, 1, false, false, true));
                }
            } else {
                playerData.func_74768_a(honeyBathStayedTime, 0);
            }
        }
    }
}

