/*
 * Decompiled with CFR 0.152.
 */
package hivestandsteam.hotbath.events.enter_fluid_events;

import hivestandsteam.hotbath.util.CustomFluidHandler;
import net.minecraft.advancements.Advancement;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="hotbath")
public class HotWaterEvents {
    private static final int TICK_NUMBER = 20;
    static final String HOT_WATER_ENTERED_NUMBER = "HotWaterEnteredNumber";
    static final String HOT_WATER_STAYED_TIME = "HotWaterStayedTime";
    static final String HAS_ENTERED_HOT_WATER = "HasEnteredHotWater";
    static final String HOT_WATER_ADVANCEMENT_ID = "hotbath:foot_health";
    private static final int HOT_WATER_ENTERED_COUNT_TRIGGER_NUMBER = 100;
    private static final int HOT_WATER_STAYED_EFFECT_TRIGGER_TIME_SECONDS = 15;

    @SubscribeEvent
    public static void enterHotWaterEvents(LivingEvent.LivingUpdateEvent event) {
        HotWaterEvents.enterFluidEvents(event, 100, 15, HOT_WATER_ENTERED_NUMBER, HOT_WATER_STAYED_TIME, HAS_ENTERED_HOT_WATER, HOT_WATER_ADVANCEMENT_ID);
    }

    public static void enterFluidEvents(LivingEvent.LivingUpdateEvent event, int enteredCountTriggerNumber, int stayedEffectTriggerTime, String hotWaterEnteredNumber, String hotWaterStayedTime, String hasEnteredHotWater, String hotWaterAdvancementId) {
        if (event.getEntityLiving() instanceof ServerPlayerEntity) {
            ServerPlayerEntity player = (ServerPlayerEntity)event.getEntityLiving();
            CompoundNBT playerData = player.getPersistentData();
            boolean isInHotWater = CustomFluidHandler.isPlayerInHotWaterBlock((PlayerEntity)player);
            if (isInHotWater) {
                if (!playerData.func_74767_n(hasEnteredHotWater)) {
                    Advancement advancement;
                    int enteredCount = playerData.func_74762_e(hotWaterEnteredNumber) + 1;
                    playerData.func_74768_a(hotWaterEnteredNumber, enteredCount);
                    playerData.func_74757_a(hasEnteredHotWater, true);
                    if (enteredCount >= enteredCountTriggerNumber && (advancement = player.func_184102_h().func_191949_aK().func_192778_a(ResourceLocation.func_208304_a((String)hotWaterAdvancementId))) != null) {
                        player.func_192039_O().func_192750_a(advancement, "code_triggered");
                        playerData.func_74768_a(hotWaterEnteredNumber, 0);
                    }
                }
                int hotBathTime = playerData.func_74762_e(hotWaterStayedTime) + 1;
                playerData.func_74768_a(hotWaterStayedTime, hotBathTime);
                if (playerData.func_74762_e(hotWaterStayedTime) >= stayedEffectTriggerTime * 20) {
                    player.func_195064_c(new EffectInstance(Effects.field_76424_c, 400, 0, false, false, true));
                }
            } else {
                playerData.func_74768_a(hotWaterStayedTime, 0);
                playerData.func_74757_a(hasEnteredHotWater, false);
            }
        }
    }
}

