/*
 * Decompiled with CFR 0.152.
 */
package hivestandsteam.hotbath.events.enter_fluid_events;

import hivestandsteam.hotbath.util.CustomFluidHandler;
import hivestandsteam.hotbath.util.EffectRemovalHandler;
import hivestandsteam.hotbath.util.HealthRegenHandler;
import hivestandsteam.hotbath.util.HungerRegenHandler;
import net.minecraft.advancements.Advancement;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="hotbath")
public class MilkBathEvents {
    private static final int TICK_NUMBER = 20;
    static final String MILK_BATH_ENTERED_NUMBER = "MilkBathEnteredNumber";
    static final String MILK_BATH_STAYED_TIME = "MilkBathStayedTime";
    static final String HAS_ENTERED_MILK_BATH = "HasEnteredMilkBath";
    static final String MILK_BATH_ADVANCEMENT_ID = "hotbath:milk_skin";
    private static final int MILK_BATH_ENTERED_COUNT_TRIGGER_NUMBER = 100;
    private static final int MILK_BATH_STAYED_EFFECT_TRIGGER_TIME_SECONDS = 15;

    @SubscribeEvent
    public static void enterMilkBathEvents(LivingEvent.LivingUpdateEvent event) {
        MilkBathEvents.enterFluidEvents(event, 100, 15, MILK_BATH_ENTERED_NUMBER, MILK_BATH_STAYED_TIME, HAS_ENTERED_MILK_BATH, MILK_BATH_ADVANCEMENT_ID);
    }

    public static void enterFluidEvents(LivingEvent.LivingUpdateEvent event, int enteredCountTriggerNumber, int stayedEffectTriggerTime, String enteredNumberInMilkBath, String milkBathStayedTime, String hasEnteredMilkBath, String milkBathAdvancementId) {
        if (event.getEntityLiving() instanceof ServerPlayerEntity) {
            ServerPlayerEntity player = (ServerPlayerEntity)event.getEntityLiving();
            CompoundNBT playerData = player.getPersistentData();
            boolean isInMilkBath = CustomFluidHandler.isPlayerInMilkBathBlock((PlayerEntity)player);
            if (isInMilkBath) {
                if (!playerData.func_74767_n(hasEnteredMilkBath)) {
                    Advancement advancement;
                    int enteredCount = playerData.func_74762_e(enteredNumberInMilkBath) + 1;
                    playerData.func_74768_a(enteredNumberInMilkBath, enteredCount);
                    playerData.func_74757_a(hasEnteredMilkBath, true);
                    if (enteredCount >= enteredCountTriggerNumber && (advancement = player.func_184102_h().func_191949_aK().func_192778_a(ResourceLocation.func_208304_a((String)milkBathAdvancementId))) != null) {
                        player.func_192039_O().func_192750_a(advancement, "code_triggered");
                        playerData.func_74768_a(enteredNumberInMilkBath, 0);
                    }
                }
                int hotBathTime = playerData.func_74762_e(milkBathStayedTime) + 1;
                playerData.func_74768_a(milkBathStayedTime, hotBathTime);
                HungerRegenHandler.regenHunger(1, 15.0f, player);
                HealthRegenHandler.regenHealth(0.25f, 2.0, player);
                if (playerData.func_74762_e(milkBathStayedTime) >= stayedEffectTriggerTime * 20) {
                    EffectRemovalHandler.removeNegativeEffectsExceptUnluck(player);
                }
            } else {
                playerData.func_74768_a(milkBathStayedTime, 0);
                playerData.func_74757_a(hasEnteredMilkBath, false);
            }
        }
    }
}

