/*
 * Decompiled with CFR 0.152.
 */
package hivestandsteam.hotbath.events.enter_fluid_events;

import hivestandsteam.hotbath.util.CustomFluidHandler;
import hivestandsteam.hotbath.util.EffectRemovalHandler;
import hivestandsteam.hotbath.util.HealthRegenHandler;
import java.util.UUID;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="hotbath")
public class PeonyBathEvents {
    static final String PEONY_BATH_ENTERED_NUMBER = "PeonyBathEnteredNumber";
    static final String PEONY_BATH_STAYED_TIME = "PeonyBathStayedTime";
    static final String HAS_ENTERED_PEONY_BATH = "HasEnteredPeonyBath";
    static final String PEONY_BATH_EXITED_TIME = "PeonyBathExitedTime";
    private static final int TICK_NUMBER = 20;
    private static final int PEONY_BATH_ENTERED_COUNT_TRIGGER_NUMBER = 100;
    private static final int PEONY_BATH_STAYED_EFFECT_TRIGGER_TIME_SECONDS = 5;
    private static final int KNOCKBACK_RESISTANCE_DURATION = 600;
    private static final int ATTACK_SPEED_DURATION = 300;
    private static final int LUCK_DURATION = 900;
    private static final int LUCK_THRESHOLD = 50;
    private static final UUID ATTACK_SPEED_MODIFIER_UUID = UUID.randomUUID();
    private static final UUID KNOCKBACK_RESISTANCE_UUID = UUID.randomUUID();
    private static final int ATTRIBUTE_REMOVE_DELAY_TICKS = 300;

    @SubscribeEvent
    public static void enterPeonyBathEvents(LivingEvent.LivingUpdateEvent event) {
        PeonyBathEvents.enterFluidEvents(event, 100, 5, PEONY_BATH_ENTERED_NUMBER, PEONY_BATH_STAYED_TIME, HAS_ENTERED_PEONY_BATH);
    }

    public static void enterFluidEvents(LivingEvent.LivingUpdateEvent event, int enteredCountTriggerNumber, int stayedEffectTriggerTime, String enteredNumberInPeonyBath, String peonyBathStayedTime, String hasEnteredPeonyBath) {
        if (event.getEntityLiving() instanceof ServerPlayerEntity) {
            ServerPlayerEntity player = (ServerPlayerEntity)event.getEntityLiving();
            CompoundNBT playerData = player.getPersistentData();
            boolean isInPeonyBath = CustomFluidHandler.isPlayerInPeonyBathBlock((PlayerEntity)player);
            if (isInPeonyBath) {
                if (!playerData.func_74767_n(hasEnteredPeonyBath)) {
                    int enteredCount = playerData.func_74762_e(enteredNumberInPeonyBath) + 1;
                    playerData.func_74768_a(enteredNumberInPeonyBath, enteredCount);
                    playerData.func_74757_a(hasEnteredPeonyBath, true);
                }
                int hotBathTime = playerData.func_74762_e(peonyBathStayedTime) + 1;
                playerData.func_74768_a(peonyBathStayedTime, hotBathTime);
                HealthRegenHandler.regenHealth(0.25f, 2.0, player);
                if (playerData.func_74762_e(peonyBathStayedTime) >= 300) {
                    PeonyBathEvents.applyAttributeModifier(player, Attributes.field_233820_c_, KNOCKBACK_RESISTANCE_UUID, 0.05, AttributeModifier.Operation.ADDITION);
                    PeonyBathEvents.applyAttributeModifier(player, Attributes.field_233825_h_, ATTACK_SPEED_MODIFIER_UUID, 0.1, AttributeModifier.Operation.MULTIPLY_TOTAL);
                    EffectRemovalHandler.removeNegativeEffects(player);
                    EffectRemovalHandler.removeBadOmen(player);
                }
                if (playerData.func_74762_e(enteredNumberInPeonyBath) >= 50) {
                    player.func_195064_c(new EffectInstance(Effects.field_188425_z, 900, 45, false, false, true));
                }
                playerData.func_74768_a(PEONY_BATH_EXITED_TIME, 0);
            } else {
                if (playerData.func_74767_n(hasEnteredPeonyBath)) {
                    playerData.func_74757_a(hasEnteredPeonyBath, false);
                }
                playerData.func_74768_a(PEONY_BATH_EXITED_TIME, playerData.func_74762_e(PEONY_BATH_EXITED_TIME) + 1);
                if (playerData.func_74762_e(PEONY_BATH_EXITED_TIME) >= 300) {
                    PeonyBathEvents.removeAttributeModifier(player, Attributes.field_233825_h_, ATTACK_SPEED_MODIFIER_UUID);
                }
                if (playerData.func_74762_e(PEONY_BATH_EXITED_TIME) >= 600) {
                    PeonyBathEvents.removeAttributeModifier(player, Attributes.field_233820_c_, KNOCKBACK_RESISTANCE_UUID);
                }
                playerData.func_74768_a(peonyBathStayedTime, 0);
            }
        }
    }

    private static void applyAttributeModifier(ServerPlayerEntity player, Attribute attribute, UUID uuid, double value, AttributeModifier.Operation operation) {
        ModifiableAttributeInstance attributeInstance = player.func_110148_a(attribute);
        if (attributeInstance != null) {
            AttributeModifier modifier = new AttributeModifier(uuid, attribute.func_233754_c_(), value, operation);
            if (attributeInstance.func_111127_a(modifier.func_111167_a()) != null) {
                attributeInstance.func_188479_b(modifier.func_111167_a());
            }
            attributeInstance.func_233769_c_(modifier);
        }
    }

    private static void removeAttributeModifier(ServerPlayerEntity player, Attribute attribute, UUID uuid) {
        ModifiableAttributeInstance attributeInstance = player.func_110148_a(attribute);
        if (attributeInstance != null && attributeInstance.func_111127_a(uuid) != null) {
            attributeInstance.func_188479_b(uuid);
        }
    }
}

