/*
 * Decompiled with CFR 0.152.
 */
package hivestandsteam.hotbath.events.enter_fluid_events;

import hivestandsteam.hotbath.util.CustomFluidHandler;
import hivestandsteam.hotbath.util.EffectRemovalHandler;
import hivestandsteam.hotbath.util.HealthRegenHandler;
import net.minecraft.advancements.Advancement;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="hotbath")
public class RoseBathEvents {
    private static final int TICK_NUMBER = 20;
    static final String ROSE_BATH_ENTERED_NUMBER = "RoseBathEnteredNumber";
    static final String ROSE_BATH_STAYED_TIME = "RoseBathStayedTime";
    static final String HAS_ENTERED_ROSE_BATH = "HasEnteredRoseBath";
    static final String ROSE_BATH_ADVANCEMENT_ID = "hotbath:rose_body_fragrance";
    private static final int ROSE_BATH_ENTERED_COUNT_TRIGGER_NUMBER = 100;
    private static final int ROSE_BATH_STAYED_EFFECT_TRIGGER_TIME_SECONDS = 15;

    @SubscribeEvent
    public static void enterRoseBathEvents(LivingEvent.LivingUpdateEvent event) {
        RoseBathEvents.enterFluidEvents(event, 100, 15, ROSE_BATH_ENTERED_NUMBER, ROSE_BATH_STAYED_TIME, HAS_ENTERED_ROSE_BATH, ROSE_BATH_ADVANCEMENT_ID);
    }

    public static void enterFluidEvents(LivingEvent.LivingUpdateEvent event, int enteredCountTriggerNumber, int stayedEffectTriggerTime, String enteredNumberInRoseBath, String roseBathStayedTime, String hasEnteredRoseBath, String roseBathAdvancementId) {
        if (event.getEntityLiving() instanceof ServerPlayerEntity) {
            ServerPlayerEntity player = (ServerPlayerEntity)event.getEntityLiving();
            CompoundNBT playerData = player.getPersistentData();
            boolean isInRoseBath = CustomFluidHandler.isPlayerInRoseBathBlock((PlayerEntity)player);
            if (isInRoseBath) {
                if (!playerData.func_74767_n(hasEnteredRoseBath)) {
                    Advancement advancement;
                    int enteredCount = playerData.func_74762_e(enteredNumberInRoseBath) + 1;
                    playerData.func_74768_a(enteredNumberInRoseBath, enteredCount);
                    playerData.func_74757_a(hasEnteredRoseBath, true);
                    if (enteredCount >= enteredCountTriggerNumber && (advancement = player.func_184102_h().func_191949_aK().func_192778_a(ResourceLocation.func_208304_a((String)roseBathAdvancementId))) != null) {
                        player.func_192039_O().func_192750_a(advancement, "code_triggered");
                        playerData.func_74768_a(enteredNumberInRoseBath, 0);
                    }
                }
                int roseBathStayTime = playerData.func_74762_e(roseBathStayedTime) + 1;
                playerData.func_74768_a(roseBathStayedTime, roseBathStayTime);
                HealthRegenHandler.regenHealth(0.25f, 1.0, player);
                if (playerData.func_74762_e(roseBathStayedTime) >= stayedEffectTriggerTime * 20) {
                    EffectRemovalHandler.removeNegativeEffects(player);
                    EffectRemovalHandler.removeBadOmen(player);
                    player.func_195064_c(new EffectInstance(Effects.field_76420_g, 400, 0, false, false, true));
                }
            } else {
                playerData.func_74768_a(roseBathStayedTime, 0);
                playerData.func_74757_a(hasEnteredRoseBath, false);
            }
        }
    }
}

