/*
 * Decompiled with CFR 0.152.
 */
package immersive_aircraft.client;

import immersive_aircraft.client.FallbackKeyBinding;
import immersive_aircraft.client.MultiKeyBinding;
import immersive_aircraft.config.Config;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.util.InputMappings;

public class KeyBindings {
    public static List<KeyBinding> list = new LinkedList<KeyBinding>();
    public static final KeyBinding left;
    public static final KeyBinding right;
    public static final KeyBinding forward;
    public static final KeyBinding backward;
    public static final KeyBinding up;
    public static final KeyBinding down;
    public static final KeyBinding pull;
    public static final KeyBinding push;
    public static final KeyBinding dismount;
    public static final KeyBinding boost;

    private static KeyBinding newFallbackKey(String name, Supplier<KeyBinding> fallback) {
        FallbackKeyBinding key = new FallbackKeyBinding("key.immersive_aircraft." + name, InputMappings.Type.KEYSYM, fallback, "itemGroup.immersive_aircraft.immersive_aircraft_tab");
        list.add(key);
        return key;
    }

    private static KeyBinding newKey(String name, int code) {
        KeyBinding key = new KeyBinding("key.immersive_aircraft." + name, InputMappings.Type.KEYSYM, code, "itemGroup.immersive_aircraft.immersive_aircraft_tab");
        list.add(key);
        return key;
    }

    private static KeyBinding newMultiKey(String name, int defaultKey) {
        MultiKeyBinding key = new MultiKeyBinding("key.immersive_aircraft." + name, InputMappings.Type.KEYSYM, defaultKey, "itemGroup.immersive_aircraft.immersive_aircraft_tab");
        list.add(key);
        return key;
    }

    static {
        if (Config.getInstance().useCustomKeybindSystem) {
            left = KeyBindings.newMultiKey("multi_control_left", 65);
            right = KeyBindings.newMultiKey("multi_control_right", 68);
            forward = KeyBindings.newMultiKey("multi_control_forward", 87);
            backward = KeyBindings.newMultiKey("multi_control_backward", 83);
            up = KeyBindings.newMultiKey("multi_control_up", 32);
            down = KeyBindings.newMultiKey("multi_control_down", 340);
            pull = KeyBindings.newMultiKey("multi_control_pull", 83);
            push = KeyBindings.newMultiKey("multi_control_push", 87);
            dismount = KeyBindings.newMultiKey("multi_dismount", 82);
            boost = KeyBindings.newMultiKey("multi_boost", 66);
        } else {
            Minecraft client = Minecraft.func_71410_x();
            left = KeyBindings.newFallbackKey("fallback_control_left", () -> client.field_71474_y.field_74370_x);
            right = KeyBindings.newFallbackKey("fallback_control_right", () -> client.field_71474_y.field_74366_z);
            forward = KeyBindings.newFallbackKey("fallback_control_forward", () -> client.field_71474_y.field_74351_w);
            backward = KeyBindings.newFallbackKey("fallback_control_backward", () -> client.field_71474_y.field_74368_y);
            up = KeyBindings.newFallbackKey("fallback_control_up", () -> client.field_71474_y.field_74314_A);
            down = KeyBindings.newFallbackKey("fallback_control_down", () -> client.field_71474_y.field_228046_af_);
            pull = KeyBindings.newFallbackKey("fallback_control_pull", () -> client.field_71474_y.field_74368_y);
            push = KeyBindings.newFallbackKey("fallback_control_push", () -> client.field_71474_y.field_74351_w);
            dismount = KeyBindings.newKey("fallback_dismount", 82);
            boost = KeyBindings.newKey("fallback_boost", 66);
        }
    }
}

