/*
 * Decompiled with CFR 0.152.
 */
package immersive_aircraft.client;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import immersive_aircraft.Main;
import immersive_aircraft.entity.EngineAircraft;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.util.ResourceLocation;

public class OverlayRenderer {
    private static final ResourceLocation TEXTURE = Main.locate("textures/engine.png");
    private static final ResourceLocation TEXTURE2 = Main.locate("textures/power.png");
    private static float bootUp = 0.0f;
    private static float lastTime = 0.0f;

    public static void renderOverlay(MatrixStack matrices, float tickDelta) {
        Minecraft client = Minecraft.func_71410_x();
        if (!client.field_71474_y.field_74319_N && client.field_71442_b != null && client.field_71439_g != null && client.field_71439_g.func_184208_bv() instanceof EngineAircraft) {
            EngineAircraft aircraft = (EngineAircraft)client.field_71439_g.func_184208_bv();
            OverlayRenderer.renderAircraftGui(client, matrices, tickDelta, aircraft);
        }
    }

    private static void renderAircraftGui(Minecraft client, MatrixStack matrices, float tickDelta, EngineAircraft aircraft) {
        assert (client.field_71441_e != null);
        if (aircraft.getGuiStyle() == EngineAircraft.GUI_STYLE.ENGINE) {
            int frame;
            float time = (float)(client.field_71441_e.func_82737_E() % 65536L) + tickDelta;
            float delta = time - lastTime;
            lastTime = time;
            if (aircraft.getEngineTarget() > 0.0f && (double)aircraft.getEnginePower() > 0.001) {
                if (bootUp < 1.0f) {
                    bootUp = Math.min(1.0f, bootUp + delta * 0.2f);
                    frame = (int)(bootUp * 5.0f);
                } else {
                    int FPS = 30;
                    int animation = (int)(aircraft.engineRotation.getSmooth(tickDelta) / 20.0f * (float)FPS);
                    frame = 5 + animation % 6;
                }
            } else if (bootUp > 0.0f) {
                bootUp = Math.max(0.0f, bootUp - delta * 0.1f);
                frame = 10 + (int)((1.0 - (double)bootUp) * 10.0);
            } else {
                frame = 20;
            }
            int powerFrame = (int)((double)((1.0f - aircraft.getEnginePower()) * 10.0f) + 10.5);
            int powerFrameTarget = (int)((double)((1.0f - aircraft.getEngineTarget()) * 10.0f) + 10.5);
            int x = client.func_228018_at_().func_198107_o() / 2;
            int y = client.func_228018_at_().func_198087_p() - 37;
            if (client.field_71442_b != null && !client.field_71442_b.func_78763_f()) {
                y += 7;
            }
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            client.func_110434_K().func_110577_a(TEXTURE);
            AbstractGui.func_238463_a_((MatrixStack)matrices, (int)(x - 9), (int)(y - 9), (float)(frame % 5 * 18), (float)(Math.floorDiv(frame, 5) * 18), (int)18, (int)18, (int)90, (int)90);
            client.func_110434_K().func_110577_a(TEXTURE2);
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            AbstractGui.func_238463_a_((MatrixStack)matrices, (int)(x - 9), (int)(y - 9), (float)(powerFrame % 5 * 18), (float)(Math.floorDiv(powerFrame, 5) * 18), (int)18, (int)18, (int)90, (int)90);
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
            AbstractGui.func_238463_a_((MatrixStack)matrices, (int)(x - 9), (int)(y - 9), (float)(powerFrameTarget % 5 * 18), (float)(Math.floorDiv(powerFrameTarget, 5) * 18), (int)18, (int)18, (int)90, (int)90);
        }
    }
}

