/*
 * Decompiled with CFR 0.152.
 */
package immersive_aircraft.client.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import immersive_aircraft.Main;
import immersive_aircraft.entity.EngineAircraft;
import immersive_aircraft.entity.misc.VehicleInventoryDescription;
import immersive_aircraft.mixin.SlotAccessorMixin;
import immersive_aircraft.screen.VehicleScreenHandler;
import java.util.Collections;
import java.util.Locale;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.TranslationTextComponent;

public class VehicleScreen
extends ContainerScreen<VehicleScreenHandler> {
    private static final ResourceLocation TEXTURE = Main.locate("textures/gui/container/inventory.png");
    public static int titleHeight = 10;
    public static int baseHeight = 86;
    public static int containerSize;

    public VehicleScreen(VehicleScreenHandler handler, PlayerInventory inventory, ITextComponent title) {
        super((Container)handler, inventory, title);
        containerSize = handler.getVehicle().getInventoryDescription().getHeight();
        this.field_147000_g = baseHeight + containerSize + titleHeight * 2;
        this.field_238745_s_ = containerSize + titleHeight;
    }

    protected void func_230450_a_(MatrixStack matrices, float delta, int mouseX, int mouseY) {
    }

    protected void drawRectangle(MatrixStack matrices, int x, int y, int h, int w) {
        VehicleScreen.func_238463_a_((MatrixStack)matrices, (int)x, (int)y, (float)176.0f, (float)0.0f, (int)16, (int)16, (int)512, (int)256);
        VehicleScreen.func_238463_a_((MatrixStack)matrices, (int)(x + w - 16), (int)y, (float)208.0f, (float)0.0f, (int)16, (int)16, (int)512, (int)256);
        VehicleScreen.func_238463_a_((MatrixStack)matrices, (int)(x + w - 16), (int)(y + h - 16), (float)208.0f, (float)32.0f, (int)16, (int)16, (int)512, (int)256);
        VehicleScreen.func_238463_a_((MatrixStack)matrices, (int)x, (int)(y + h - 16), (float)176.0f, (float)32.0f, (int)16, (int)16, (int)512, (int)256);
        VehicleScreen.func_238466_a_((MatrixStack)matrices, (int)(x + 16), (int)y, (int)(w - 32), (int)16, (float)192.0f, (float)0.0f, (int)16, (int)16, (int)512, (int)256);
        VehicleScreen.func_238466_a_((MatrixStack)matrices, (int)(x + 16), (int)(y + h - 16), (int)(w - 32), (int)16, (float)192.0f, (float)32.0f, (int)16, (int)16, (int)512, (int)256);
        VehicleScreen.func_238466_a_((MatrixStack)matrices, (int)x, (int)(y + 16), (int)16, (int)(h - 32), (float)176.0f, (float)16.0f, (int)16, (int)16, (int)512, (int)256);
        VehicleScreen.func_238466_a_((MatrixStack)matrices, (int)(x + w - 16), (int)(y + 16), (int)16, (int)(h - 32), (float)208.0f, (float)16.0f, (int)16, (int)16, (int)512, (int)256);
        VehicleScreen.func_238466_a_((MatrixStack)matrices, (int)(x + 16), (int)(y + 16), (int)(w - 32), (int)(h - 32), (float)192.0f, (float)16.0f, (int)16, (int)16, (int)512, (int)256);
    }

    protected void drawCustomBackground(MatrixStack matrices) {
        assert (this.field_230706_i_ != null);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_230706_i_.func_110434_K().func_110577_a(TEXTURE);
        VehicleScreen.func_238463_a_((MatrixStack)matrices, (int)this.field_147003_i, (int)this.field_147009_r, (float)0.0f, (float)0.0f, (int)this.field_146999_f, (int)(containerSize + titleHeight * 2), (int)512, (int)256);
        VehicleScreen.func_238463_a_((MatrixStack)matrices, (int)this.field_147003_i, (int)(this.field_147009_r + containerSize + titleHeight * 2 - 4), (float)0.0f, (float)(222 - baseHeight), (int)this.field_146999_f, (int)baseHeight, (int)512, (int)256);
        for (VehicleInventoryDescription.Rectangle rectangle : ((VehicleScreenHandler)this.field_147002_h).getVehicle().getInventoryDescription().getRectangles()) {
            this.drawRectangle(matrices, this.field_147003_i + rectangle.x(), this.field_147009_r + rectangle.y(), rectangle.w(), rectangle.h());
        }
    }

    private void drawImage(MatrixStack matrices, int x, int y, int u, int v, int w, int h) {
        VehicleScreen.func_238463_a_((MatrixStack)matrices, (int)x, (int)y, (float)u, (float)v, (int)w, (int)h, (int)512, (int)256);
    }

    public void func_230430_a_(MatrixStack matrices, int mouseX, int mouseY, float delta) {
        this.drawCustomBackground(matrices);
        assert (this.field_230706_i_ != null);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_230706_i_.func_110434_K().func_110577_a(TEXTURE);
        int titleHeight = 10;
        block11: for (VehicleInventoryDescription.Slot slot : ((VehicleScreenHandler)this.field_147002_h).getVehicle().getInventoryDescription().getSlots()) {
            switch (slot.type) {
                case INVENTORY: {
                    this.drawImage(matrices, this.field_147003_i + slot.x - 1, this.field_147009_r + titleHeight + slot.y - 1, 284, 0, 18, 18);
                    continue block11;
                }
                case BOILER: {
                    this.drawImage(matrices, this.field_147003_i + slot.x - 4, this.field_147009_r + titleHeight + slot.y - 18, 318, 0, 24, 39);
                    if (!(((VehicleScreenHandler)this.field_147002_h).getVehicle() instanceof EngineAircraft) || !((double)((EngineAircraft)((VehicleScreenHandler)this.field_147002_h).getVehicle()).getFuelUtilization() > 0.0)) continue block11;
                    this.drawImage(matrices, this.field_147003_i + slot.x - 4, this.field_147009_r + titleHeight + slot.y - 18, 348, 0, 24, 39);
                    continue block11;
                }
            }
            if (((VehicleScreenHandler)this.field_147002_h).getVehicle().getInventory().func_70301_a(slot.index).func_190926_b()) {
                switch (slot.type) {
                    case WEAPON: {
                        this.drawImage(matrices, this.field_147003_i + slot.x - 3, this.field_147009_r + titleHeight + slot.y - 3, 262, 22, 22, 22);
                        break;
                    }
                    case UPGRADE: {
                        this.drawImage(matrices, this.field_147003_i + slot.x - 3, this.field_147009_r + titleHeight + slot.y - 3, 262, 44, 22, 22);
                        break;
                    }
                    case BANNER: {
                        this.drawImage(matrices, this.field_147003_i + slot.x - 3, this.field_147009_r + titleHeight + slot.y - 3, 262, 66, 22, 22);
                        break;
                    }
                    case DYE: {
                        this.drawImage(matrices, this.field_147003_i + slot.x - 3, this.field_147009_r + titleHeight + slot.y - 3, 262, 88, 22, 22);
                        break;
                    }
                    case BOOSTER: {
                        this.drawImage(matrices, this.field_147003_i + slot.x - 3, this.field_147009_r + titleHeight + slot.y - 3, 262, 110, 22, 22);
                    }
                }
                continue;
            }
            this.drawImage(matrices, this.field_147003_i + slot.x - 3, this.field_147009_r + titleHeight + slot.y - 3, 262, 0, 22, 22);
        }
        super.func_230430_a_(matrices, mouseX, mouseY, delta);
        if (this.field_147006_u != null && !this.field_147006_u.func_75216_d() && this.field_147006_u.field_75224_c == ((VehicleScreenHandler)this.field_147002_h).getVehicle().getInventory()) {
            VehicleInventoryDescription.Slot slot = ((VehicleScreenHandler)this.field_147002_h).getVehicle().getInventoryDescription().getSlots().get(((SlotAccessorMixin)this.field_147006_u).getIndex());
            if (slot.type == VehicleInventoryDescription.SlotType.DYE || slot.type == VehicleInventoryDescription.SlotType.BOOSTER || slot.type == VehicleInventoryDescription.SlotType.BOILER || slot.type == VehicleInventoryDescription.SlotType.UPGRADE || slot.type == VehicleInventoryDescription.SlotType.BANNER || slot.type == VehicleInventoryDescription.SlotType.WEAPON) {
                this.func_243308_b(matrices, Collections.singletonList(new TranslationTextComponent("immersive_aircraft.slot." + slot.type.name().toLowerCase(Locale.ROOT))), mouseX, mouseY);
            }
        } else {
            this.func_230459_a_(matrices, mouseX, mouseY);
        }
    }

    protected void func_231160_c_() {
        super.func_231160_c_();
        this.field_238742_p_ = (this.field_146999_f - this.field_230712_o_.func_238414_a_((ITextProperties)this.field_230704_d_)) / 2;
    }

    protected boolean func_195361_a(double mouseX, double mouseY, int left, int top, int button) {
        if (super.func_195361_a(mouseX, mouseY, left, top, button)) {
            for (VehicleInventoryDescription.Rectangle rectangle : ((VehicleScreenHandler)this.field_147002_h).getVehicle().getInventoryDescription().getRectangles()) {
                if (!(mouseX > (double)(rectangle.x() + this.field_147003_i)) || !(mouseX < (double)(rectangle.x() + rectangle.w() + this.field_147003_i)) || !(mouseY > (double)(rectangle.y() + this.field_147009_r)) || !(mouseY < (double)(rectangle.y() + rectangle.h() + this.field_147009_r))) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

