/*
 * Decompiled with CFR 0.152.
 */
package immersive_aircraft.client.render.entity.renderer;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.mojang.datafixers.util.Pair;
import immersive_aircraft.client.render.entity.renderer.TrailRenderer;
import immersive_aircraft.entity.AircraftEntity;
import immersive_aircraft.entity.VehicleEntity;
import immersive_aircraft.resources.ObjectLoader;
import immersive_aircraft.util.obj.Face;
import immersive_aircraft.util.obj.FaceVertex;
import immersive_aircraft.util.obj.Mesh;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.renderer.Atlases;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.culling.ClippingHelper;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.model.RenderMaterial;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.Entity;
import net.minecraft.item.DyeColor;
import net.minecraft.tileentity.BannerPattern;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Matrix3f;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3f;

public abstract class AircraftEntityRenderer<T extends AircraftEntity>
extends EntityRenderer<T> {
    public AircraftEntityRenderer(EntityRendererManager entityRenderDispatcher) {
        super(entityRenderDispatcher);
    }

    protected abstract Model getModel(AircraftEntity var1);

    protected abstract Vector3f getPivot(AircraftEntity var1);

    public void render(T entity, float yaw, float tickDelta, MatrixStack matrixStack, IRenderTypeBuffer vertexConsumerProvider, int light) {
        MatrixStack.Entry peek = matrixStack.func_227866_c_();
        matrixStack.func_227860_a_();
        float h = (float)((VehicleEntity)((java.lang.Object)entity)).getDamageWobbleTicks() - tickDelta;
        float j = ((VehicleEntity)((java.lang.Object)entity)).getDamageWobbleStrength() - tickDelta;
        if (j < 0.0f) {
            j = 0.0f;
        }
        if (h > 0.0f) {
            matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(MathHelper.func_76126_a((float)h) * h * j / 10.0f * (float)((VehicleEntity)((java.lang.Object)entity)).getDamageWobbleSide()));
        }
        Vector3f effect = entity.func_233570_aj_() ? new Vector3f() : ((AircraftEntity)((java.lang.Object)entity)).getWindEffect();
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(-yaw));
        matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(entity.func_195050_f(tickDelta) + effect.func_195902_c()));
        matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(((VehicleEntity)((java.lang.Object)entity)).getRoll(tickDelta) + effect.func_195899_a()));
        Vector3f pivot = this.getPivot((AircraftEntity)((java.lang.Object)entity));
        matrixStack.func_227861_a_((double)pivot.func_195899_a(), (double)pivot.func_195900_b(), (double)pivot.func_195902_c());
        Model model = this.getModel((AircraftEntity)((java.lang.Object)entity));
        for (Object object : model.getObjects()) {
            if (object.getAnimationConsumer() != null) {
                matrixStack.func_227860_a_();
                object.getAnimationConsumer().run(entity, yaw, tickDelta, matrixStack);
            }
            object.getRenderConsumer().run(vertexConsumerProvider, entity, matrixStack, light, tickDelta);
            if (object.getAnimationConsumer() == null) continue;
            matrixStack.func_227865_b_();
        }
        ((AircraftEntity)((java.lang.Object)entity)).getTrails().forEach(t -> TrailRenderer.render(t, vertexConsumerProvider, peek));
        matrixStack.func_227865_b_();
        super.func_225623_a_(entity, yaw, tickDelta, matrixStack, vertexConsumerProvider, light);
    }

    protected static void renderObject(Mesh mesh, MatrixStack matrixStack, IVertexBuilder vertexConsumer, int light) {
        AircraftEntityRenderer.renderObject(mesh, matrixStack, vertexConsumer, light, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    protected static void renderObject(Mesh mesh, MatrixStack matrixStack, IVertexBuilder vertexConsumer, int light, float r, float g, float b, float a) {
        MatrixStack.Entry entry = matrixStack.func_227866_c_();
        Matrix4f positionMatrix = entry.func_227870_a_();
        Matrix3f normalMatrix = entry.func_227872_b_();
        for (Face face : mesh.faces) {
            if (face.vertices.size() != 4) continue;
            for (FaceVertex v : face.vertices) {
                vertexConsumer.func_227888_a_(positionMatrix, v.v.x, v.v.y, v.v.z).func_227885_a_(r, g, b, a).func_225583_a_(v.t.u, v.t.v).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(light).func_227887_a_(normalMatrix, v.n.x, v.n.y, v.n.z).func_181675_d();
            }
        }
    }

    protected static void renderSailObject(Mesh mesh, MatrixStack matrixStack, IVertexBuilder vertexConsumer, int light, double time) {
        AircraftEntityRenderer.renderSailObject(mesh, matrixStack, vertexConsumer, light, time, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    protected static void renderSailObject(Mesh mesh, MatrixStack matrixStack, IVertexBuilder vertexConsumer, int light, double time, float r, float g, float b, float a) {
        MatrixStack.Entry entry = matrixStack.func_227866_c_();
        Matrix4f positionMatrix = entry.func_227870_a_();
        Matrix3f normalMatrix = entry.func_227872_b_();
        for (Face face : mesh.faces) {
            if (face.vertices.size() != 4) continue;
            for (FaceVertex v : face.vertices) {
                double angle = (double)(v.v.x + v.v.z) + (double)v.v.y * 0.25 + time * 0.25;
                double scale = 0.05;
                float x = (float)((double)v.v.x + (Math.cos(angle) + Math.cos(angle * 1.7)) * scale * (double)v.c.r);
                float z = (float)((double)v.v.z + (Math.sin(angle) + Math.sin(angle * 1.7)) * scale * (double)v.c.r);
                vertexConsumer.func_227888_a_(positionMatrix, x, v.v.y, z).func_227885_a_(r, g, b, a).func_225583_a_(v.t.u, v.t.v).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(light).func_227887_a_(normalMatrix, v.n.x, v.n.y, v.n.z).func_181675_d();
            }
        }
    }

    static void renderBanner(MatrixStack matrixStack, IRenderTypeBuffer vertexConsumers, int light, Mesh mesh, boolean isBanner, List<Pair<BannerPattern, DyeColor>> patterns) {
        for (int i = 0; i < 17 && i < patterns.size(); ++i) {
            Pair<BannerPattern, DyeColor> pair = patterns.get(i);
            float[] fs = ((DyeColor)pair.getSecond()).func_193349_f();
            BannerPattern bannerPattern = (BannerPattern)pair.getFirst();
            RenderMaterial spriteIdentifier = new RenderMaterial(isBanner ? Atlases.field_228744_c_ : Atlases.field_228745_d_, bannerPattern.func_226957_a_(isBanner));
            IVertexBuilder vertexConsumer = spriteIdentifier.func_229311_a_(vertexConsumers, RenderType::func_228650_h_);
            TextureAtlasSprite sprite = spriteIdentifier.func_229314_c_();
            MatrixStack.Entry entry = matrixStack.func_227866_c_();
            Matrix4f positionMatrix = entry.func_227870_a_();
            Matrix3f normalMatrix = entry.func_227872_b_();
            for (Face face : mesh.faces) {
                if (face.vertices.size() != 4) continue;
                for (FaceVertex v : face.vertices) {
                    vertexConsumer.func_227888_a_(positionMatrix, v.v.x, v.v.y, v.v.z).func_227885_a_(fs[0], fs[1], fs[2], 1.0f).func_225583_a_(v.t.u * (sprite.func_94212_f() - sprite.func_94209_e()) + sprite.func_94209_e(), v.t.v * (sprite.func_94210_h() - sprite.func_94206_g()) + sprite.func_94206_g()).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(light).func_227887_a_(normalMatrix, v.n.x, v.n.y, v.n.z).func_181675_d();
                }
            }
        }
    }

    protected static Mesh getFaces(ResourceLocation id, String object) {
        return ObjectLoader.objects.get(id).get(object);
    }

    public boolean shouldRender(T entity, ClippingHelper frustum, double x, double y, double z) {
        if (!entity.func_145770_h(x, y, z)) {
            return false;
        }
        AxisAlignedBB box = entity.func_184177_bl().func_186662_g(2.5);
        return frustum.func_228957_a_(box);
    }

    protected class Model {
        private final List<Object> objects = new LinkedList<Object>();

        public Model add(Object o) {
            this.objects.add(o);
            return this;
        }

        public List<Object> getObjects() {
            return this.objects;
        }
    }

    protected class Object {
        private final ResourceLocation id;
        private final String object;
        private AnimationConsumer<T> animationConsumer = null;
        private RenderConsumer<T> renderConsumer = (vertexConsumerProvider, entity, matrixStack, light, tickDelta) -> {
            ResourceLocation identifier = AircraftEntityRenderer.this.func_110775_a((Entity)entity);
            IVertexBuilder vertexConsumer = vertexConsumerProvider.getBuffer(RenderType.func_228638_b_((ResourceLocation)identifier));
            AircraftEntityRenderer.renderObject(this.getMesh(), matrixStack, vertexConsumer, light);
        };

        public Object(ResourceLocation id, String object) {
            this.id = id;
            this.object = object;
        }

        public Mesh getMesh() {
            Mesh mesh = AircraftEntityRenderer.getFaces(this.id, this.object);
            if (mesh == null) {
                throw new RuntimeException(String.format("Mesh %s in %s does not exist!", this.id, this.object));
            }
            return mesh;
        }

        public ResourceLocation getId() {
            return this.id;
        }

        public AnimationConsumer<T> getAnimationConsumer() {
            return this.animationConsumer;
        }

        public Object setAnimationConsumer(AnimationConsumer<T> animationConsumer) {
            this.animationConsumer = animationConsumer;
            return this;
        }

        public RenderConsumer<T> getRenderConsumer() {
            return this.renderConsumer;
        }

        public Object setRenderConsumer(RenderConsumer<T> renderConsumer) {
            this.renderConsumer = renderConsumer;
            return this;
        }
    }

    public static interface AnimationConsumer<T> {
        public void run(T var1, float var2, float var3, MatrixStack var4);
    }

    public static interface RenderConsumer<T> {
        public void run(IRenderTypeBuffer var1, T var2, MatrixStack var3, int var4, float var5);
    }
}

