/*
 * Decompiled with CFR 0.152.
 */
package immersive_aircraft.client.render.entity.renderer;

import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.mojang.datafixers.util.Pair;
import immersive_aircraft.Main;
import immersive_aircraft.client.render.entity.renderer.AircraftEntityRenderer;
import immersive_aircraft.config.Config;
import immersive_aircraft.entity.AircraftEntity;
import immersive_aircraft.entity.AirshipEntity;
import immersive_aircraft.entity.misc.VehicleInventoryDescription;
import immersive_aircraft.util.Utils;
import immersive_aircraft.util.obj.Mesh;
import java.util.List;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.item.BannerItem;
import net.minecraft.item.DyeColor;
import net.minecraft.item.DyeItem;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.BannerPattern;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3f;

public class AirshipEntityRenderer<T extends AirshipEntity>
extends AircraftEntityRenderer<T> {
    private static final ResourceLocation id = Main.locate("objects/airship.obj");
    private final ResourceLocation texture = Main.locate("textures/entity/airship.png");
    private final AircraftEntityRenderer.Model model = new AircraftEntityRenderer.Model().add(new AircraftEntityRenderer.Object(id, "frame")).add(new AircraftEntityRenderer.Object(id, "banners").setRenderConsumer((vertexConsumerProvider, entity, matrixStack, light, tickDelta) -> {
        List<ItemStack> slots = entity.getSlots(VehicleInventoryDescription.SlotType.BANNER);
        int i = 0;
        for (ItemStack slot : slots) {
            if (slot.func_190926_b() || !(slot.func_77973_b() instanceof BannerItem)) continue;
            List<Pair<BannerPattern, DyeColor>> patterns = Utils.parseBannerItem(slot);
            Mesh mesh = AirshipEntityRenderer.getFaces(id, "banner_" + i++);
            AirshipEntityRenderer.renderBanner(matrixStack, vertexConsumerProvider, light, mesh, true, patterns);
        }
    })).add(new AircraftEntityRenderer.Object(id, "sails").setRenderConsumer((vertexConsumerProvider, entity, matrixStack, light, tickDelta) -> {
        DyeColor color;
        ResourceLocation identifier = this.getTexture(entity);
        IVertexBuilder vertexConsumer = vertexConsumerProvider.getBuffer(RenderType.func_228640_c_((ResourceLocation)identifier));
        ItemStack stack = entity.getSlots(VehicleInventoryDescription.SlotType.DYE).get(0);
        if (stack.func_77973_b() instanceof DyeItem) {
            DyeItem item = (DyeItem)stack.func_77973_b();
            color = item.func_195962_g();
        } else {
            color = DyeColor.WHITE;
        }
        float r = color.func_193349_f()[0];
        float g = color.func_193349_f()[1];
        float b = color.func_193349_f()[2];
        if (entity.isWithinParticleRange() && Config.getInstance().enableAnimatedSails) {
            Mesh mesh = AirshipEntityRenderer.getFaces(id, "sails_animated");
            float time = (float)(entity.field_70170_p.func_82737_E() % 24000L) + tickDelta;
            AirshipEntityRenderer.renderSailObject(mesh, matrixStack, vertexConsumer, light, time, r, g, b, 1.0f);
        } else {
            Mesh mesh = AirshipEntityRenderer.getFaces(id, "sails");
            AirshipEntityRenderer.renderObject(mesh, matrixStack, vertexConsumer, light, r, g, b, 1.0f);
        }
    })).add(new AircraftEntityRenderer.Object(id, "controller").setAnimationConsumer((entity, yaw, tickDelta, matrixStack) -> {
        matrixStack.func_227861_a_(0.0, -0.125, 0.78125);
        matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(-entity.pressingInterpolatedX.getSmooth(tickDelta) * 20.0f));
        matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(entity.pressingInterpolatedZ.getSmooth(tickDelta) * 30.0f));
        matrixStack.func_227861_a_(0.0, 0.125, -0.90625);
    })).add(new AircraftEntityRenderer.Object(id, "propeller").setAnimationConsumer((entity, yaw, tickDelta, matrixStack) -> {
        matrixStack.func_227861_a_(0.0, 0.1875, 0.0);
        matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_((float)((double)(-entity.engineRotation.getSmooth(tickDelta)) * 100.0)));
        matrixStack.func_227861_a_(0.0, -0.1875, 0.0);
    }).setRenderConsumer((vertexConsumerProvider, entity, matrixStack, light, tickDelta) -> {
        ResourceLocation identifier = this.getTexture(entity);
        IVertexBuilder vertexConsumer = vertexConsumerProvider.getBuffer(RenderType.func_228640_c_((ResourceLocation)identifier));
        Mesh mesh = AirshipEntityRenderer.getFaces(id, "propeller");
        AirshipEntityRenderer.renderObject(mesh, matrixStack, vertexConsumer, light);
    }));

    public AirshipEntityRenderer(EntityRendererManager entityRenderDispatcher) {
        super(entityRenderDispatcher);
        this.field_76989_e = 0.8f;
    }

    public ResourceLocation getTexture(T entity) {
        return this.texture;
    }

    @Override
    public AircraftEntityRenderer.Model getModel(AircraftEntity entity) {
        return this.model;
    }

    @Override
    public Vector3f getPivot(AircraftEntity entity) {
        return new Vector3f(0.0f, 0.2f, 0.0f);
    }
}

