/*
 * Decompiled with CFR 0.152.
 */
package immersive_aircraft.client.render.entity.renderer;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.datafixers.util.Pair;
import immersive_aircraft.Main;
import immersive_aircraft.client.render.entity.renderer.AircraftEntityRenderer;
import immersive_aircraft.entity.AircraftEntity;
import immersive_aircraft.entity.BiplaneEntity;
import immersive_aircraft.entity.misc.VehicleInventoryDescription;
import immersive_aircraft.util.Utils;
import immersive_aircraft.util.obj.Mesh;
import java.util.List;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.item.BannerItem;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.BannerPattern;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3f;

public class BiplaneEntityRenderer<T extends BiplaneEntity>
extends AircraftEntityRenderer<T> {
    private static final ResourceLocation id = Main.locate("objects/biplane.obj");
    private final ResourceLocation texture;
    private final AircraftEntityRenderer.Model model = new AircraftEntityRenderer.Model().add(new AircraftEntityRenderer.Object(id, "frame")).add(new AircraftEntityRenderer.Object(id, "banners").setRenderConsumer((vertexConsumerProvider, entity, matrixStack, light, tickDelta) -> {
        List<ItemStack> slots = entity.getSlots(VehicleInventoryDescription.SlotType.BANNER);
        int i = 0;
        for (ItemStack slot : slots) {
            if (slot.func_190926_b() || !(slot.func_77973_b() instanceof BannerItem)) continue;
            List<Pair<BannerPattern, DyeColor>> patterns = Utils.parseBannerItem(slot);
            Mesh mesh = BiplaneEntityRenderer.getFaces(id, "banner_" + i++);
            BiplaneEntityRenderer.renderBanner(matrixStack, vertexConsumerProvider, light, mesh, true, patterns);
        }
    })).add(new AircraftEntityRenderer.Object(id, "propeller").setAnimationConsumer((entity, yaw, tickDelta, matrixStack) -> {
        matrixStack.func_227861_a_(0.0, 0.3125, 0.0);
        matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_((float)((double)entity.engineRotation.getSmooth(tickDelta) * 100.0)));
        matrixStack.func_227861_a_(0.0, -0.3125, 0.0);
    })).add(new AircraftEntityRenderer.Object(id, "elevator").setAnimationConsumer((entity, yaw, tickDelta, matrixStack) -> {
        matrixStack.func_227861_a_(0.0, 0.0625, -2.5);
        matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(-entity.pressingInterpolatedZ.getSmooth(tickDelta) * 20.0f));
        matrixStack.func_227861_a_(0.0, -0.0625, 2.5);
    })).add(new AircraftEntityRenderer.Object(id, "rudder").setAnimationConsumer((entity, yaw, tickDelta, matrixStack) -> {
        matrixStack.func_227861_a_(0.0, 0.0625, -2.5);
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(entity.pressingInterpolatedX.getSmooth(tickDelta) * 18.0f));
        matrixStack.func_227861_a_(0.0, -0.0625, 2.5);
    }));

    public BiplaneEntityRenderer(EntityRendererManager entityRenderDispatcher) {
        super(entityRenderDispatcher);
        this.field_76989_e = 0.8f;
        this.texture = Main.locate("textures/entity/biplane.png");
    }

    @Override
    public void render(T entity, float yaw, float tickDelta, MatrixStack matrixStack, IRenderTypeBuffer vertexConsumerProvider, int i) {
        super.render(entity, yaw, tickDelta, matrixStack, vertexConsumerProvider, i);
    }

    public ResourceLocation getTexture(T entity) {
        return this.texture;
    }

    @Override
    protected AircraftEntityRenderer.Model getModel(AircraftEntity entity) {
        return this.model;
    }

    @Override
    protected Vector3f getPivot(AircraftEntity entity) {
        return new Vector3f(0.0f, 0.4f, 0.05f);
    }
}

