/*
 * Decompiled with CFR 0.152.
 */
package immersive_aircraft.client.render.entity.renderer;

import com.mojang.blaze3d.vertex.IVertexBuilder;
import immersive_aircraft.Main;
import immersive_aircraft.client.render.entity.renderer.AircraftEntityRenderer;
import immersive_aircraft.entity.AircraftEntity;
import immersive_aircraft.entity.QuadrocopterEntity;
import immersive_aircraft.util.obj.Mesh;
import java.util.Random;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3f;

public class QuadrocopterEntityRenderer<T extends QuadrocopterEntity>
extends AircraftEntityRenderer<T> {
    private static final ResourceLocation id = Main.locate("objects/quadrocopter.obj");
    private final ResourceLocation texture = Main.locate("textures/entity/quadrocopter.png");
    private final Random random = new Random();
    private static final float[][] PROPELLERS = new float[][]{{1.25f, 0.53125f, 0.65625f}, {-1.25f, 0.53125f, 0.65625f}, {1.25f, 0.53125f, -0.71875f}, {-1.25f, 0.53125f, -0.71875f}};
    private final AircraftEntityRenderer.Model model = new AircraftEntityRenderer.Model(this).add(new AircraftEntityRenderer.Object(this, id, "frame")).add(new AircraftEntityRenderer.Object(this, id, "engine").setAnimationConsumer((entity, yaw, tickDelta, matrixStack) -> {
        double p = (double)entity.enginePower.getSmooth() / 128.0;
        matrixStack.func_227861_a_((this.random.nextDouble() - 0.5) * p, (this.random.nextDouble() - 0.5) * p, (this.random.nextDouble() - 0.5) * p);
    }).setRenderConsumer((vertexConsumerProvider, entity, matrixStack, light, tickDelta) -> {
        ResourceLocation identifier = this.getTexture(entity);
        IVertexBuilder vertexConsumer = vertexConsumerProvider.getBuffer(RenderType.func_228640_c_((ResourceLocation)identifier));
        Mesh mesh = QuadrocopterEntityRenderer.getFaces(id, "engine_" + ((double)entity.enginePower.getSmooth() > 0.01 ? entity.field_70173_aa % 2 : 0));
        QuadrocopterEntityRenderer.renderObject(mesh, matrixStack, vertexConsumer, light);
    }));

    public QuadrocopterEntityRenderer(EntityRendererManager entityRenderDispatcher) {
        super(entityRenderDispatcher);
        for (float[] propeller : PROPELLERS) {
            this.model.add(new AircraftEntityRenderer.Object(this, id, "propeller").setAnimationConsumer((entity, yaw, tickDelta, matrixStack) -> {
                matrixStack.func_227861_a_((double)propeller[0], (double)propeller[1], (double)propeller[2]);
                matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(entity.engineRotation.getSmooth(tickDelta) * propeller[0] * propeller[2] * 200.0f));
            }).setRenderConsumer((vertexConsumerProvider, entity, matrixStack, light, tickDelta) -> {
                ResourceLocation identifier = this.getTexture(entity);
                IVertexBuilder vertexConsumer = vertexConsumerProvider.getBuffer(RenderType.func_228640_c_((ResourceLocation)identifier));
                Mesh mesh = QuadrocopterEntityRenderer.getFaces(id, "propeller");
                QuadrocopterEntityRenderer.renderObject(mesh, matrixStack, vertexConsumer, light);
            }));
        }
        this.field_76989_e = 0.8f;
    }

    public ResourceLocation getTexture(T AircraftEntity2) {
        return this.texture;
    }

    @Override
    protected AircraftEntityRenderer.Model getModel(AircraftEntity entity) {
        return this.model;
    }

    @Override
    protected Vector3f getPivot(AircraftEntity entity) {
        return new Vector3f(0.0f, 0.0f, 0.0f);
    }
}

