/*
 * Decompiled with CFR 0.152.
 */
package immersive_aircraft.client.render.entity.renderer;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import immersive_aircraft.Main;
import immersive_aircraft.entity.misc.Trail;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Matrix3f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;

public class TrailRenderer {
    private static final ResourceLocation identifier = Main.locate("textures/entity/trail.png");

    public static void render(Trail trail, IRenderTypeBuffer vertexConsumerProvider, MatrixStack.Entry matrices) {
        if (trail.nullEntries >= trail.size || trail.entries == 0) {
            return;
        }
        IVertexBuilder lineVertexConsumer = vertexConsumerProvider.getBuffer(RenderType.func_228637_a_((ResourceLocation)identifier, (boolean)true));
        int light = 0xF00000;
        Vector3d pos = Minecraft.func_71410_x().field_71460_t.func_215316_n().func_216785_c();
        Matrix3f matrix = matrices.func_227872_b_();
        for (int i = 1; i < Math.min(trail.entries, trail.size); ++i) {
            int pre = (i + trail.lastIndex - 1) % trail.size * 7;
            int index = (i + trail.lastIndex) % trail.size * 7;
            int a1 = (int)((1.0f - (float)i / (float)trail.size * 255.0f) * trail.buffer[pre + 6]);
            int a2 = i == trail.size - 1 ? 0 : (int)((1.0f - ((float)i + 1.0f) / (float)trail.size * 255.0f) * trail.buffer[index + 6]);
            TrailRenderer.vertex(trail, lineVertexConsumer, matrix, 0.0f, 0.0f, pre, pos, a1, light);
            TrailRenderer.vertex(trail, lineVertexConsumer, matrix, 0.0f, 1.0f, pre + 3, pos, a1, light);
            TrailRenderer.vertex(trail, lineVertexConsumer, matrix, 1.0f, 1.0f, index + 3, pos, a2, light);
            TrailRenderer.vertex(trail, lineVertexConsumer, matrix, 1.0f, 0.0f, index, pos, a2, light);
            TrailRenderer.vertex(trail, lineVertexConsumer, matrix, 1.0f, 0.0f, index, pos, a2, light);
            TrailRenderer.vertex(trail, lineVertexConsumer, matrix, 1.0f, 1.0f, index + 3, pos, a2, light);
            TrailRenderer.vertex(trail, lineVertexConsumer, matrix, 0.0f, 1.0f, pre + 3, pos, a1, light);
            TrailRenderer.vertex(trail, lineVertexConsumer, matrix, 0.0f, 0.0f, pre, pos, a1, light);
        }
    }

    private static void vertex(Trail trail, IVertexBuilder lineVertexConsumer, Matrix3f matrix, float u, float v, int index, Vector3d pos, float a, int light) {
        Vector3f p = new Vector3f((float)((double)trail.buffer[index] - pos.field_72450_a), (float)((double)trail.buffer[index + 1] - pos.field_72448_b), (float)((double)trail.buffer[index + 2] - pos.field_72449_c));
        p.func_229188_a_(matrix);
        lineVertexConsumer.func_225588_a_(p.func_195899_a(), p.func_195900_b(), p.func_195902_c(), trail.gray, trail.gray, trail.gray, a, u, v, OverlayTexture.field_229196_a_, light, 1.0f, 0.0f, 0.0f);
    }
}

