/*
 * Decompiled with CFR 0.152.
 */
package immersive_aircraft.config;

import immersive_aircraft.config.Config;
import immersive_aircraft.config.configEntries.BooleanConfigEntry;
import immersive_aircraft.config.configEntries.FloatConfigEntry;
import immersive_aircraft.config.configEntries.IntegerConfigEntry;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import me.shedaniel.clothconfig2.api.AbstractConfigListEntry;
import me.shedaniel.clothconfig2.api.ConfigBuilder;
import me.shedaniel.clothconfig2.api.ConfigCategory;
import me.shedaniel.clothconfig2.api.ConfigEntryBuilder;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class ConfigScreen {
    public static Screen getScreen() {
        Config config = Config.getInstance();
        ConfigBuilder builder = ConfigBuilder.create().setTitle((ITextComponent)new TranslationTextComponent("itemGroup.immersive_aircraft.immersive_aircraft_tab")).setSavingRunnable(config::save);
        ConfigCategory general = builder.getOrCreateCategory((ITextComponent)new TranslationTextComponent("option.immersive_aircraft.general"));
        ConfigEntryBuilder entryBuilder = builder.entryBuilder();
        for (Field field : Config.class.getDeclaredFields()) {
            for (Annotation annotation : field.getAnnotations()) {
                try {
                    Annotation entry;
                    String key = "option.immersive_aircraft." + field.getName();
                    if (annotation instanceof IntegerConfigEntry) {
                        entry = (IntegerConfigEntry)annotation;
                        general.addEntry((AbstractConfigListEntry)entryBuilder.startIntField((ITextComponent)new TranslationTextComponent(key), field.getInt(config)).setDefaultValue(entry.value()).setSaveConsumer(v -> {
                            try {
                                field.setInt(config, (int)v);
                            }
                            catch (IllegalAccessException e) {
                                throw new RuntimeException(e);
                            }
                        }).setMin(entry.min()).setMax(entry.max()).build());
                        continue;
                    }
                    if (annotation instanceof FloatConfigEntry) {
                        entry = (FloatConfigEntry)annotation;
                        general.addEntry((AbstractConfigListEntry)entryBuilder.startFloatField((ITextComponent)new TranslationTextComponent(key), field.getFloat(config)).setDefaultValue(entry.value()).setSaveConsumer(v -> {
                            try {
                                field.setFloat(config, v.floatValue());
                            }
                            catch (IllegalAccessException e) {
                                throw new RuntimeException(e);
                            }
                        }).setMin(entry.min()).setMax(entry.max()).build());
                        continue;
                    }
                    if (!(annotation instanceof BooleanConfigEntry)) continue;
                    entry = (BooleanConfigEntry)annotation;
                    general.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle((ITextComponent)new TranslationTextComponent(key), field.getBoolean(config)).setDefaultValue(entry.value()).setSaveConsumer(v -> {
                        try {
                            field.setBoolean(config, (boolean)v);
                        }
                        catch (IllegalAccessException e) {
                            throw new RuntimeException(e);
                        }
                    }).build());
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return builder.build();
    }
}

