/*
 * Decompiled with CFR 0.152.
 */
package immersive_aircraft.entity;

import immersive_aircraft.config.Config;
import immersive_aircraft.entity.InventoryVehicleEntity;
import immersive_aircraft.entity.misc.AircraftProperties;
import immersive_aircraft.entity.misc.Trail;
import immersive_aircraft.item.upgrade.AircraftStat;
import immersive_aircraft.util.Utils;
import java.util.Collections;
import java.util.List;
import net.minecraft.entity.EntityType;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.world.World;

public abstract class AircraftEntity
extends InventoryVehicleEntity {
    private double lastY;
    private static final List<Trail> TRAILS = Collections.emptyList();
    final List<List<Vector3d>> PASSENGER_POSITIONS = Collections.singletonList(Collections.singletonList(new Vector3d(0.0, 0.0, 0.0)));

    public AircraftEntity(EntityType<? extends AircraftEntity> entityType, World world) {
        super(entityType, world);
    }

    public List<Trail> getTrails() {
        return TRAILS;
    }

    public abstract AircraftProperties getProperties();

    @Override
    protected List<List<Vector3d>> getPassengerPositions() {
        return this.PASSENGER_POSITIONS;
    }

    @Override
    public void func_70071_h_() {
        this.prevRoll = this.roll;
        this.roll = this.field_70122_E ? (float)((double)this.roll * 0.9) : -this.pressingInterpolatedX.getSmooth() * this.getProperties().getRollFactor();
        if (Double.isNaN(this.func_213322_ci().field_72450_a) || Double.isNaN(this.func_213322_ci().field_72448_b) || Double.isNaN(this.func_213322_ci().field_72449_c)) {
            this.func_213293_j(0.0, 0.0, 0.0);
        }
        super.func_70071_h_();
    }

    protected void convertPower(Vector3d direction) {
        Vector3d velocity = this.func_213322_ci();
        double drag = Math.abs(direction.func_72430_b(velocity.func_72432_b()));
        this.func_213317_d(velocity.func_72432_b().func_186678_a(1.0 - (double)this.getProperties().getLift()).func_178787_e(direction.func_186678_a((double)this.getProperties().getLift())).func_186678_a(velocity.func_72433_c() * (drag * (double)this.getProperties().getDriftDrag() + (1.0 - (double)this.getProperties().getDriftDrag()))));
    }

    protected float getHorizontalVelocityDelay() {
        return 0.98f;
    }

    protected float getVerticalVelocityDelay() {
        return 0.98f;
    }

    protected float falloffGroundVelocityDecay(float original) {
        float gravity = Math.min(1.0f, Math.max(0.0f, this.getGravity() / -0.04f));
        float upgrade = Math.min(1.0f, this.getTotalUpgrade(AircraftStat.ACCELERATION) * 0.5f);
        return (original * gravity + (1.0f - gravity)) * (1.0f - upgrade) + upgrade;
    }

    protected float getGroundVelocityDecay() {
        return 0.95f;
    }

    protected float getRotationDecay() {
        return 0.98f;
    }

    @Override
    protected void updateVelocity() {
        float decay = 1.0f - 0.015f * this.getTotalUpgrade(AircraftStat.FRICTION);
        float gravity = this.getGravity();
        if (this.field_70171_ac) {
            gravity *= 0.25f;
            decay = 0.9f;
        } else if (this.field_70122_E) {
            decay = this.func_184207_aI() ? this.getGroundVelocityDecay() : 0.75f;
        }
        Vector3d direction = this.getDirection();
        double diff = this.lastY - this.func_226278_cu_();
        if (this.lastY != 0.0 && this.getProperties().getGlideFactor() > 0.0f) {
            this.func_213317_d(this.func_213322_ci().func_178787_e(direction.func_186678_a(diff * (double)this.getProperties().getGlideFactor() * (1.0 - Math.abs(direction.func_82617_b())))));
        }
        this.lastY = this.func_226278_cu_();
        this.convertPower(direction);
        Vector3d velocity = this.func_213322_ci();
        this.func_213293_j(velocity.field_72450_a * (double)decay * (double)this.getHorizontalVelocityDelay(), velocity.field_72448_b * (double)decay * (double)this.getVerticalVelocityDelay() + (double)gravity, velocity.field_72449_c * (double)decay * (double)this.getHorizontalVelocityDelay());
        this.pressingInterpolatedX.decay(0.0f, 1.0f - decay * this.getRotationDecay());
        this.pressingInterpolatedZ.decay(0.0f, 1.0f - decay * this.getRotationDecay());
        if (!this.field_70122_E) {
            Vector3f effect = this.getWindEffect();
            this.setPitch(this.getPitch() + effect.func_195899_a());
            this.setYaw(this.getYaw() + effect.func_195902_c());
            float offsetStrength = 0.005f;
            this.func_213317_d(this.func_213322_ci().func_72441_c((double)(effect.func_195899_a() * offsetStrength), 0.0, (double)(effect.func_195902_c() * offsetStrength)));
        }
    }

    @Override
    public void chill() {
        this.lastY = 0.0;
    }

    public float getWindStrength() {
        float sensitivity = this.getProperties().getWindSensitivity();
        float thundering = this.field_70170_p.func_72867_j(0.0f);
        float raining = this.field_70170_p.func_72819_i(0.0f);
        float weather = (float)((double)Config.getInstance().windClearWeather + this.func_213322_ci().func_72433_c() + (double)(thundering * Config.getInstance().windThunderWeather) + (double)(raining * Config.getInstance().windRainWeather));
        return weather * sensitivity;
    }

    public Vector3f getWindEffect() {
        float wind = this.getWindStrength();
        float nx = (float)(Utils.cosNoise((double)this.field_70173_aa / 20.0 / (double)this.getProperties().getMass()) * (double)wind);
        float nz = (float)(Utils.cosNoise((double)this.field_70173_aa / 21.0 / (double)this.getProperties().getMass()) * (double)wind);
        return new Vector3f(nx, 0.0f, nz);
    }
}

