/*
 * Decompiled with CFR 0.152.
 */
package immersive_aircraft.entity;

import immersive_aircraft.entity.AircraftEntity;
import immersive_aircraft.entity.EngineAircraft;
import immersive_aircraft.entity.misc.AircraftProperties;
import net.minecraft.entity.EntityType;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;

public abstract class AirplaneEntity
extends EngineAircraft {
    private final AircraftProperties properties = new AircraftProperties(this).setYawSpeed(5.0f).setPitchSpeed(4.0f).setEngineSpeed(0.0225f).setGlideFactor(0.05f).setDriftDrag(0.01f).setLift(0.15f).setRollFactor(45.0f).setGroundPitch(4.0f).setWindSensitivity(0.025f).setMass(1.0f);

    public AirplaneEntity(EntityType<? extends AircraftEntity> entityType, World world) {
        super(entityType, world);
    }

    @Override
    protected boolean useAirplaneControls() {
        return true;
    }

    @Override
    public AircraftProperties getProperties() {
        return this.properties;
    }

    @Override
    protected float getGroundVelocityDecay() {
        return this.falloffGroundVelocityDecay(0.9f);
    }

    @Override
    protected float getGravity() {
        Vector3d direction = this.getDirection();
        float speed = (float)((double)((float)this.func_213322_ci().func_72433_c()) * (1.0 - Math.abs(direction.func_82617_b())));
        return Math.max(0.0f, 1.0f - speed * 1.5f) * super.getGravity();
    }

    protected float getBrakeFactor() {
        return 0.95f;
    }

    @Override
    protected void updateController() {
        if (!this.func_184207_aI()) {
            return;
        }
        super.updateController();
        if (this.movementY != 0.0f) {
            this.setEngineTarget(Math.max(0.0f, Math.min(1.0f, this.getEngineTarget() + 0.1f * this.movementY)));
            if (this.movementY < 0.0f) {
                this.func_213317_d(this.func_213322_ci().func_186678_a((double)this.getBrakeFactor()));
            }
        }
        Vector3d direction = this.getDirection();
        float thrust = (float)(Math.pow(this.getEnginePower(), 2.0) * (double)this.properties.getEngineSpeed());
        this.func_213317_d(this.func_213322_ci().func_178787_e(direction.func_186678_a((double)thrust)));
    }
}

