/*
 * Decompiled with CFR 0.152.
 */
package immersive_aircraft.entity;

import immersive_aircraft.Items;
import immersive_aircraft.Sounds;
import immersive_aircraft.compat.Matrix4f;
import immersive_aircraft.compat.Vec3f;
import immersive_aircraft.compat.Vector4f;
import immersive_aircraft.entity.AircraftEntity;
import immersive_aircraft.entity.Rotorcraft;
import immersive_aircraft.entity.misc.AircraftProperties;
import immersive_aircraft.entity.misc.Trail;
import immersive_aircraft.entity.misc.VehicleInventoryDescription;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.entity.EntityType;
import net.minecraft.item.Item;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;

public class AirshipEntity
extends Rotorcraft {
    private final AircraftProperties properties = new AircraftProperties(this).setYawSpeed(5.0f).setEngineSpeed(0.02f).setVerticalSpeed(0.025f).setGlideFactor(0.0f).setDriftDrag(0.01f).setLift(0.1f).setRollFactor(5.0f).setWindSensitivity(0.05f).setMass(3.0f);
    private static final VehicleInventoryDescription inventoryDescription = new VehicleInventoryDescription().addSlot(VehicleInventoryDescription.SlotType.BOILER, 17, 44).addSlot(VehicleInventoryDescription.SlotType.WEAPON, 50, 14).addSlot(VehicleInventoryDescription.SlotType.WEAPON, 72, 14).addSlot(VehicleInventoryDescription.SlotType.UPGRADE, 50, 36).addSlot(VehicleInventoryDescription.SlotType.UPGRADE, 72, 36).addSlot(VehicleInventoryDescription.SlotType.BANNER, 50, 58).addSlot(VehicleInventoryDescription.SlotType.DYE, 72, 58).addSlots(VehicleInventoryDescription.SlotType.INVENTORY, 98, 8, 4, 4).build();
    final List<List<Vector3d>> PASSENGER_POSITIONS = Arrays.asList(Collections.singletonList(new Vector3d(0.0, (double)-0.1f, 0.0)), Arrays.asList(new Vector3d(0.0, (double)-0.1f, (double)0.4f), new Vector3d(0.0, (double)-0.1f, (double)-0.3f)));
    private final List<Trail> trails = Collections.singletonList(new Trail(15, 0.5f));

    @Override
    public VehicleInventoryDescription getInventoryDescription() {
        return inventoryDescription;
    }

    public AirshipEntity(EntityType<? extends AircraftEntity> entityType, World world) {
        super(entityType, world);
    }

    @Override
    protected float getEngineReactionSpeed() {
        return 50.0f;
    }

    @Override
    protected SoundEvent getEngineSound() {
        return Sounds.PROPELLER_SMALL.get();
    }

    @Override
    public AircraftProperties getProperties() {
        return this.properties;
    }

    @Override
    protected float getGroundVelocityDecay() {
        return 0.5f;
    }

    @Override
    protected float getHorizontalVelocityDelay() {
        return 0.97f;
    }

    @Override
    protected float getVerticalVelocityDelay() {
        return 0.925f;
    }

    @Override
    protected float getStabilizer() {
        return 0.1f;
    }

    @Override
    public Item asItem() {
        return Items.AIRSHIP.get();
    }

    @Override
    public List<Trail> getTrails() {
        return this.trails;
    }

    void trail(Matrix4f transform) {
        this.trail(transform, 0);
    }

    void trail(Matrix4f transform, int index) {
        Vector4f p0 = this.transformPosition(transform, -0.15f, 0.0f, 0.0f);
        Vector4f p1 = this.transformPosition(transform, 0.15f, 0.0f, 0.0f);
        float trailStrength = Math.max(0.0f, Math.min(1.0f, (float)(this.func_213322_ci().func_72433_c() - (double)0.05f)));
        this.getTrails().get(index).add(p0, p1, trailStrength);
    }

    @Override
    protected List<List<Vector3d>> getPassengerPositions() {
        return this.PASSENGER_POSITIONS;
    }

    @Override
    protected float getGravity() {
        return this.field_70171_ac ? 0.04f : (1.0f - this.getEnginePower()) * super.getGravity();
    }

    @Override
    protected void updateController() {
        super.updateController();
        this.setEngineTarget(1.0f);
        this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, (double)(this.getEnginePower() * this.properties.getVerticalSpeed() * this.pressingInterpolatedY.getSmooth()), 0.0));
        Vector3d direction = this.getDirection();
        float thrust = (float)(Math.pow(this.getEnginePower(), 5.0) * (double)this.properties.getEngineSpeed()) * this.pressingInterpolatedZ.getSmooth();
        this.func_213317_d(this.func_213322_ci().func_178787_e(direction.func_186678_a((double)thrust)));
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        float power = this.getEnginePower();
        if (this.field_70170_p.field_72995_K) {
            if (this.isWithinParticleRange() && (double)power > 0.01) {
                Matrix4f transform = this.getVehicleTransform();
                this.addTrails(transform);
                if (this.field_70173_aa % 2 == 0) {
                    Vector4f p = this.transformPosition(transform, (this.field_70146_Z.nextFloat() - 0.5f) * 0.4f, 0.8f, -0.8f);
                    Vector3d velocity = this.func_213322_ci();
                    this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197601_L, (double)p.getX(), (double)p.getY(), (double)p.getZ(), velocity.field_72450_a, velocity.field_72448_b, velocity.field_72449_c);
                }
            } else {
                this.trails.get(0).add(ZERO_VEC4, ZERO_VEC4, 0.0f);
            }
        }
    }

    protected void addTrails(Matrix4f transform) {
        Matrix4f tr = transform.copy();
        tr.multiplyByTranslation(0.0f, 0.4f, -1.2f);
        tr.multiply(Vec3f.POSITIVE_Z.getDegreesQuaternion(this.engineRotation.getSmooth() * 50.0f));
        this.trail(tr);
    }
}

