/*
 * Decompiled with CFR 0.152.
 */
package immersive_aircraft.entity;

import immersive_aircraft.Sounds;
import immersive_aircraft.cobalt.network.NetworkHandler;
import immersive_aircraft.config.Config;
import immersive_aircraft.entity.AircraftEntity;
import immersive_aircraft.entity.misc.VehicleInventoryDescription;
import immersive_aircraft.item.upgrade.AircraftStat;
import immersive_aircraft.network.c2s.EnginePowerMessage;
import immersive_aircraft.util.InterpolatedFloat;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.tileentity.AbstractFurnaceTileEntity;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public abstract class EngineAircraft
extends AircraftEntity {
    protected static final DataParameter<Float> ENGINE = EntityDataManager.func_187226_a(EngineAircraft.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> UTILIZATION = EntityDataManager.func_187226_a(EngineAircraft.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Boolean> LOW_ON_FUEL = EntityDataManager.func_187226_a(EngineAircraft.class, (IDataSerializer)DataSerializers.field_187198_h);
    public final InterpolatedFloat engineRotation = new InterpolatedFloat();
    public final InterpolatedFloat enginePower = new InterpolatedFloat(20.0f);
    public float engineSpinUpStrength = 0.0f;
    public float engineSound = 0.0f;
    FuelState lastFuelState = FuelState.NEVER;
    public static final int TARGET_FUEL = 1000;
    public static final int LOW_FUEL = 900;
    private final int[] fuel = new int[this.getInventoryDescription().getSlots(VehicleInventoryDescription.SlotType.BOILER).size()];
    public static Map<Item, Integer> cachedFuels;

    public GUI_STYLE getGuiStyle() {
        return GUI_STYLE.ENGINE;
    }

    public EngineAircraft(EntityType<? extends AircraftEntity> entityType, World world) {
        super(entityType, world);
    }

    protected SoundEvent getEngineStartSound() {
        return Sounds.ENGINE_START.get();
    }

    protected SoundEvent getEngineSound() {
        return Sounds.PROPELLER.get();
    }

    protected float getEnginePitch() {
        return 1.0f;
    }

    protected float getStabilizer() {
        return 0.0f;
    }

    protected float getBaseFuelConsumption() {
        return 0.75f;
    }

    protected float getEngineReactionSpeed() {
        return 20.0f;
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(ENGINE, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(UTILIZATION, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(LOW_ON_FUEL, (Object)false);
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        this.enginePower.setSteps(this.getEngineReactionSpeed() / this.getTotalUpgrade(AircraftStat.ACCELERATION));
        this.enginePower.update(this.getEngineTarget() * (this.field_70171_ac ? 0.1f : 1.0f));
        this.engineSpinUpStrength = Math.max(0.0f, this.engineSpinUpStrength + this.enginePower.getDiff() - 0.01f);
        if (this.field_70170_p.func_201670_d()) {
            this.engineRotation.update((this.engineRotation.getValue() + this.getEnginePower()) % 1000.0f);
        }
        if (!this.func_184207_aI() && this.getEngineTarget() > 0.0f) {
            this.setEngineTarget(0.0f);
        }
        if (this.field_70170_p.field_72995_K) {
            this.engineSound += this.getEnginePower() * 0.25f;
            if (this.engineSound > 1.0f) {
                this.engineSound -= 1.0f;
                if (this.isFuelLow()) {
                    this.engineSound -= (float)this.field_70146_Z.nextInt(2);
                }
                this.field_70170_p.func_184134_a(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), this.getEngineSound(), this.func_184176_by(), Math.min(1.0f, 0.25f + this.engineSpinUpStrength), (this.field_70146_Z.nextFloat() * 0.1f + 0.95f) * this.getEnginePitch(), false);
            }
        }
        if (this.fuel.length > 0 && !this.field_70170_p.field_72995_K) {
            for (float consumption = this.getFuelConsumption(); consumption > 0.0f && (consumption >= 1.0f || this.field_70146_Z.nextFloat() < consumption); consumption -= 1.0f) {
                for (int i = 0; i < this.fuel.length; ++i) {
                    if (this.fuel[i] <= 0) continue;
                    int n = i;
                    this.fuel[n] = this.fuel[n] - 1;
                }
            }
        }
        if (this.func_184207_aI()) {
            this.refuel();
            if (this.func_184179_bs() instanceof ServerPlayerEntity) {
                ServerPlayerEntity player = (ServerPlayerEntity)this.func_184179_bs();
                float utilization = this.getFuelUtilization();
                if (utilization > 0.0f && this.isFuelLow()) {
                    if (this.lastFuelState != FuelState.LOW) {
                        player.func_146105_b((ITextComponent)new TranslationTextComponent("immersive_aircraft." + this.getFuelType() + ".low"), true);
                        this.lastFuelState = FuelState.LOW;
                    }
                } else if (utilization > 0.0f) {
                    this.lastFuelState = FuelState.FUELED;
                } else if (this.lastFuelState != FuelState.EMPTY) {
                    player.func_146105_b((ITextComponent)new TranslationTextComponent("immersive_aircraft." + this.getFuelType() + "." + (this.lastFuelState == FuelState.FUELED ? "out" : "none")), true);
                    this.lastFuelState = FuelState.EMPTY;
                }
            }
        } else {
            this.lastFuelState = FuelState.NEVER;
        }
    }

    protected boolean isFuelLow() {
        if (this.field_70170_p.field_72995_K) {
            return (Boolean)this.field_70180_af.func_187225_a(LOW_ON_FUEL);
        }
        boolean low = true;
        for (int i : this.fuel) {
            if (i <= 900) continue;
            low = false;
            break;
        }
        this.field_70180_af.func_187227_b(LOW_ON_FUEL, (Object)low);
        return low;
    }

    protected String getFuelType() {
        return "fuel";
    }

    float getFuelConsumption() {
        return this.getEngineTarget() * this.getTotalUpgrade(AircraftStat.FUEL) * this.getBaseFuelConsumption() * Config.getInstance().fuelConsumption;
    }

    private void refuel(int i) {
        while (this.fuel[i] <= 1000) {
            List<VehicleInventoryDescription.Slot> slots = this.getInventoryDescription().getSlots(VehicleInventoryDescription.SlotType.BOILER);
            ItemStack stack = this.inventory.func_70301_a(slots.get((int)i).index);
            int time = EngineAircraft.getFuelTime(stack);
            if (time <= 0) break;
            int n = i;
            this.fuel[n] = this.fuel[n] + time;
            Item item = stack.func_77973_b();
            stack.func_190918_g(1);
            if (!stack.func_190926_b()) continue;
            Item item2 = item.func_77668_q();
            this.inventory.func_70299_a(slots.get((int)i).index, item2 == null ? ItemStack.field_190927_a : new ItemStack((IItemProvider)item2));
        }
    }

    private void refuel() {
        for (int i = 0; i < this.fuel.length; ++i) {
            this.refuel(i);
        }
    }

    @Override
    protected void updateController() {
        this.setYaw(this.getYaw() - this.getProperties().getYawSpeed() * this.pressingInterpolatedX.getSmooth());
        if (!this.field_70122_E) {
            this.setPitch(this.getPitch() + this.getProperties().getPitchSpeed() * this.pressingInterpolatedZ.getSmooth());
        }
        this.setPitch(this.getPitch() * (1.0f - this.getStabilizer()));
    }

    @Override
    protected void updateVelocity() {
        super.updateVelocity();
        if (this.field_70122_E) {
            this.setPitch((this.getPitch() + this.getProperties().getGroundPitch()) * 0.9f - this.getProperties().getGroundPitch());
        }
    }

    public float getEnginePower() {
        return (float)((double)this.enginePower.getSmooth() * Math.sqrt(this.getFuelUtilization()));
    }

    public float getEngineTarget() {
        return ((Float)this.field_70180_af.func_187225_a(ENGINE)).floatValue();
    }

    public void setEngineTarget(float engineTarget) {
        if (this.getFuelUtilization() > 0.0f || engineTarget == 0.0f) {
            if (this.field_70170_p.field_72995_K) {
                if (this.getEngineTarget() != engineTarget) {
                    NetworkHandler.sendToServer(new EnginePowerMessage(engineTarget));
                }
                if (this.getFuelUtilization() > 0.0f && (double)this.getEngineTarget() == 0.0 && engineTarget > 0.0f) {
                    this.field_70170_p.func_184134_a(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), this.getEngineStartSound(), this.func_184176_by(), 1.0f, this.getEnginePitch(), false);
                }
            }
            this.field_70180_af.func_187227_b(ENGINE, (Object)Float.valueOf(engineTarget));
        }
    }

    public static int getFuelTime(ItemStack fuel) {
        if (fuel.func_190926_b()) {
            return 0;
        }
        Item item = fuel.func_77973_b();
        if (cachedFuels == null) {
            cachedFuels = AbstractFurnaceTileEntity.func_214001_f();
        }
        if (Config.getInstance().acceptVanillaFuel && cachedFuels.containsKey(item)) {
            return cachedFuels.get(item);
        }
        return Config.getInstance().fuelList.getOrDefault(Registry.field_212630_s.func_177774_c((Object)item).toString(), 0);
    }

    public float getFuelUtilization() {
        if (Config.getInstance().fuelConsumption == 0.0f) {
            return 1.0f;
        }
        if (!Config.getInstance().burnFuelInCreative && this.func_184179_bs() instanceof PlayerEntity && ((PlayerEntity)this.func_184179_bs()).func_184812_l_()) {
            return 1.0f;
        }
        if (this.field_70170_p.field_72995_K) {
            return ((Float)this.field_70180_af.func_187225_a(UTILIZATION)).floatValue();
        }
        int running = 0;
        for (int i : this.fuel) {
            if (i <= 0) continue;
            ++running;
        }
        float utilization = (float)running / (float)this.fuel.length * (this.isFuelLow() ? 0.75f : 1.0f);
        this.field_70180_af.func_187227_b(UTILIZATION, (Object)Float.valueOf(utilization));
        return utilization;
    }

    public static enum GUI_STYLE {
        NONE,
        ENGINE;

    }

    protected static enum FuelState {
        NEVER,
        EMPTY,
        FUELED,
        LOW;

    }
}

