/*
 * Decompiled with CFR 0.152.
 */
package immersive_aircraft.entity;

import immersive_aircraft.Items;
import immersive_aircraft.Sounds;
import immersive_aircraft.entity.AircraftEntity;
import immersive_aircraft.entity.EngineAircraft;
import immersive_aircraft.entity.Rotorcraft;
import immersive_aircraft.entity.misc.AircraftProperties;
import immersive_aircraft.entity.misc.VehicleInventoryDescription;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class GyrodyneEntity
extends Rotorcraft {
    private static final float PUSH_SPEED = 0.25f;
    private final AircraftProperties properties = new AircraftProperties(this).setYawSpeed(5.0f).setPitchSpeed(5.0f).setEngineSpeed(0.3f).setVerticalSpeed(0.04f).setDriftDrag(0.01f).setLift(0.1f).setRollFactor(30.0f).setWindSensitivity(0.05f).setMass(4.0f);
    private static final VehicleInventoryDescription inventoryDescription = new VehicleInventoryDescription().addSlot(VehicleInventoryDescription.SlotType.WEAPON, 14, 14).addSlot(VehicleInventoryDescription.SlotType.UPGRADE, 36, 14).addSlot(VehicleInventoryDescription.SlotType.UPGRADE, 14, 36).addSlot(VehicleInventoryDescription.SlotType.UPGRADE, 36, 36).addSlots(VehicleInventoryDescription.SlotType.INVENTORY, 62, 8, 6, 3).build();
    final List<List<Vector3d>> PASSENGER_POSITIONS = Arrays.asList(Collections.singletonList(new Vector3d(0.0, (double)-0.1f, (double)0.3f)), Arrays.asList(new Vector3d(0.0, (double)-0.1f, (double)0.3f), new Vector3d(0.0, (double)-0.1f, (double)-0.6f)));

    @Override
    public VehicleInventoryDescription getInventoryDescription() {
        return inventoryDescription;
    }

    @Override
    public EngineAircraft.GUI_STYLE getGuiStyle() {
        return EngineAircraft.GUI_STYLE.NONE;
    }

    public GyrodyneEntity(EntityType<? extends AircraftEntity> entityType, World world) {
        super(entityType, world);
    }

    @Override
    protected SoundEvent getEngineStartSound() {
        return Sounds.WOOSH.get();
    }

    @Override
    protected SoundEvent getEngineSound() {
        return Sounds.WOOSH.get();
    }

    @Override
    protected float getStabilizer() {
        return 0.3f;
    }

    @Override
    public AircraftProperties getProperties() {
        return this.properties;
    }

    @Override
    protected float getGroundVelocityDecay() {
        return this.falloffGroundVelocityDecay(0.8f);
    }

    @Override
    protected float getHorizontalVelocityDelay() {
        return 0.925f;
    }

    @Override
    protected float getVerticalVelocityDelay() {
        return 0.9f;
    }

    @Override
    public Item asItem() {
        return Items.GYRODYNE.get();
    }

    @Override
    protected List<List<Vector3d>> getPassengerPositions() {
        return this.PASSENGER_POSITIONS;
    }

    @Override
    protected float getGravity() {
        return (1.0f - this.getEnginePower()) * super.getGravity();
    }

    private void updateEnginePowerTooltip() {
        if (this.func_184179_bs() instanceof ClientPlayerEntity && (double)this.getFuelUtilization() > 0.0) {
            ClientPlayerEntity player = (ClientPlayerEntity)this.func_184179_bs();
            player.func_146105_b((ITextComponent)new TranslationTextComponent("immersive_aircraft.gyrodyne_target", new Object[]{(int)(this.getEngineTarget() * 100.0f + 0.5f)}), true);
        }
    }

    @Override
    protected String getFuelType() {
        return "fat";
    }

    @Override
    protected boolean isFuelLow() {
        return false;
    }

    @Override
    protected void updateController() {
        super.updateController();
        if (this.getEngineTarget() < 1.0f) {
            this.setEngineTarget(Math.max(0.0f, Math.min(1.0f, this.getEngineTarget() + this.pressingInterpolatedZ.getValue() * 0.05f - 0.035f)));
            this.updateEnginePowerTooltip();
            if ((double)this.getEngineTarget() == 1.0 && this.func_184179_bs() instanceof ClientPlayerEntity) {
                ClientPlayerEntity player = (ClientPlayerEntity)this.func_184179_bs();
                player.func_146105_b((ITextComponent)new TranslationTextComponent("immersive_aircraft.gyrodyne_target_reached"), true);
                if (this.field_70122_E) {
                    this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, 0.25, 0.0));
                }
            }
        }
        float power = this.getEnginePower() * this.properties.getVerticalSpeed() * this.pressingInterpolatedY.getSmooth();
        this.func_213317_d(this.func_213322_ci().func_178787_e(this.getTopDirection().func_186678_a((double)power)));
        Vector3d direction = this.getDirection();
        float sin = MathHelper.func_76126_a((float)(this.getPitch() * ((float)Math.PI / 180)));
        float thrust = (float)(Math.pow(this.getEnginePower(), 2.0) * (double)this.properties.getEngineSpeed()) * sin;
        if (this.field_70122_E && (double)this.getEngineTarget() < 1.0) {
            thrust = 0.25f / (1.0f + (float)this.func_213322_ci().func_72433_c() * 5.0f) * this.pressingInterpolatedZ.getSmooth() * ((double)this.pressingInterpolatedZ.getSmooth() > 0.0 ? 1.0f : 0.5f) * this.getEnginePower();
        }
        this.func_213317_d(this.func_213322_ci().func_178787_e(direction.func_186678_a((double)thrust)));
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.func_184179_bs() instanceof ServerPlayerEntity) {
            float consumption = this.getFuelConsumption() * 0.025f;
            ((ServerPlayerEntity)this.func_184179_bs()).func_71024_bL().func_75113_a(consumption);
        }
    }

    @Override
    public float getFuelUtilization() {
        if (this.func_184179_bs() instanceof PlayerEntity && ((PlayerEntity)this.func_184179_bs()).func_71024_bL().func_75116_a() > 5) {
            return 1.0f;
        }
        return 0.0f;
    }
}

