/*
 * Decompiled with CFR 0.152.
 */
package immersive_aircraft.entity;

import immersive_aircraft.cobalt.network.NetworkHandler;
import immersive_aircraft.entity.AircraftEntity;
import immersive_aircraft.entity.VehicleEntity;
import immersive_aircraft.entity.misc.SparseSimpleInventory;
import immersive_aircraft.entity.misc.VehicleInventoryDescription;
import immersive_aircraft.item.UpgradeItem;
import immersive_aircraft.item.upgrade.AircraftStat;
import immersive_aircraft.network.s2c.OpenGuiRequest;
import immersive_aircraft.screen.VehicleScreenHandler;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.IInventoryChangedListener;
import net.minecraft.inventory.Inventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.IContainerListener;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import org.jetbrains.annotations.Nullable;

public abstract class InventoryVehicleEntity
extends VehicleEntity
implements IInventoryChangedListener,
INamedContainerProvider {
    protected SparseSimpleInventory inventory;
    private static final VehicleInventoryDescription inventoryDescription = new VehicleInventoryDescription().addSlot(VehicleInventoryDescription.SlotType.BOILER, 17, 18).build();
    protected int syncId;

    public VehicleInventoryDescription getInventoryDescription() {
        return inventoryDescription;
    }

    public List<ItemStack> getSlots(VehicleInventoryDescription.SlotType slotType) {
        List<VehicleInventoryDescription.Slot> slots = this.getInventoryDescription().getSlots(slotType);
        ArrayList<ItemStack> list = new ArrayList<ItemStack>(slots.size());
        for (VehicleInventoryDescription.Slot slot : slots) {
            list.add(this.getInventory().func_70301_a(slot.index));
        }
        return list;
    }

    public float getTotalUpgrade(AircraftStat stat) {
        float value = 1.0f;
        List<ItemStack> upgrades = this.getSlots(VehicleInventoryDescription.SlotType.UPGRADE);
        for (int step = 0; step < 2; ++step) {
            for (ItemStack stack : upgrades) {
                if (!(stack.func_77973_b() instanceof UpgradeItem)) continue;
                float u = ((UpgradeItem)stack.func_77973_b()).getUpgrade().get(stat);
                if (u > 0.0f && step == 1) {
                    value += u;
                    continue;
                }
                if (!(u < 0.0f) || step != 0) continue;
                value *= u + 1.0f;
            }
        }
        return Math.max(0.0f, value);
    }

    public InventoryVehicleEntity(EntityType<? extends AircraftEntity> entityType, World world) {
        super(entityType, world);
        this.initInventory();
    }

    protected void initInventory() {
        this.inventory = new SparseSimpleInventory(this.getInventoryDescription().getInventorySize());
        this.inventory.func_110134_a(this);
    }

    public void func_76316_a(IInventory sender) {
    }

    @Override
    protected void drop() {
        super.drop();
        if (this.inventory != null) {
            for (int i = 0; i < this.inventory.func_70302_i_(); ++i) {
                ItemStack itemStack = this.inventory.func_70301_a(i);
                if (itemStack.func_190926_b() || EnchantmentHelper.func_190939_c((ItemStack)itemStack)) continue;
                this.func_199701_a_(itemStack);
            }
        }
    }

    @Nullable
    public Container createMenu(int i, PlayerInventory playerInventory, PlayerEntity playerEntity) {
        return new VehicleScreenHandler(i, playerInventory, this);
    }

    public void openInventory(ServerPlayerEntity player) {
        this.syncId = (this.syncId + 1) % 100 + 100;
        Container screenHandler = this.createMenu(this.syncId, player.field_71071_by, (PlayerEntity)player);
        if (screenHandler != null) {
            NetworkHandler.sendToPlayer(new OpenGuiRequest(this, screenHandler.field_75152_c), player);
            player.field_71070_bA = screenHandler;
            player.field_71070_bA.func_75132_a((IContainerListener)player);
        }
    }

    @Override
    public ActionResultType func_184230_a(PlayerEntity player, Hand hand) {
        if (!player.field_70170_p.field_72995_K && player.func_226563_dT_()) {
            Entity primaryPassenger = this.getFirstPassenger();
            if (primaryPassenger != null) {
                primaryPassenger.func_184210_p();
            } else {
                this.openInventory((ServerPlayerEntity)player);
            }
            return ActionResultType.CONSUME;
        }
        return super.func_184230_a(player, hand);
    }

    public void func_70020_e(CompoundNBT nbt) {
        super.func_70020_e(nbt);
        ListNBT nbtList = nbt.func_150295_c("Inventory", 10);
        this.inventory.readNbt(nbtList);
    }

    public CompoundNBT func_189511_e(CompoundNBT nbt) {
        super.func_189511_e(nbt);
        nbt.func_218657_a("Inventory", (INBT)this.inventory.writeNbt(new ListNBT()));
        return nbt;
    }

    public Inventory getInventory() {
        return this.inventory;
    }

    @Override
    public void boost() {
        super.boost();
        this.getSlots(VehicleInventoryDescription.SlotType.BOOSTER).forEach(s -> s.func_190918_g(1));
    }

    @Override
    protected void applyBoost() {
        super.applyBoost();
        Vector3d direction = this.getDirection();
        float thrust = 0.05f * (float)this.getBoost() / 100.0f;
        this.func_213317_d(this.func_213322_ci().func_178787_e(direction.func_186678_a((double)thrust)));
        if (this.field_70173_aa % 2 == 0) {
            Vector3d p = this.func_213303_ch();
            Vector3d velocity = this.func_213322_ci().func_178788_d(direction);
            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197629_v, p.func_82615_a(), p.func_82617_b(), p.func_82616_c(), velocity.field_72450_a, velocity.field_72448_b, velocity.field_72449_c);
        }
    }

    @Override
    public boolean canBoost() {
        return this.getSlots(VehicleInventoryDescription.SlotType.BOOSTER).stream().anyMatch(v -> !v.func_190926_b()) && this.getBoost() <= 0;
    }

    @Override
    public void func_70071_h_() {
        this.inventory.tick(this);
        super.func_70071_h_();
    }

    @Override
    protected float getDurability() {
        return super.getDurability() * this.getTotalUpgrade(AircraftStat.DURABILITY);
    }
}

